/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.simulator.internal;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.simulator.internal.Messages;
import org.eclipse.ptp.cell.simulator.internal.SimulatorControl;
import org.eclipse.ptp.cell.utils.stream.ILineStreamListener;

class StdoutListener
implements ILineStreamListener {
    SimulatorControl control;

    public StdoutListener(SimulatorControl control) {
        this.control = control;
    }

    public void newLine(String line) {
        if (line.startsWith("||| ") && line.endsWith(" |||")) {
            String command = "";
            String message = "";
            int div = line.indexOf(":");
            if (div >= 0) {
                command = line.substring(4, div).trim();
                message = line.substring(div + 1, line.length() - 4).trim();
            }
            if (command.equals("SIMULATOR")) {
                if (message.equalsIgnoreCase("Start")) {
                    this.control.notifyEvent(1);
                } else if (message.equalsIgnoreCase("Stop")) {
                    this.control.notifyEvent(2);
                } else {
                    this.handleUnknownEvent(command, message);
                }
            } else if (command.equals("INIT")) {
                if (message.equalsIgnoreCase("Parse")) {
                    this.control.notifyEvent(100);
                } else if (message.equalsIgnoreCase("Check")) {
                    this.control.notifyEvent(101);
                } else if (message.equalsIgnoreCase("Configure")) {
                    this.control.notifyEvent(103);
                } else if (message.equalsIgnoreCase("Bogusnet")) {
                    this.control.notifyEvent(104);
                } else if (message.equalsIgnoreCase("Console")) {
                    this.control.notifyEvent(105);
                } else if (message.equalsIgnoreCase("Configured")) {
                    this.control.notifyEvent(107);
                } else {
                    this.handleUnknownEvent(command, message);
                }
            } else if (command.equals("BOOT")) {
                if (message.equalsIgnoreCase("Bios")) {
                    this.control.notifyEvent(110);
                } else if (message.equalsIgnoreCase("Linux")) {
                    this.control.notifyEvent(111);
                } else if (message.equalsIgnoreCase("System")) {
                    this.control.notifyEvent(112);
                } else if (message.equalsIgnoreCase("Configure")) {
                    this.control.notifyEvent(113);
                } else if (message.equalsIgnoreCase("Complete")) {
                    this.control.notifyEvent(114);
                } else {
                    this.handleUnknownEvent(command, message);
                }
            } else if (command.equals("SHUTDOWN")) {
                if (message.equalsIgnoreCase("Prepared")) {
                    this.control.notifyEvent(200);
                } else if (message.equalsIgnoreCase("Started")) {
                    this.control.notifyEvent(201);
                } else if (message.equalsIgnoreCase("Complete")) {
                    this.control.notifyEvent(202);
                } else {
                    this.handleUnknownEvent(command, message);
                }
            } else if (command.equals("ERROR")) {
                this.control.notifyError(message);
            } else {
                this.handleUnknownEvent(command, message);
            }
        } else {
            this.forwardLine(line);
        }
    }

    private void forwardLine(String line) {
        this.control.receiveProcessLine(line);
    }

    private void handleUnknownEvent(String command, String message) {
        System.err.println(NLS.bind((String)Messages.StdoutListener_UnknownEvent, (Object[])new String[]{command, message}));
    }

    public void streamClosed() {
        this.control.notifyEvent(301);
    }

    public void streamError(Exception e) {
        this.control.notifyEvent(301);
    }
}

