/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.services.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.rdt.services.core.messages.Messages;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceProvider
extends PlatformObject
implements IServiceProvider,
IServiceProviderDescriptor {
    private IServiceProviderDescriptor fDescriptor;
    private final HashMap<String, String> fAttributes = new HashMap();

    public ServiceProvider() {
    }

    public ServiceProvider(ServiceProvider provider) {
        this.setDescriptor(provider.getDescriptor());
        this.fAttributes.putAll(provider.getAttributes());
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.fAttributes);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.getString(key, null);
        boolean result = defaultValue;
        if (value != null) {
            result = Boolean.parseBoolean(value);
        }
        return result;
    }

    @Override
    public String getConfigurationString() {
        return this.isConfigured() ? Messages.ServiceProvider_0 : Messages.ServiceProvider_1;
    }

    public IServiceProviderDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    @Override
    public String getId() {
        if (this.fDescriptor == null) {
            return null;
        }
        return this.fDescriptor.getId();
    }

    @Override
    public int getInt(String key, int defaultValue) {
        String value = this.getString(key, null);
        int result = defaultValue;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    @Override
    public String getName() {
        if (this.fDescriptor == null) {
            return null;
        }
        return this.fDescriptor.getName();
    }

    @Override
    public Integer getPriority() {
        if (this.fDescriptor == null) {
            return null;
        }
        return this.fDescriptor.getPriority();
    }

    @Override
    public String getServiceId() {
        if (this.fDescriptor == null) {
            return null;
        }
        return this.fDescriptor.getServiceId();
    }

    @Override
    public String getString(String key, String defaultValue) {
        String value = this.fAttributes.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public void putBoolean(String key, boolean value) {
        String strVal = Boolean.toString(value);
        this.putString(key, strVal);
    }

    @Override
    public void putInt(String key, int value) {
        String strVal = Integer.toString(value);
        this.putString(key, strVal);
    }

    @Override
    public void putString(String key, String value) {
        this.fAttributes.put(key, value);
    }

    @Override
    public Set<String> keySet() {
        return this.fAttributes.keySet();
    }

    public void restoreState(IMemento memento) {
        this.fAttributes.clear();
        String[] stringArray = memento.getAttributeKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.fAttributes.put(key, memento.getString(key));
            ++n2;
        }
    }

    public void saveState(IMemento memento) {
        for (String key : this.fAttributes.keySet()) {
            memento.putString(key, this.fAttributes.get(key));
        }
    }

    public void setDescriptor(IServiceProviderDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fDescriptor == null ? 0 : this.fDescriptor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceProvider other = (ServiceProvider)obj;
        return !(this.fDescriptor == null ? other.fDescriptor != null : !this.fDescriptor.equals(other.fDescriptor));
    }
}

