/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.callhierarchy;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.internal.ui.callhierarchy.CHMessages;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.ICallHierarchyService;
import org.eclipse.ptp.internal.rdt.ui.callhierarchy.CallHierarchyUtil;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.services.core.ServiceModelManager;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenCallHierarchyAction
extends SelectionDispatchAction {
    private ITextEditor fEditor;

    public OpenCallHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(CHMessages.OpenCallHierarchyAction_label);
        this.setToolTipText(CHMessages.OpenCallHierarchyAction_tooltip);
    }

    public OpenCallHierarchyAction(ITextEditor editor) {
        this((IWorkbenchSite)editor.getSite());
        this.fEditor = editor;
        this.setEnabled(this.fEditor != null && CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput()) != null);
    }

    public void run(ITextSelection sel) {
        if (this.fEditor instanceof CEditor) {
            IService indexingService;
            IProject project = ((CEditor)this.fEditor).getInputCElement().getCProject().getProject();
            ServiceModelManager smm = ServiceModelManager.getInstance();
            IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project);
            IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
            if (serviceProvider instanceof IIndexServiceProvider) {
                ICallHierarchyService chService = ((IIndexServiceProvider)serviceProvider).getCallHierarchyService();
                CallHierarchyUtil.open(chService, this.fEditor, sel);
            }
        }
    }

    public void run(IStructuredSelection selection) {
        Object selectedObject;
        ICElement elem;
        if (!selection.isEmpty() && (elem = (ICElement)this.getAdapter(selectedObject = selection.getFirstElement(), ICElement.class)) != null) {
            IService indexingService;
            IProject project = elem.getCProject().getProject();
            ServiceModelManager smm = ServiceModelManager.getInstance();
            IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project);
            IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
            if (serviceProvider instanceof IIndexServiceProvider) {
                ICallHierarchyService chService = ((IIndexServiceProvider)serviceProvider).getCallHierarchyService();
                CallHierarchyUtil.open(chService, this.getSite().getWorkbenchWindow(), elem);
            }
        }
    }

    public void selectionChanged(ITextSelection sel) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        Object selectedObject = selection.getFirstElement();
        ICElement elem = (ICElement)this.getAdapter(selectedObject, ICElement.class);
        if (elem != null) {
            this.setEnabled(this.isValidElement(elem));
        } else {
            this.setEnabled(false);
        }
    }

    private boolean isValidElement(ICElement elem) {
        if (elem instanceof IFunctionDeclaration) {
            return true;
        }
        if (elem instanceof IVariableDeclaration) {
            return !(elem instanceof IEnumeration);
        }
        return elem instanceof IEnumerator;
    }

    private Object getAdapter(Object object, Class desiredClass) {
        if (desiredClass.isInstance(object)) {
            return object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)object;
            return adaptable.getAdapter(desiredClass);
        }
        return null;
    }
}

