/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.internal.rdt.core.miners.ScopeManager;
import org.eclipse.ptp.rdt.core.miners.IURICreator;

public class URICreatorManager {
    private static URICreatorManager fInstance;
    private Map<String, IURICreator> fCreatorsMap = new HashMap<String, IURICreator>();
    private DataStore fDataStore;

    private URICreatorManager(DataStore datastore) {
        this.fDataStore = datastore;
        this.loadExtensions();
    }

    private void loadExtensions() {
        String pluginDir = this.fDataStore.getAttribute(0);
        String dataFile = String.valueOf(pluginDir) + File.separator + "URICreator.dat";
        if (!this.loadCreators("UTF-8", dataFile)) {
            this.loadCreators(null, dataFile);
        }
    }

    private boolean loadCreators(String encoding, String filename) {
        String line;
        FileInputStream datafile;
        try {
            datafile = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        BufferedReader reader = null;
        if (encoding == null) {
            reader = new BufferedReader(new InputStreamReader(datafile));
        } else {
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)datafile, encoding));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return false;
            }
        }
        try {
            line = reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        String scheme = null;
        while (line != null) {
            if (!(line = line.trim()).startsWith("#")) {
                String[] tokens = line.split(",");
                if (tokens.length < 2) {
                    return false;
                }
                scheme = tokens[0];
                IURICreator creator = this.loadCreator(tokens[1]);
                if (creator != null) {
                    this.fCreatorsMap.put(scheme, creator);
                }
            }
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IURICreator loadCreator(String string) {
        Class<?> theClass;
        try {
            theClass = Class.forName(string);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        try {
            Constructor<?> constructor = theClass.getConstructor(new Class[0]);
            try {
                IURICreator creator = (IURICreator)constructor.newInstance(new Object[0]);
                if (creator == null) return null;
                return creator;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return null;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                return null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized URICreatorManager getDefault(DataStore datastore) {
        if (fInstance == null) {
            fInstance = new URICreatorManager(datastore);
        }
        return fInstance;
    }

    public URI createURI(String scheme, String host, String path) throws URISyntaxException {
        ScopeManager scopeManager = ScopeManager.getInstance();
        String mappedPath = scopeManager.getMappedPathForFile(path);
        String fileHost = scopeManager.getHostForFile(path, host);
        IURICreator creator = this.fCreatorsMap.get(scheme);
        if (creator != null) {
            return creator.createURIForScheme(scheme, fileHost, path, mappedPath);
        }
        return new URI(scheme, host, path, null);
    }
}

