/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ptp.internal.rdt.core.model.CElementInfo;
import org.eclipse.ptp.internal.rdt.core.model.IHasManagedLocation;
import org.eclipse.ptp.internal.rdt.core.model.Path;
import org.eclipse.ptp.rdt.core.RDTLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CElement
implements ICElement,
Serializable,
IHasManagedLocation {
    private static final long serialVersionUID = 1L;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected CElementInfo fInfo;
    protected ICElement fParent;
    protected String fName;
    protected int fType;
    protected URI fLocation;
    protected URI fManagedLocation;
    protected IPath fWorkspacePath;
    protected ICProject fCProject;

    public CElement(ICElement parent, int type, String name) {
        this.fParent = parent;
        this.fType = type;
        this.fName = name;
    }

    public void accept(ICElementVisitor visitor) throws CoreException {
    }

    public boolean exists() {
        return true;
    }

    public ICElement getAncestor(int ancestorType) {
        ICElement parent = this.getParent();
        while (parent != null) {
            if (parent.getElementType() == ancestorType) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public ICModel getCModel() {
        return null;
    }

    public ICProject getCProject() {
        return this.fCProject;
    }

    public String getElementName() {
        return this.fName;
    }

    public int getElementType() {
        return this.fType;
    }

    public URI getLocationURI() {
        return this.fLocation;
    }

    public ICElement getParent() {
        return this.fParent;
    }

    public IPath getPath() {
        return this.fWorkspacePath;
    }

    public IResource getResource() {
        IFile[] files;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (this.fLocation != null && (files = root.findFilesForLocationURI(this.fLocation)).length > 0) {
            return files[0];
        }
        if (this.fWorkspacePath != null && (files = root.findFilesForLocation(this.fWorkspacePath)).length > 0) {
            return files[0];
        }
        return null;
    }

    public IResource getUnderlyingResource() {
        return null;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isStructureKnown() throws CModelException {
        return false;
    }

    public String getHandleIdentifier() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public CElementInfo getElementInfo() {
        if (this.fInfo == null) {
            this.fInfo = new CElementInfo(this);
        }
        return this.fInfo;
    }

    protected List<ICElement> internalGetChildren() {
        return Collections.emptyList();
    }

    protected String[] extractParameterTypes(IFunction func) throws DOMException {
        IParameter[] params = func.getParameters();
        String[] parameterTypes = new String[params.length];
        int i = 0;
        while (i < params.length) {
            IParameter param = params[i];
            parameterTypes[i] = ASTTypeUtil.getType((IType)param.getType());
            ++i;
        }
        if (parameterTypes.length == 1 && parameterTypes[0].equals("void")) {
            return EMPTY_STRING_ARRAY;
        }
        return parameterTypes;
    }

    protected String[] extractTemplateParameterTypes(ICPPTemplateDefinition template) throws DOMException {
        ICPPTemplateParameter[] parameters = template.getTemplateParameters();
        String[] types = new String[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            ICPPTemplateParameter parameter = parameters[i];
            types[i] = parameter.getName();
            ++i;
        }
        return types;
    }

    protected ASTAccessVisibility getVisibility(IBinding binding) {
        if (binding instanceof ICPPMember) {
            ICPPMember member = (ICPPMember)binding;
            try {
                switch (member.getVisibility()) {
                    case 3: {
                        return ASTAccessVisibility.PRIVATE;
                    }
                    case 2: {
                        return ASTAccessVisibility.PROTECTED;
                    }
                    case 1: {
                        return ASTAccessVisibility.PUBLIC;
                    }
                }
            }
            catch (DOMException e) {
                RDTLog.logError(e);
            }
        }
        return ASTAccessVisibility.PUBLIC;
    }

    public void setLocationURI(URI location) {
        this.fLocation = location;
    }

    @Override
    public void setManagedLocation(URI managedLocation) {
        this.fManagedLocation = managedLocation;
    }

    @Override
    public URI getManagedLocation() {
        return this.fManagedLocation;
    }

    public void setPath(IPath path) {
        this.fWorkspacePath = path == null || path instanceof Path ? path : new Path(path.toPortableString());
    }

    public void setCProject(ICProject project) {
        this.fCProject = project;
    }

    public String toString() {
        return "[" + this.getCProject() + "]" + this.getElementName() + " " + this.getClass().getName();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ICElement)) {
            return false;
        }
        ICElement other = (ICElement)o;
        String name = other.getElementName();
        if (!this.fName.equals(name)) {
            return false;
        }
        if (this.fType != other.getElementType()) {
            return false;
        }
        URI location = other.getLocationURI();
        if (this.fLocation != null && !this.fLocation.equals(location)) {
            return false;
        }
        ICElement parent = other.getParent();
        return this.fParent == null || this.fParent.equals(parent);
    }

    public int hashCode() {
        int hash = this.fName.hashCode();
        hash += 31 * this.fType;
        if (this.fLocation != null) {
            hash += 47 * this.fLocation.hashCode();
        }
        return hash;
    }
}

