/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.CPPVariableReadWriteFlags;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPVariable
extends PDOMCPPBinding
implements ICPPVariable {
    private static final int TYPE_OFFSET = 28;
    protected static final int ANNOTATIONS = 32;
    protected static final int RECORD_SIZE = 33;

    public PDOMCPPVariable(PDOM pdom, PDOMNode parent, IVariable variable) throws CoreException {
        super(pdom, parent, variable.getNameCharArray());
        try {
            Database db = pdom.getDB();
            this.setType(parent.getLinkageImpl(), variable.getType());
            db.putByte(this.record + 32, this.encodeFlags(variable));
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus((Throwable)e));
        }
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof IVariable) {
            IVariable var = (IVariable)newBinding;
            IType mytype = this.getType();
            try {
                IType newType = var.getType();
                this.setType(linkage, newType);
                this.pdom.getDB().putByte(this.record + 32, PDOMCPPAnnotation.encodeAnnotation(var));
                if (mytype != null) {
                    linkage.deleteType(mytype, this.record);
                }
            }
            catch (DOMException e) {
                throw new CoreException(Util.createStatus((Throwable)e));
            }
        }
    }

    private void setType(PDOMLinkage linkage, IType newType) throws CoreException, DOMException {
        PDOMNode typeNode = linkage.addType(this, newType);
        this.pdom.getDB().putInt(this.record + 28, typeNode != null ? typeNode.getRecord() : 0);
    }

    protected byte encodeFlags(IVariable variable) throws DOMException {
        return PDOMCPPAnnotation.encodeAnnotation(variable);
    }

    public PDOMCPPVariable(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 33;
    }

    public int getNodeType() {
        return 6;
    }

    public boolean isMutable() throws DOMException {
        return false;
    }

    public IType getType() {
        try {
            int typeRec = this.pdom.getDB().getInt(this.record + 28);
            return (IType)((Object)this.getLinkageImpl().getNode(typeRec));
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    public boolean isAuto() throws DOMException {
        return this.getBit(this.getByte(this.record + 32), 0);
    }

    public boolean isExtern() throws DOMException {
        return this.getBit(this.getByte(this.record + 32), 1);
    }

    public boolean isExternC() throws DOMException {
        return this.getBit(this.getByte(this.record + 32), 6);
    }

    public boolean isRegister() throws DOMException {
        return this.getBit(this.getByte(this.record + 32), 3);
    }

    public boolean isStatic() throws DOMException {
        return this.getBit(this.getByte(this.record + 32), 4);
    }

    public int getAdditionalNameFlags(int standardFlags, IASTName name) {
        if ((standardFlags & 3) == 3) {
            return CPPVariableReadWriteFlags.getReadWriteFlags(name);
        }
        return 0;
    }
}

