/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;

public class CodeReader {
    public static final String SYSTEM_DEFAULT_ENCODING = System.getProperty("file.encoding");
    private static final String NF = "<text>";
    private static final char[] NOFILE = "<text>".toCharArray();
    private static final int MAX_FILE_SIZE = Integer.MAX_VALUE;
    public final char[] buffer;
    public final char[] filename;

    public CodeReader(String filename, char[] buffer) {
        this.filename = filename.toCharArray();
        this.buffer = buffer;
    }

    public CodeReader(char[] buffer) {
        this(NF, buffer);
    }

    public CodeReader(String filename) throws IOException {
        this.filename = filename.toCharArray();
        FileInputStream stream = new FileInputStream(filename);
        try {
            this.buffer = this.load(SYSTEM_DEFAULT_ENCODING, stream);
        }
        finally {
            stream.close();
        }
    }

    public CodeReader(String filename, String charSet) throws IOException {
        this.filename = filename.toCharArray();
        FileInputStream stream = new FileInputStream(filename);
        try {
            this.buffer = this.load(charSet, stream);
        }
        finally {
            stream.close();
        }
    }

    public CodeReader(String filename, InputStream stream) throws IOException {
        this(filename, SYSTEM_DEFAULT_ENCODING, stream);
    }

    public CodeReader(String fileName, String charSet, InputStream stream) throws IOException {
        this.filename = fileName.toCharArray();
        FileInputStream fstream = stream instanceof FileInputStream ? (FileInputStream)stream : new FileInputStream(fileName);
        try {
            this.buffer = this.load(charSet, fstream);
        }
        finally {
            if (!(stream instanceof FileInputStream)) {
                fstream.close();
            }
        }
    }

    private char[] load(String charSet, FileInputStream stream) throws IOException {
        char[] buff;
        String encoding = Charset.isSupported(charSet) ? charSet : SYSTEM_DEFAULT_ENCODING;
        FileChannel channel = stream.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)Math.min(channel.size(), Integer.MAX_VALUE));
        channel.read(byteBuffer);
        byteBuffer.flip();
        CharBuffer charBuffer = Charset.forName(encoding).decode(byteBuffer);
        if (charBuffer.hasArray() && charBuffer.arrayOffset() == 0 && (buff = charBuffer.array()).length == charBuffer.remaining()) {
            return buff;
        }
        buff = new char[charBuffer.remaining()];
        charBuffer.get(buff);
        return buff;
    }

    protected char[] xload(FileInputStream stream) throws IOException {
        FileChannel channel = stream.getChannel();
        MappedByteBuffer map = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        CharBuffer charBuffer = Charset.forName(SYSTEM_DEFAULT_ENCODING).decode(map);
        if (charBuffer.hasArray()) {
            return charBuffer.array();
        }
        char[] buff = new char[charBuffer.length()];
        charBuffer.get(buff);
        return buff;
    }

    public boolean isFile() {
        return !CharArrayUtils.equals(this.filename, NOFILE);
    }

    public String toString() {
        return this.getPath();
    }

    public String getPath() {
        return new String(this.filename);
    }
}

