/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDeferredTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameterSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPDeferredFunctionInstance
extends CPPInstance
implements ICPPFunction,
ICPPInternalFunction,
ICPPDeferredTemplateInstance {
    private IParameter[] parameters;
    private IType[] arguments;
    private IFunctionType functionType;

    public CPPDeferredFunctionInstance(ICPPFunctionTemplate template, IType[] arguments) {
        super(null, template, null, arguments);
        this.arguments = arguments;
        this.argumentMap = this.createArgumentMap(arguments);
    }

    private ObjectMap createArgumentMap(IType[] args) {
        ICPPTemplateParameter[] params;
        ICPPTemplateDefinition template = this.getTemplateDefinition();
        try {
            params = template.getTemplateParameters();
        }
        catch (DOMException dOMException) {
            return null;
        }
        ObjectMap map = new ObjectMap(params.length);
        int i = 0;
        while (i < params.length) {
            if (i < args.length) {
                map.put(params[i], args[i]);
            }
            ++i;
        }
        return map;
    }

    public IType[] getArguments() {
        return this.arguments;
    }

    public IParameter[] getParameters() throws DOMException {
        if (this.getArgumentMap() == null) {
            return ((ICPPFunction)((Object)this.getTemplateDefinition())).getParameters();
        }
        if (this.parameters == null) {
            IParameter[] params = ((ICPPFunction)((Object)this.getTemplateDefinition())).getParameters();
            this.parameters = new IParameter[params.length];
            int i = 0;
            while (i < params.length) {
                this.parameters[i] = new CPPParameterSpecialization((ICPPParameter)params[i], null, this.getArgumentMap());
                ++i;
            }
        }
        return this.parameters;
    }

    public IScope getFunctionScope() {
        return null;
    }

    public IFunctionType getType() throws DOMException {
        if (this.functionType == null) {
            IFunctionType ft = ((ICPPFunction)((Object)this.getTemplateDefinition())).getType();
            IType returnType = ft.getReturnType();
            returnType = CPPTemplates.instantiateType(returnType, this.getArgumentMap(), null);
            this.functionType = CPPVisitor.createImplicitFunctionType(returnType, this.getParameters(), null);
        }
        return this.functionType;
    }

    public boolean isStatic() throws DOMException {
        return ((ICPPFunction)((Object)this.getTemplateDefinition())).isStatic();
    }

    public boolean isMutable() throws DOMException {
        return ((ICPPFunction)((Object)this.getTemplateDefinition())).isMutable();
    }

    public boolean isInline() throws DOMException {
        return ((ICPPFunction)((Object)this.getTemplateDefinition())).isInline();
    }

    public boolean isExternC() throws DOMException {
        return ((ICPPFunction)((Object)this.getTemplateDefinition())).isExternC();
    }

    public boolean isExtern() throws DOMException {
        return ((ICPPFunction)((Object)this.getTemplateDefinition())).isExtern();
    }

    public boolean isAuto() throws DOMException {
        return ((ICPPFunction)((Object)this.getTemplateDefinition())).isAuto();
    }

    public boolean isRegister() throws DOMException {
        return ((ICPPFunction)((Object)this.getTemplateDefinition())).isRegister();
    }

    public boolean takesVarArgs() throws DOMException {
        return ((ICPPFunction)((Object)this.getTemplateDefinition())).takesVarArgs();
    }

    public boolean isStatic(boolean resolveAll) {
        try {
            return ASTInternal.isStatic((IFunction)((Object)this.getTemplateDefinition()), resolveAll);
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    public IBinding resolveParameter(IASTParameterDeclaration param) {
        return null;
    }
}

