/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCFunctionType;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPFunctionType
extends PDOMCFunctionType
implements ICPPFunctionType {
    private static final int THIS_TYPE = 16;
    private static final int RECORD_SIZE = 20;
    IPointerType thisType;

    protected PDOMCPPFunctionType(PDOM pdom, int offset) {
        super(pdom, offset);
    }

    protected PDOMCPPFunctionType(PDOM pdom, PDOMNode parent, ICPPFunctionType type) throws CoreException {
        super(pdom, parent, type);
        this.setThisType(type.getThisType());
    }

    private void setThisType(IPointerType type) throws CoreException {
        PDOMNode typeNode = this.getLinkageImpl().addType(this, type);
        if (typeNode != null) {
            this.pdom.getDB().putInt(this.record + 16, typeNode.getRecord());
        }
    }

    public IPointerType getThisType() {
        if (this.thisType == null) {
            try {
                PDOMNode node = this.getLinkageImpl().getNode(this.pdom.getDB().getInt(this.record + 16));
                if (node instanceof IPointerType) {
                    this.thisType = (IPointerType)((Object)node);
                }
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
            }
        }
        return this.thisType;
    }

    public final boolean isConst() {
        return this.getThisType() != null && this.getThisType().isConst();
    }

    public final boolean isVolatile() {
        return this.getThisType() != null && this.getThisType().isVolatile();
    }

    protected int getRecordSize() {
        return 20;
    }

    public boolean isSameType(IType type) {
        if (type instanceof ICPPFunctionType && super.isSameType(type)) {
            ICPPFunctionType ft = (ICPPFunctionType)type;
            return this.isConst() == ft.isConst() && this.isVolatile() == ft.isVolatile();
        }
        return false;
    }

    public int getNodeType() {
        return 44;
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }
}

