/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.CVariableReadWriteFlags;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCAnnotation;
import org.eclipse.core.runtime.CoreException;

class PDOMCVariable
extends PDOMBinding
implements IVariable {
    private static final int TYPE_OFFSET = 28;
    private static final int ANNOTATIONS = 32;
    protected static final int RECORD_SIZE = 33;

    public PDOMCVariable(PDOM pdom, PDOMNode parent, IVariable variable) throws CoreException {
        super(pdom, parent, variable.getNameCharArray());
        try {
            this.setType(parent.getLinkageImpl(), variable.getType());
            pdom.getDB().putByte(this.record + 32, PDOMCAnnotation.encodeAnnotation(variable));
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus((Throwable)e));
        }
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof IVariable) {
            IVariable var = (IVariable)newBinding;
            IType mytype = this.getType();
            try {
                IType newType = var.getType();
                this.setType(linkage, newType);
                if (mytype != null) {
                    linkage.deleteType(mytype, this.record);
                }
                this.pdom.getDB().putByte(this.record + 32, PDOMCAnnotation.encodeAnnotation(var));
            }
            catch (DOMException e) {
                throw new CoreException(Util.createStatus((Throwable)e));
            }
        }
    }

    private void setType(PDOMLinkage linkage, IType type) throws CoreException {
        PDOMNode typeNode = linkage.addType(this, type);
        this.pdom.getDB().putInt(this.record + 28, typeNode != null ? typeNode.getRecord() : 0);
    }

    public PDOMCVariable(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 33;
    }

    public int getNodeType() {
        return 6;
    }

    public IType getType() {
        try {
            int typeRec = this.pdom.getDB().getInt(this.record + 28);
            return (IType)((Object)this.getLinkageImpl().getNode(typeRec));
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    public boolean isStatic() throws DOMException {
        return this.getBit(this.getByte(this.record + 32), 4);
    }

    public boolean isExtern() throws DOMException {
        return this.getBit(this.getByte(this.record + 32), 1);
    }

    public boolean isAuto() throws DOMException {
        return this.getBit(this.getByte(this.record + 32), 0);
    }

    public boolean isRegister() throws DOMException {
        return this.getBit(this.getByte(this.record + 32), 3);
    }

    public int getAdditionalNameFlags(int standardFlags, IASTName name) {
        if ((standardFlags & 3) == 3) {
            return CVariableReadWriteFlags.getReadWriteFlags(name);
        }
        return 0;
    }
}

