/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.tau.selinst.popup.actions;

import java.util.LinkedHashSet;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ptp.perf.tau.selinst.Selector;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class AtomicInstrument
implements IEditorActionDelegate {
    CEditor textEditor;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.textEditor = (CEditor)targetEditor;
    }

    public void run(IAction action) {
        ICElement cele = this.textEditor.getInputCElement();
        ICProject cproject = cele.getCProject();
        String location = cproject.getResource().getLocation().toOSString();
        int insertregs = 0;
        ITextSelection ts = (ITextSelection)this.textEditor.getSelectionProvider().getSelection();
        insertregs = ts.getStartLine() + 1;
        class ValidateName
        implements IInputValidator {
            ValidateName() {
            }

            public String isValid(String newText) {
                if (newText.equals("")) {
                    return "Please enter valid text";
                }
                return null;
            }
        }
        InputDialog namedialog = new InputDialog(CUIPlugin.getActiveWorkbenchShell(), "User Defined Event Name", "Please enter a unique name to associate with this user defined event", "", (IInputValidator)new ValidateName());
        if (namedialog.open() == 1) {
            return;
        }
        String testline = namedialog.getValue();
        class ValidateValue
        implements IInputValidator {
            ValidateValue() {
            }

            public String isValid(String newText) {
                String err = "Please enter a valid double or variable name";
                if (newText.equals("")) {
                    return err;
                }
                String fixed = newText.replaceAll("\\W", "");
                if (!newText.equals(fixed)) {
                    if (newText.length() - fixed.length() == 1 && newText.indexOf(".") >= 0 && fixed.replaceAll("\\d", "").equals("")) {
                        return null;
                    }
                    return err;
                }
                return null;
            }
        }
        InputDialog incdialog = new InputDialog(CUIPlugin.getActiveWorkbenchShell(), "User Defined Event Value", "Please enter a static value or available numeric variable", "", (IInputValidator)new ValidateValue());
        if (incdialog.open() == 1) {
            return;
        }
        String testinc = incdialog.getValue();
        String fixline = testline.replaceAll("\\W", "");
        LinkedHashSet<String> instlines = new LinkedHashSet<String>();
        String regline = "TAU_REGISTER_EVENT(TAU__" + fixline + ", \\\"" + testline + "\\\");";
        String evtline = "TAU_EVENT(TAU__" + fixline + ", " + testinc + ");";
        String nosselregline = "file =\"" + cele.getElementName() + "\" line=" + insertregs + " code=\"" + regline + " " + evtline + "\"";
        instlines.add(nosselregline);
        Selector selectinst = new Selector(location);
        selectinst.addInst(instlines);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
    }
}

