/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIChangedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.manager.IPDISignalManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDISignal;
import org.eclipse.ptp.debug.core.pdi.model.IPDISignalDescriptor;
import org.eclipse.ptp.debug.core.pdi.request.IPDICommandRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIListSignalsRequest;
import org.eclipse.ptp.debug.internal.core.pdi.manager.AbstractPDIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalManager
extends AbstractPDIManager
implements IPDISignalManager {
    private IPDISignal[] EMPTY_SIGNALS = new IPDISignal[0];
    private Map<BitList, List<IPDISignal>> signalsMap = new Hashtable<BitList, List<IPDISignal>>();

    public SignalManager(IPDISession session) {
        super(session, false);
    }

    @Override
    public IPDISignal[] getSignals(BitList qTasks) throws PDIException {
        List<IPDISignal> signalsList = this.signalsMap.get(qTasks);
        if (signalsList == null) {
            this.update(qTasks);
        }
        if ((signalsList = this.signalsMap.get(qTasks)) != null) {
            return signalsList.toArray(new IPDISignal[0]);
        }
        return this.EMPTY_SIGNALS;
    }

    @Override
    public void handle(IPDISignal sig, boolean isIgnore, boolean isStop) throws PDIException {
        StringBuffer buffer = new StringBuffer(sig.getName());
        buffer.append(" ");
        if (isIgnore) {
            buffer.append("ignore");
        } else {
            buffer.append("noignore");
        }
        buffer.append(" ");
        if (isStop) {
            buffer.append("stop");
        } else {
            buffer.append("nostop");
        }
        IPDICommandRequest request = this.session.getRequestFactory().getCommandRequest(sig.getTasks(), buffer.toString());
        this.session.getEventRequestManager().addEventRequest(request);
        request.waitUntilCompleted(sig.getTasks());
        sig.setHandle(isIgnore, isStop);
        this.session.getEventManager().fireEvents(new IPDIEvent[]{this.session.getEventFactory().newChangedEvent(this.session.getEventFactory().newSignalInfo(this.session, sig.getTasks(), sig.getName(), sig.getDescription(), sig, null))});
    }

    @Override
    public void shutdown() {
        this.signalsMap.clear();
    }

    @Override
    public void update(BitList qTasks) throws PDIException {
        IPDISignalDescriptor[] new_sigs = this.createSignals(qTasks);
        ArrayList<IPDIChangedEvent> eventList = new ArrayList<IPDIChangedEvent>(new_sigs.length);
        List<IPDISignal> signalsList = this.getSignalsList(qTasks);
        int i = 0;
        while (i < new_sigs.length) {
            IPDISignal sig = this.findSignal(qTasks, new_sigs[i].getName());
            if (sig != null) {
                if (this.hasSignalChanged(sig, new_sigs[i])) {
                    sig.setDescriptor(new_sigs[i]);
                    eventList.add(this.session.getEventFactory().newChangedEvent(this.session.getEventFactory().newSignalInfo(this.session, qTasks, sig.getName(), sig.getDescription(), sig, null)));
                }
            } else {
                signalsList.add(this.session.getModelFactory().newSignal(this.session, qTasks, new_sigs[i]));
            }
            ++i;
        }
        IPDIEvent[] events = eventList.toArray(new IPDIEvent[0]);
        this.session.getEventManager().fireEvents(events);
    }

    private IPDISignalDescriptor[] createSignals(BitList qTasks) throws PDIException {
        return this.createSignals(qTasks, null);
    }

    private IPDISignalDescriptor[] createSignals(BitList qTasks, String name) throws PDIException {
        IPDIListSignalsRequest request = this.session.getRequestFactory().getListSignalsRequest(this.session, qTasks, name);
        this.session.getEventRequestManager().addEventRequest(request);
        return request.getSignals(qTasks);
    }

    private synchronized List<IPDISignal> getSignalsList(BitList qTasks) {
        List<IPDISignal> signalsList = this.signalsMap.get(qTasks);
        if (signalsList == null) {
            signalsList = Collections.synchronizedList(new ArrayList());
            this.signalsMap.put(qTasks, signalsList);
        }
        return signalsList;
    }

    private boolean hasSignalChanged(IPDISignal sig, IPDISignalDescriptor desc) {
        return !sig.getName().equals(desc.getName()) || sig.isStopSet() != desc.getStop() || sig.isIgnore() != !desc.getPass();
    }

    protected IPDISignal findSignal(BitList qTasks, String name) {
        IPDISignal sig = null;
        List<IPDISignal> signalsList = this.signalsMap.get(qTasks);
        if (signalsList != null) {
            IPDISignal[] sigs = signalsList.toArray(new IPDISignal[0]);
            int i = 0;
            while (i < sigs.length) {
                if (sigs[i].getName().equals(name)) {
                    sig = sigs[i];
                    break;
                }
                ++i;
            }
        }
        return sig;
    }
}

