/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.rulesengine;

import java.io.IOException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.launch.data.DownloadBackRule;
import org.eclipse.ptp.launch.data.UploadRule;
import org.eclipse.ptp.launch.internal.LinuxPath;
import org.eclipse.ptp.launch.rulesengine.ILaunchProcessCallback;
import org.eclipse.ptp.launch.rulesengine.IRuleAction;
import org.eclipse.ptp.remote.core.IRemoteFileManager;

public class UploadRuleAction
implements IRuleAction {
    private final ILaunchProcessCallback process;
    private final UploadRule rule;
    private final ILaunchConfiguration configuration;
    private DownloadBackRule downloadBackRule;
    private final IProgressMonitor monitor;

    public UploadRuleAction(ILaunchProcessCallback process, ILaunchConfiguration configuration, UploadRule uploadRule, IProgressMonitor monitor) {
        this.process = process;
        this.rule = uploadRule;
        this.configuration = configuration;
        this.monitor = monitor;
    }

    public void run() throws CoreException {
        IPath localPath;
        Assert.isNotNull((Object)this.process);
        Assert.isNotNull((Object)this.rule);
        Assert.isNotNull((Object)this.configuration);
        String execPath = this.configuration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", null);
        IPath defaultRemotePath = LinuxPath.fromString(execPath).removeLastSegments(1);
        IPath remotePathParent = null;
        if (this.rule.isDefaultRemoteDirectory()) {
            remotePathParent = defaultRemotePath;
        } else {
            remotePathParent = LinuxPath.fromString(this.rule.getRemoteDirectory());
            if (!remotePathParent.isAbsolute()) {
                remotePathParent = defaultRemotePath.append(remotePathParent);
            }
        }
        remotePathParent = remotePathParent.removeTrailingSeparator();
        Assert.isTrue((boolean)remotePathParent.isAbsolute(), (String)"remotePathWoLastSegment.isAbsolute()");
        IPath workingDir = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        IPath[] localPaths = this.rule.getLocalFilesAsPathArray();
        int i = 0;
        while (i < localPaths.length) {
            localPath = localPaths[i];
            if (!localPath.isAbsolute()) {
                localPath = workingDir.append(localPath);
            }
            localPath = localPath.removeTrailingSeparator();
            Assert.isTrue((boolean)localPath.isAbsolute(), (String)"localPath.isAbsolute()");
            localPaths[i] = localPath;
            ++i;
        }
        i = 0;
        while (i < localPaths.length) {
            localPath = localPaths[i];
            IFileStore localFileStore = null;
            try {
                IRemoteFileManager localFileManager = this.process.getLocalFileManager(this.configuration);
                localFileStore = localFileManager.getResource(localPath, this.monitor);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", "Error retrieving local resource", (Throwable)e));
            }
            IFileInfo localFileInfo = localFileStore.fetchInfo();
            if (localFileInfo.exists()) {
                IPath remotePath = remotePathParent.append(localPath.lastSegment());
                IFileStore remoteFileStore = null;
                IRemoteFileManager remoteFileManager = this.process.getRemoteFileManager(this.configuration);
                try {
                    remoteFileStore = remoteFileManager.getResource(remotePath, this.monitor);
                }
                catch (IOException e1) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", "Error retrieving remote resource", (Throwable)e1));
                }
                try {
                    IFileStore parentFileStore = remoteFileManager.getResource(remotePathParent, this.monitor);
                    parentFileStore.mkdir(0, this.monitor);
                }
                catch (IOException e1) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", "Error retrieving remote resource", (Throwable)e1));
                }
                this.doUpload(localFileStore, localPath, remoteFileStore, remotePath);
            }
            ++i;
        }
        if (this.downloadBackRule != null) {
            this.process.addSynchronizationRule(this.downloadBackRule);
        }
    }

    private void doUpload(IFileStore localFileStore, IPath localPath, IFileStore remoteFileStore, IPath remotePath) throws CoreException {
        IFileInfo remoteFileInfo = remoteFileStore.fetchInfo(0, this.monitor);
        IFileInfo localFileInfo = localFileStore.fetchInfo();
        if (remoteFileInfo.exists()) {
            switch (this.rule.getOverwritePolicy()) {
                case 2: {
                    break;
                }
                case 3: {
                    long dupFileModTime = remoteFileInfo.getLastModified();
                    long localFileModTime = localFileInfo.getLastModified();
                    if (dupFileModTime < localFileModTime) break;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        localFileStore.copy(remoteFileStore, 2, this.monitor);
        if (this.rule.isDownloadBack()) {
            if (this.downloadBackRule == null) {
                this.downloadBackRule = new DownloadBackRule();
            }
            this.downloadBackRule.add(localPath.toFile(), remotePath);
        }
        boolean changedAttr = false;
        if (this.rule.isAsReadOnly()) {
            remoteFileInfo.setAttribute(2, true);
            changedAttr = true;
        }
        if (this.rule.isAsExecutable()) {
            remoteFileInfo.setAttribute(4, true);
            changedAttr = true;
        }
        if (changedAttr) {
            remoteFileStore.putInfo(remoteFileInfo, 1024, this.monitor);
        }
        if (this.rule.isPreserveTimeStamp()) {
            remoteFileInfo.setLastModified(localFileInfo.getLastModified());
            remoteFileStore.putInfo(remoteFileInfo, 2048, this.monitor);
        }
    }
}

