/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.ptp.launch.data.DownloadRule;
import org.eclipse.ptp.launch.data.ISynchronizationRule;
import org.eclipse.ptp.launch.messages.Messages;
import org.eclipse.ptp.launch.ui.IRuleDialog;
import org.eclipse.ptp.utils.ui.swt.ComboGroup;
import org.eclipse.ptp.utils.ui.swt.ComboMold;
import org.eclipse.ptp.utils.ui.swt.Frame;
import org.eclipse.ptp.utils.ui.swt.FrameMold;
import org.eclipse.ptp.utils.ui.swt.GenericControlMold;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class DownloadRuleDialog
extends TitleAreaDialog
implements IRuleDialog {
    Composite content;
    Text localDirectoryText;
    Button localDirectoryButton;
    Button localWorkspaceButton;
    List fileList;
    Button addFilesButton;
    Button editFileButton;
    Button removeFilesButton;
    Button asReadOnlyButton;
    Button asExecutableButton;
    Button preserveTimeStampButton;
    ComboGroup overwritePolicyCombo;
    DownloadRule downloadRule;
    IPath lastSelectedDirectory = ResourcesPlugin.getWorkspace().getRoot().getLocation();
    private int listenersEnabled = 0;

    public DownloadRuleDialog(Shell parentShell, DownloadRule rule) {
        super(parentShell);
        this.downloadRule = rule;
    }

    public DownloadRuleDialog(Shell shell) {
        super(shell);
        this.downloadRule = new DownloadRule();
    }

    protected Control createDialogArea(Composite parent) {
        this.content = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        this.content.setLayout((Layout)layout);
        this.content.setLayoutData((Object)new GridData(1808));
        this.setTitle(Messages.DownloadRuleDialog_Title);
        this.setMessage(Messages.DownloadRuleDialog_Message);
        this.createRemoteFilesComposite(this.content);
        this.createLocalDirectoryComposite(this.content);
        this.createOptionsComposite(this.content);
        this.putFieldContents();
        return this.content;
    }

    private void enableListeners() {
        ++this.listenersEnabled;
    }

    private void disableListeners() {
        --this.listenersEnabled;
    }

    private void putFieldContents() {
        this.disableListeners();
        if (this.downloadRule.getLocalDirectory() != null) {
            this.localDirectoryText.setText(this.downloadRule.getLocalDirectory());
        } else {
            this.localDirectoryText.setText("");
        }
        this.overwritePolicyCombo.selectIndexUsingID(Integer.toString(this.downloadRule.getOverwritePolicy()));
        this.asExecutableButton.setSelection(this.downloadRule.isAsExecutable());
        this.asReadOnlyButton.setSelection(this.downloadRule.isAsReadOnly());
        this.preserveTimeStampButton.setSelection(this.downloadRule.isPreserveTimeStamp());
        Object[] items = this.downloadRule.getRemoteFilesAsStringArray();
        Arrays.sort(items);
        this.fileList.setItems((String[])items);
        this.enableListeners();
    }

    private void fetchFieldContents() {
        this.disableListeners();
        String path = this.localDirectoryText.getText().trim();
        if (path.length() > 0) {
            this.downloadRule.setLocalDirectory(path);
        } else {
            this.downloadRule.setLocalDirectory(null);
        }
        this.downloadRule.setOverwritePolicy(Integer.parseInt(this.overwritePolicyCombo.getSelectionId()));
        this.downloadRule.setAsExecutable(this.asExecutableButton.getSelection());
        this.downloadRule.setAsReadOnly(this.asReadOnlyButton.getSelection());
        this.downloadRule.setPreserveTimeStamp(this.preserveTimeStampButton.getSelection());
        this.downloadRule.setRemoteFiles(this.fileList.getItems());
        this.enableListeners();
    }

    protected void okPressed() {
        this.fetchFieldContents();
        super.okPressed();
    }

    private Composite createLocalDirectoryComposite(Composite parent) {
        FrameMold frameMold = new FrameMold();
        frameMold.setColumns(3);
        frameMold.setTitle(Messages.DownloadRuleDialog_DestinationFrame_Title);
        Frame frame = new Frame(parent, frameMold);
        frame.setLayoutData((Object)new GridData(768));
        Composite contents = frame.getComposite();
        GridData localDirectoryGridData = new GridData();
        localDirectoryGridData.grabExcessHorizontalSpace = true;
        localDirectoryGridData.horizontalSpan = 3;
        localDirectoryGridData.horizontalAlignment = 4;
        this.localDirectoryText = new Text(contents, 2052);
        this.localDirectoryText.setLayoutData((Object)localDirectoryGridData);
        GridData skipperGridData = new GridData();
        skipperGridData.grabExcessHorizontalSpace = true;
        skipperGridData.horizontalSpan = 1;
        skipperGridData.horizontalAlignment = 4;
        Label skipper = new Label(contents, 0);
        skipper.setLayoutData((Object)skipperGridData);
        this.localDirectoryButton = new Button(contents, 8);
        this.localDirectoryButton.setText(Messages.DownloadRuleDialog_DestinationFrame_FileSystemButton);
        this.localDirectoryButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (DownloadRuleDialog.this.listenersEnabled < 0) {
                    return;
                }
                DownloadRuleDialog.this.handleLocalDirectoryButtonEvent();
            }
        });
        this.localWorkspaceButton = new Button(contents, 8);
        this.localWorkspaceButton.setText(Messages.DownloadRuleDialog_DestinationFrame_WorkspaceButton);
        this.localWorkspaceButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (DownloadRuleDialog.this.listenersEnabled < 0) {
                    return;
                }
                DownloadRuleDialog.this.handleLocalWorkspaceButtonEvent();
            }
        });
        return frame;
    }

    private Composite createOptionsComposite(Composite parent) {
        FrameMold frameMold = new FrameMold();
        frameMold.setColumns(3);
        frameMold.addOption(FrameMold.COLUMNS_EQUAL_WIDTH);
        frameMold.setTitle(Messages.DownloadRuleDialog_OptionsFrame_Title);
        Frame frame = new Frame(parent, frameMold);
        frame.setLayoutData((Object)new GridData(768));
        Composite contents = frame.getComposite();
        this.asReadOnlyButton = new Button(contents, 32);
        this.asReadOnlyButton.setText(Messages.DownloadRuleDialog_OptionsFrame_ReadonlyCheck);
        this.asExecutableButton = new Button(contents, 32);
        this.asExecutableButton.setText(Messages.DownloadRuleDialog_OptionsFrame_ExecutableCheck);
        this.preserveTimeStampButton = new Button(contents, 32);
        this.preserveTimeStampButton.setText(Messages.DownloadRuleDialog_OptionsFrame_PreserveTimeStampCheck);
        ComboMold mold = new ComboMold(ComboMold.GRID_DATA_SPAN);
        mold.setLabel(Messages.DownloadRuleDialog_OptionsFrame_OverwriteLabel);
        mold.setTextFieldWidth(40);
        mold.addItem(Integer.toString(1), Messages.DownloadRuleDialog_OptionsFrame_OverwriteCombo_SkipOption);
        mold.addItem(Integer.toString(2), Messages.DownloadRuleDialog_OptionsFrame_OverwriteCombo_OverwriteAlwaysOption);
        mold.addItem(Integer.toString(3), Messages.DownloadRuleDialog_OptionsFrame_OverwriteCombo_OverwriteIfNewerOption);
        this.overwritePolicyCombo = new ComboGroup(contents, (GenericControlMold)mold);
        this.overwritePolicyCombo.getCombo().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (DownloadRuleDialog.this.listenersEnabled < 0) {
                    return;
                }
                DownloadRuleDialog.this.disableListeners();
                if (DownloadRuleDialog.this.overwritePolicyCombo.getSelectionId().equals(Integer.toString(3))) {
                    DownloadRuleDialog.this.preserveTimeStampButton.setEnabled(false);
                    DownloadRuleDialog.this.preserveTimeStampButton.setSelection(true);
                } else {
                    DownloadRuleDialog.this.preserveTimeStampButton.setEnabled(true);
                }
                DownloadRuleDialog.this.enableListeners();
            }
        });
        return frame;
    }

    private Composite createRemoteFilesComposite(Composite parent) {
        FrameMold frameMold = new FrameMold();
        frameMold.setColumns(2);
        frameMold.setTitle(Messages.DownloadRuleDialog_FileListFrame_Title);
        Frame frame = new Frame(parent, frameMold);
        frame.setLayoutData((Object)new GridData(768));
        Frame filesFrame = new Frame(frame.getComposite());
        this.fileList = new List((Composite)filesFrame, 514);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        this.fileList.setLayoutData((Object)gridData);
        this.fileList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (DownloadRuleDialog.this.listenersEnabled < 0) {
                    return;
                }
                DownloadRuleDialog.this.removeFilesButton.setEnabled(DownloadRuleDialog.this.fileList.getSelectionCount() != 0);
                DownloadRuleDialog.this.editFileButton.setEnabled(DownloadRuleDialog.this.fileList.getSelectionCount() == 1);
            }
        });
        this.fileList.deselectAll();
        Frame buttonFrame = new Frame(frame.getComposite());
        this.addFilesButton = new Button((Composite)buttonFrame, 8);
        this.addFilesButton.setText(Messages.DownloadRuleDialog_FileListFrame_AddButton);
        this.addFilesButton.setLayoutData((Object)new GridData(768));
        this.addFilesButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (DownloadRuleDialog.this.listenersEnabled < 0) {
                    return;
                }
                DownloadRuleDialog.this.handleaddFilesButtonEvent();
            }
        });
        this.editFileButton = new Button((Composite)buttonFrame, 8);
        this.editFileButton.setText(Messages.DownloadRuleDialog_FileListFrame_EditButton);
        this.editFileButton.setLayoutData((Object)new GridData(768));
        this.editFileButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (DownloadRuleDialog.this.listenersEnabled < 0) {
                    return;
                }
                DownloadRuleDialog.this.handleEditFileButtonEvent();
            }
        });
        this.removeFilesButton = new Button((Composite)buttonFrame, 8);
        this.removeFilesButton.setText(Messages.DownloadRuleDialog_FileListFrame_RemoveButton);
        this.removeFilesButton.setEnabled(false);
        this.removeFilesButton.setLayoutData((Object)new GridData(768));
        this.removeFilesButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (DownloadRuleDialog.this.listenersEnabled < 0) {
                    return;
                }
                DownloadRuleDialog.this.handleRemoveFilesButtonEvent();
            }
        });
        GridData gridData2 = new GridData();
        gridData2.grabExcessVerticalSpace = true;
        gridData2.verticalAlignment = 128;
        buttonFrame.setLayoutData((Object)gridData2);
        return frame;
    }

    private void handleLocalDirectoryButtonEvent() {
        File file2;
        File file;
        if (this.listenersEnabled < 0) {
            return;
        }
        Path selectedPath = null;
        IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        Path currentPath = new Path(this.localDirectoryText.getText());
        if (!currentPath.isAbsolute()) {
            currentPath = workspacePath.append((IPath)currentPath).removeTrailingSeparator();
        }
        if ((file = new File(currentPath.toOSString())).isDirectory() && file.isDirectory()) {
            selectedPath = currentPath;
        }
        if (selectedPath == null && (file2 = new File(this.lastSelectedDirectory.toOSString())).isDirectory() && file2.isDirectory()) {
            selectedPath = this.lastSelectedDirectory;
        }
        if (selectedPath == null) {
            selectedPath = workspacePath;
        }
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell(), 4096);
        directoryDialog.setFilterPath(selectedPath.toOSString());
        directoryDialog.setText(Messages.DownloadRuleDialog_DirectoryDialog_Title);
        directoryDialog.setMessage(Messages.DownloadRuleDialog_DirectoryDialog_Message);
        String newPath = directoryDialog.open();
        if (newPath != null) {
            Path path;
            IPath workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            if (workspace.isPrefixOf((IPath)(path = new Path(newPath)))) {
                path = path.removeFirstSegments(workspace.segmentCount());
                path = path.makeRelative();
            }
            this.localDirectoryText.setText(path.toOSString());
            this.lastSelectedDirectory = new Path(newPath);
            this.lastSelectedDirectory = this.lastSelectedDirectory.removeLastSegments(1).removeTrailingSeparator();
        }
    }

    private void handleLocalWorkspaceButtonEvent() {
        IContainer[] lastContainer;
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        IWorkspaceRoot selectedContainer = null;
        Path currentPath = new Path(this.localDirectoryText.getText());
        if (currentPath.isAbsolute()) {
            IContainer[] currentContainer = workspace.findContainersForLocation((IPath)currentPath);
            if (currentContainer != null && currentContainer.length == 1) {
                selectedContainer = currentContainer[0];
            }
        } else {
            IResource selectedResource = workspace.findMember(this.lastSelectedDirectory);
            if (selectedResource != null && selectedResource instanceof IContainer) {
                selectedContainer = (IContainer)selectedResource;
            }
        }
        if (selectedContainer == null && (lastContainer = workspace.findContainersForLocation(this.lastSelectedDirectory)) != null && lastContainer.length == 1) {
            selectedContainer = lastContainer[0];
        }
        if (selectedContainer == null) {
            selectedContainer = workspace;
        }
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)workspace, true, Messages.DownloadRuleDialog_WorkspaceDialog_Title);
        dialog.setBlockOnOpen(true);
        dialog.setInitialSelections(new Object[]{selectedContainer});
        if (dialog.open() == 0) {
            Object[] r = dialog.getResult();
            IPath selectedPath = (IPath)r[0];
            this.localDirectoryText.setText(selectedPath.makeRelative().toOSString());
            this.lastSelectedDirectory = selectedPath.removeLastSegments(1).removeTrailingSeparator();
        }
    }

    private void handleaddFilesButtonEvent() {
        InputDialog inputDialog = new InputDialog(this.getShell(), Messages.DownloadRuleDialog_AddFileDialog_Title, Messages.DownloadRuleDialog_AddFileDialog_Message, "", null);
        inputDialog.setBlockOnOpen(true);
        if (inputDialog.open() == 0) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.fileList.getItems()));
            list.add(inputDialog.getValue());
            Object[] s = new String[list.size()];
            s = list.toArray(s);
            Arrays.sort(s);
            this.fileList.setItems((String[])s);
        }
    }

    private void handleEditFileButtonEvent() {
        if (this.fileList.getSelectionCount() != 1) {
            return;
        }
        int index = this.fileList.getSelectionIndex();
        String selectedItem = this.fileList.getItem(index);
        InputDialog inputDialog = new InputDialog(this.getShell(), Messages.DownloadRuleDialog_EditFileDialog_Title, Messages.DownloadRuleDialog_EditFileDialog_Message, selectedItem, null);
        inputDialog.setBlockOnOpen(true);
        if (inputDialog.open() == 0) {
            Object[] s = this.fileList.getItems();
            s[index] = inputDialog.getValue();
            Arrays.sort(s);
            this.fileList.setItems((String[])s);
        }
    }

    private void handleRemoveFilesButtonEvent() {
        String[] selection = this.fileList.getSelection();
        if (selection.length == 0) {
            return;
        }
        HashSet<String> fileSet = new HashSet<String>(Arrays.asList(this.fileList.getItems()));
        int i = 0;
        while (i < selection.length) {
            String string = selection[i];
            fileSet.remove(string);
            ++i;
        }
        Object[] items = new String[fileSet.size()];
        items = fileSet.toArray(items);
        Arrays.sort(items);
        this.fileList.setItems((String[])items);
    }

    public ISynchronizationRule getRuleWorkingCopy() {
        return this.downloadRule;
    }
}

