/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.preferences.ui;

import org.eclipse.jface.util.Assert;
import org.eclipse.ptp.cell.preferences.ui.FieldEditorWithSearch;
import org.eclipse.ptp.cell.preferences.ui.PreferenceConstantsFromFile;
import org.eclipse.ptp.cell.preferences.ui.SearchButtonSelectionAdapter;
import org.eclipse.ptp.cell.utils.searcher.Searcher;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class FieldEditorWithSearchDelegate {
    protected boolean usingDefaultSearchButtonSelectionListener = true;
    protected Button searchButton;
    protected String searchButtonText;

    public Button getSearchControl(Composite parent) {
        if (this.searchButton == null) {
            this.searchButton = new Button(parent, 8);
            if (this.searchButtonText == null) {
                this.searchButtonText = PreferenceConstantsFromFile.searchButtonText;
            }
            this.searchButton.setText(this.searchButtonText);
            this.searchButton.setFont(parent.getFont());
            this.searchButton.addSelectionListener(FieldEditorWithSearch.DEFAULT_SEARCH_BUTTON_SELECTION_LISTENER);
            this.searchButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FieldEditorWithSearchDelegate.this.searchButton = null;
                }
            });
        }
        return this.searchButton;
    }

    public void setSearchButtonText(String text) {
        Assert.isNotNull((Object)text);
        this.searchButtonText = text;
        if (this.searchButton != null) {
            this.searchButton.setText(text);
            Point prefSize = this.searchButton.computeSize(-1, -1);
            GridData data = (GridData)this.searchButton.getLayoutData();
            data.widthHint = Math.max(-1, prefSize.x);
        }
    }

    public void setSearchButtonLayout(int widthHint) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = Math.max(widthHint, this.searchButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.searchButton.setLayoutData((Object)gridData);
    }

    public int getNumberOfControls(int numberOfControls) {
        return numberOfControls + 1;
    }

    public void addSearcher(Searcher searcher) {
        if (this.usingDefaultSearchButtonSelectionListener) {
            this.searchButton.removeSelectionListener(FieldEditorWithSearch.DEFAULT_SEARCH_BUTTON_SELECTION_LISTENER);
            this.usingDefaultSearchButtonSelectionListener = false;
        }
        this.searchButton.addSelectionListener((SelectionListener)new SearchButtonSelectionAdapter(searcher));
    }
}

