/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.wizards.wizardPages;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ptp.pldt.mpi.core.MpiPlugin;
import org.eclipse.ptp.pldt.mpi.core.prefs.MPIPreferencePage;
import org.eclipse.ptp.pldt.wizards.wizardPages.AbstractProjectWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MPIProjectWizardPage
extends AbstractProjectWizardPage {
    public static final String DOT = ".";
    private static final boolean traceOn = false;
    public static final boolean wizardTraceOn = false;
    private Composite composite;
    public static final String PAGE_ID = "org.eclipse.ptp.pldt.wizards.wizardPages.MPIProjectWizardPage";
    public static final String DO_MPI_INCLUDES = "doMPIincludes";
    public static final String INCLUDE_PATH_PROP_ID = "includePath";
    public static final String LIB_PROP_ID = "lib";
    public static final String LIBRARY_SEARCH_PATH_PROP_ID = "libPath";
    public static final String MPI_COMPILE_COMMAND_PROP_ID = "mpiCompileCommand";
    public static final String MPI_LINK_COMMAND_PROP_ID = "mpiLinkCommand";
    private String currentMpiIncludePath;
    private String currentLibName;
    private String currentLibPath;
    private String currentMpiCompileCommand;
    private String currentMpiLinkCommand;
    private String defaultMpiIncludePath;
    private String defaultMpiLibName;
    private String defaultMpiLibPath;
    private String defaultMpiBuildCommand;
    private Text includePathField;
    private Text libNameField;
    private Text libPathField;
    private Text mpiCompileCommandField;
    private Text mpiLinkCommandField;
    private Label includePathLabel;
    private Label libLabel;
    private Label libPathLabel;
    private Label mpiCompileCommandLabel;
    private Label mpiLinkCommandLabel;
    private Button browseButton;
    private Button browseButton2;
    private Button useDefaultsButton;
    private Button useMpiProjectSettingsButton;
    private static boolean defaultUseMpiIncludes = true;
    private Button mpiSampleButton;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private boolean useMpiProjectSettings = true;
    private String desc = "MPI Project Page";
    public static final String MPI_PROJECT_TYPE_C = "C";
    public static final String MPI_PROJECT_TYPE_CPP = "C++";
    private static boolean alreadyShown;
    Map<String, String> pageData = new HashMap<String, String>();

    public MPIProjectWizardPage() throws CoreException {
        super("MPI Project Settings");
        String mip;
        this.prefIDincludes = "MPI Includes";
        this.preferenceStore = MpiPlugin.getDefault().getPreferenceStore();
        this.defaultMpiIncludePath = mip = this.preferenceStore.getString(this.prefIDincludes);
        if (this.defaultMpiIncludePath.length() == 0) {
            String newMip;
            this.defaultMpiIncludePath = newMip = this.showNoPrefs("MPI", this.prefIDincludes);
        }
        this.setDefaultOtherNames(this.defaultMpiIncludePath);
        this.setCurrentMpiIncludePath(this.defaultMpiIncludePath);
        this.defaultMpiBuildCommand = this.getDefaultMpiBuildCommand();
        this.setCurrentMpiCompileCommand(this.defaultMpiBuildCommand);
        this.setCurrentMpiLinkCommand(this.defaultMpiBuildCommand);
    }

    protected abstract String getDefaultMpiBuildCommand();

    private static void showNoPrefs1() {
        if (!alreadyShown) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            StringBuffer buf = new StringBuffer("No MPI Preferences set; ");
            buf.append("Default project setting will be more useful if MPI preferences are set first. ");
            buf.append("\nUse Window > Preferences and select Parallel Language Development Tools, which may be under PTP preferences.");
            buf.append("You can cancel out of new project wizard to enter MPI preferences now.");
            MessageDialog.openWarning((Shell)shell, (String)"No MPI Preferences set", (String)buf.toString());
            alreadyShown = true;
        }
    }

    private void setDefaultOtherNames(String mpiIncludePath) {
        this.defaultMpiLibName = "mpi";
        this.setCurrentMpiLibName(this.defaultMpiLibName);
        String tempPath = mpiIncludePath;
        int sepLoc = tempPath.indexOf(File.pathSeparatorChar);
        if (-1 != sepLoc) {
            tempPath = mpiIncludePath.substring(0, sepLoc);
        }
        IPath path = Path.fromOSString((String)tempPath);
        path = path.removeLastSegments(1);
        path = path.addTrailingSeparator();
        this.defaultMpiLibPath = String.valueOf(path.toString()) + LIB_PROP_ID;
        this.setCurrentMpiLibPath(this.defaultMpiLibPath);
        path = Path.fromOSString((String)mpiIncludePath);
        String temp = path.toString();
        this.defaultMpiIncludePath = temp = this.stripTrailingSeparator(temp);
        this.setCurrentMpiIncludePath(this.defaultMpiIncludePath);
        this.setCurrentMpiCompileCommand(this.defaultMpiBuildCommand);
    }

    private void setCurrentMpiIncludePath(String path) {
        this.currentMpiIncludePath = path;
        this.pageData.put("org.eclipse.ptp.pldt.wizards.wizardPages.MPIProjectWizardPage.includePath", path);
    }

    private void setCurrentMpiLibName(String name) {
        this.currentMpiIncludePath = name;
        this.pageData.put("org.eclipse.ptp.pldt.wizards.wizardPages.MPIProjectWizardPage.lib", name);
    }

    private void setCurrentMpiLibPath(String path) {
        this.currentMpiIncludePath = path;
        this.pageData.put("org.eclipse.ptp.pldt.wizards.wizardPages.MPIProjectWizardPage.libPath", path);
    }

    private void setCurrentMpiCompileCommand(String buildCommand) {
        this.currentMpiCompileCommand = buildCommand;
        this.pageData.put("org.eclipse.ptp.pldt.wizards.wizardPages.MPIProjectWizardPage.mpiCompileCommand", buildCommand);
    }

    private void setCurrentMpiLinkCommand(String buildCommand) {
        this.currentMpiLinkCommand = buildCommand;
        this.pageData.put("org.eclipse.ptp.pldt.wizards.wizardPages.MPIProjectWizardPage.mpiLinkCommand", buildCommand);
    }

    public String getName() {
        return new String(String.valueOf(this.desc) + " name");
    }

    private String getPathFromPathField(Text textField) {
        URI fieldURI;
        try {
            fieldURI = new URI(textField.getText());
        }
        catch (URISyntaxException uRISyntaxException) {
            return textField.getText();
        }
        return fieldURI.getPath();
    }

    private void updateIncludePathField(String selectedPath) {
        this.includePathField.setText(selectedPath);
    }

    private void updateLibPathField(String selectedPath) {
        this.libPathField.setText(selectedPath);
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory = null;
        String dirName = this.getPathFromPathField(this.includePathField);
        DirectoryDialog dialog = new DirectoryDialog(this.includePathField.getShell());
        dialog.setMessage("MPI Include path:");
        dialog.setFilterPath(dirName);
        selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.updateIncludePathField(selectedDirectory);
            this.includePathField.setText(selectedDirectory);
            this.setCurrentMpiIncludePath(selectedDirectory);
        }
    }

    private void handleLocationBrowseButton2Pressed() {
        String selectedDirectory = null;
        String dirName = this.getPathFromPathField(this.libPathField);
        DirectoryDialog dialog = new DirectoryDialog(this.libPathField.getShell());
        dialog.setMessage("MPI library search path:");
        dialog.setFilterPath(dirName);
        selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.updateLibPathField(selectedDirectory);
            this.libPathField.setText(selectedDirectory);
            this.setCurrentMpiLibPath(selectedDirectory);
        }
    }

    private String stripTrailingSeparator(String str) {
        if (str.length() == 0) {
            return str;
        }
        char lastChar = str.charAt(str.length() - 1);
        if (lastChar == File.pathSeparatorChar) {
            String temp = str.substring(0, str.length() - 1);
            return temp;
        }
        return str;
    }

    private void createUserEntryArea(Composite composite, boolean defaultEnabled) {
        this.includePathLabel = new Label(composite, 0);
        this.includePathLabel.setText("Include path:");
        this.includePathLabel.setToolTipText("Location of MPI include path(s)");
        this.includePathField = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        data.horizontalSpan = 2;
        this.includePathField.setLayoutData((Object)data);
        this.includePathField.setText(this.defaultMpiIncludePath);
        this.includePathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MPIProjectWizardPage.this.setCurrentMpiIncludePath(MPIProjectWizardPage.this.includePathField.getText());
            }
        });
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MPIProjectWizardPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.libLabel = new Label(composite, 0);
        this.libLabel.setText("Library name:");
        this.libLabel.setToolTipText("Library name:");
        this.libNameField = new Text(composite, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        gd.horizontalSpan = 2;
        this.libNameField.setLayoutData((Object)gd);
        this.libNameField.setText(this.defaultMpiLibName);
        this.libNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MPIProjectWizardPage.this.setCurrentMpiLibName(MPIProjectWizardPage.this.libNameField.getText());
            }
        });
        new Label(composite, 0).setText(" ");
        this.libPathLabel = new Label(composite, 0);
        this.libPathLabel.setText("Library search path:");
        this.libPathLabel.setToolTipText("Library name:");
        this.libPathField = new Text(composite, 2048);
        GridData gd2 = new GridData(768);
        gd2.widthHint = 250;
        gd2.horizontalSpan = 2;
        this.libPathField.setLayoutData((Object)gd2);
        this.libPathField.setText(this.defaultMpiLibPath);
        this.libPathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MPIProjectWizardPage.this.setCurrentMpiLibPath(MPIProjectWizardPage.this.libPathField.getText());
            }
        });
        this.browseButton2 = new Button(composite, 8);
        this.browseButton2.setText("Browse...");
        this.browseButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MPIProjectWizardPage.this.handleLocationBrowseButton2Pressed();
            }
        });
        this.mpiCompileCommandLabel = new Label(composite, 0);
        this.mpiCompileCommandLabel.setText("MPI compile command: ");
        this.mpiCompileCommandField = new Text(composite, 2048);
        GridData gd3 = new GridData(768);
        gd3.widthHint = 250;
        gd3.horizontalSpan = 2;
        this.mpiCompileCommandField.setLayoutData((Object)gd3);
        this.mpiCompileCommandField.setText(this.defaultMpiBuildCommand);
        this.mpiCompileCommandField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MPIProjectWizardPage.this.setCurrentMpiCompileCommand(MPIProjectWizardPage.this.mpiCompileCommandField.getText());
            }
        });
        new Label(composite, 0).setText(" ");
        this.mpiLinkCommandLabel = new Label(composite, 0);
        this.mpiLinkCommandLabel.setText("MPI link command: ");
        this.mpiLinkCommandField = new Text(composite, 2048);
        GridData gd4 = new GridData(768);
        gd4.widthHint = 250;
        gd4.horizontalSpan = 2;
        this.mpiLinkCommandField.setLayoutData((Object)gd3);
        this.mpiLinkCommandField.setText(this.defaultMpiBuildCommand);
        this.mpiLinkCommandField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MPIProjectWizardPage.this.setCurrentMpiLinkCommand(MPIProjectWizardPage.this.mpiLinkCommandField.getText());
            }
        });
        new Label(composite, 0).setText(" ");
    }

    private void createContents(Composite composite, boolean defaultEnabled) {
        int columns = 4;
        Composite group = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.useMpiProjectSettingsButton = new Button(group, 131104);
        this.useMpiProjectSettingsButton.setText("Add MPI project settings to this project");
        GridData gd = new GridData();
        gd.horizontalSpan = columns;
        this.useMpiProjectSettingsButton.setLayoutData((Object)gd);
        this.useMpiProjectSettingsButton.setSelection(this.useMpiProjectSettings);
        this.useMpiProjectSettingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MPIProjectWizardPage.this.useMpiProjectSettings = MPIProjectWizardPage.this.useMpiProjectSettingsButton.getSelection();
                MPIProjectWizardPage.this.pageData.put("org.eclipse.ptp.pldt.wizards.wizardPages.MPIProjectWizardPage.doMPIincludes", Boolean.toString(MPIProjectWizardPage.this.useMpiProjectSettings));
                MPIProjectWizardPage.this.useDefaultsButton.setEnabled(MPIProjectWizardPage.this.useMpiProjectSettings);
                if (MPIProjectWizardPage.this.mpiSampleButton != null) {
                    MPIProjectWizardPage.this.mpiSampleButton.setEnabled(MPIProjectWizardPage.this.useMpiProjectSettings);
                }
                if (MPIProjectWizardPage.this.useMpiProjectSettings) {
                    boolean useDefaults = MPIProjectWizardPage.this.useDefaultsButton.getSelection();
                    MPIProjectWizardPage.this.setUserAreaEnabled(!useDefaults);
                } else {
                    MPIProjectWizardPage.this.setUserAreaEnabled(false);
                }
            }
        });
        this.useDefaultsButton = new Button(group, 131104);
        this.useDefaultsButton.setText("Use default information");
        this.useDefaultsButton.setSelection(defaultEnabled);
        this.useDefaultsButton.setEnabled(this.useMpiProjectSettings);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = columns;
        this.useDefaultsButton.setLayoutData((Object)buttonData);
        this.useDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefaults = MPIProjectWizardPage.this.useDefaultsButton.getSelection();
                if (useDefaults) {
                    MPIProjectWizardPage.this.includePathField.setText(MPIProjectWizardPage.this.defaultMpiIncludePath);
                    MPIProjectWizardPage.this.setCurrentMpiIncludePath(MPIProjectWizardPage.this.defaultMpiIncludePath);
                    MPIProjectWizardPage.this.libPathField.setText(MPIProjectWizardPage.this.defaultMpiLibName);
                    MPIProjectWizardPage.this.setCurrentMpiLibName(MPIProjectWizardPage.this.defaultMpiLibName);
                    MPIProjectWizardPage.this.libNameField.setText(MPIProjectWizardPage.this.defaultMpiLibName);
                    MPIProjectWizardPage.this.setCurrentMpiLibName(MPIProjectWizardPage.this.defaultMpiLibName);
                    MPIProjectWizardPage.this.libPathField.setText(MPIProjectWizardPage.this.defaultMpiLibPath);
                    MPIProjectWizardPage.this.setCurrentMpiLibPath(MPIProjectWizardPage.this.defaultMpiLibPath);
                    MPIProjectWizardPage.this.mpiCompileCommandField.setText(MPIProjectWizardPage.this.defaultMpiBuildCommand);
                    MPIProjectWizardPage.this.setCurrentMpiCompileCommand(MPIProjectWizardPage.this.defaultMpiBuildCommand);
                    MPIProjectWizardPage.this.mpiLinkCommandField.setText(MPIProjectWizardPage.this.defaultMpiBuildCommand);
                    MPIProjectWizardPage.this.setCurrentMpiLinkCommand(MPIProjectWizardPage.this.defaultMpiBuildCommand);
                }
                MPIProjectWizardPage.this.setUserAreaEnabled(!useDefaults);
            }
        });
        this.createUserEntryArea(group, defaultEnabled);
        this.setUserAreaEnabled(!defaultEnabled);
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout());
        this.composite.setLayoutData((Object)new GridData(1808));
        boolean defaultEnabled = true;
        this.createContents(this.composite, defaultEnabled);
    }

    public Control getControl() {
        return this.composite;
    }

    public String getDescription() {
        String tmp = "Select the MPI include path, lib name, library search path, and build command information to be automatically be added to the new project.";
        return tmp;
    }

    public String getErrorMessage() {
        return null;
    }

    public Image getImage() {
        return this.getWizard().getDefaultPageImage();
    }

    public String getMessage() {
        return null;
    }

    public String getTitle() {
        return "MPI Project Settings";
    }

    public void performHelp() {
    }

    public void setDescription(String description) {
    }

    public void setImageDescriptor(ImageDescriptor image) {
    }

    public void setTitle(String title) {
    }

    public void setVisible(boolean visible) {
        this.composite.setVisible(visible);
    }

    protected boolean isCustomPageComplete() {
        return true;
    }

    private void setUserAreaEnabled(boolean enabled) {
        this.includePathField.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        this.browseButton2.setEnabled(enabled);
        this.libNameField.setEnabled(enabled);
        this.libPathField.setEnabled(enabled);
        this.includePathLabel.setEnabled(enabled);
        this.libPathLabel.setEnabled(enabled);
        this.libLabel.setEnabled(enabled);
        this.mpiCompileCommandLabel.setEnabled(enabled);
        this.mpiCompileCommandField.setEnabled(enabled);
        this.mpiLinkCommandLabel.setEnabled(enabled);
        this.mpiLinkCommandField.setEnabled(enabled);
    }

    public static boolean getDefaultUseMpiIncludes() {
        return defaultUseMpiIncludes;
    }

    public Map<String, String> getPageData() {
        return this.pageData;
    }

    protected abstract String getMpiProjectType();

    @Override
    protected IPreferencePage getPreferencePage() {
        if (this.preferencePage == null) {
            this.preferencePage = new MPIPreferencePage();
        }
        return this.preferencePage;
    }
}

