/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.rm.core.rmsystem.AbstractToolRMConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPI13PreferenceManager;
import org.eclipse.ptp.rm.mpi.openmpi.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem.OpenMPIResourceManagerFactory;
import org.eclipse.ptp.rm.remote.core.AbstractRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.ui.IMemento;

public class OpenMPIResourceManagerConfiguration
extends AbstractToolRMConfiguration
implements Cloneable {
    public static int OPENMPI_CAPABILITIES = 19;
    private static final String TAG_VERSION_ID = "versionId";
    public static final String VERSION_12 = "openmpi-1.2";
    public static final String VERSION_13 = "openmpi-1.3";
    private String versionId;

    public static OpenMpiConfig loadOpenMpiConfig(IResourceManagerFactory factory, IMemento memento) {
        AbstractToolRMConfiguration.ToolsConfig toolsConfig = OpenMPIResourceManagerConfiguration.loadTool((IResourceManagerFactory)factory, (IMemento)memento);
        String versionId = memento.getString(TAG_VERSION_ID);
        OpenMpiConfig config = new OpenMpiConfig(toolsConfig, versionId);
        return config;
    }

    public static OpenMPIResourceManagerConfiguration load(OpenMPIResourceManagerFactory factory, IMemento memento) {
        OpenMpiConfig openMpiConfig = OpenMPIResourceManagerConfiguration.loadOpenMpiConfig((IResourceManagerFactory)factory, memento);
        OpenMPIResourceManagerConfiguration config = new OpenMPIResourceManagerConfiguration(factory, openMpiConfig);
        return config;
    }

    public OpenMPIResourceManagerConfiguration(OpenMPIResourceManagerFactory factory) {
        super(OPENMPI_CAPABILITIES, new AbstractToolRMConfiguration.ToolsConfig(), (IResourceManagerFactory)factory);
        Preferences prefs = OpenMPI13PreferenceManager.getPreferences();
        this.setLaunchCmd(prefs.getString("openmpi-1.3-launchCmd"));
        this.setDebugCmd(prefs.getString("openmpi-1.3-debugCmd"));
        this.setDiscoverCmd(prefs.getString("openmpi-1.3-discoverCmd"));
        this.setRemoteInstallPath(prefs.getString("openmpi-1.3-remoteInstallPAth"));
        this.setVersionId(VERSION_13);
    }

    public OpenMPIResourceManagerConfiguration(OpenMPIResourceManagerFactory factory, OpenMpiConfig config) {
        super(OPENMPI_CAPABILITIES, config.getToolsConfig(), (IResourceManagerFactory)factory);
        this.setVersionId(config.getVersionId());
    }

    public Object clone() {
        AbstractResourceManagerConfiguration.CommonConfig commonConf = new AbstractResourceManagerConfiguration.CommonConfig(this.getName(), this.getDescription(), this.getUniqueName());
        AbstractRemoteResourceManagerConfiguration.RemoteConfig remoteConf = new AbstractRemoteResourceManagerConfiguration.RemoteConfig(commonConf, this.getRemoteServicesId(), this.getConnectionName(), this.getProxyServerPath(), this.getLocalAddress(), this.getInvocationOptionsStr(), this.getOptions());
        AbstractToolRMConfiguration.ToolsConfig toolsConfig = new AbstractToolRMConfiguration.ToolsConfig(remoteConf, this.getLaunchCmd(), this.getDebugCmd(), this.getDiscoverCmd(), this.getPeriodicMonitorCmd(), this.getPeriodicMonitorTime(), this.getContinuousMonitorCmd(), this.getRemoteInstallPath(), this.useToolDefaults());
        OpenMpiConfig openMpiConfig = new OpenMpiConfig(toolsConfig, this.getVersionId());
        return new OpenMPIResourceManagerConfiguration((OpenMPIResourceManagerFactory)this.getFactory(), openMpiConfig);
    }

    public void save(IMemento memento) {
        super.save(memento);
        memento.putString(TAG_VERSION_ID, this.versionId);
    }

    public void setDefaultNameAndDesc() {
        String name = Messages.OpenMPIResourceManagerConfiguration_defaultName;
        String conn = this.getConnectionName();
        if (conn != null && !conn.equals("")) {
            name = String.valueOf(name) + "@" + conn;
        }
        this.setName(name);
        this.setDescription(Messages.OpenMPIResourceManagerConfiguration_defaultDescription);
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public static class OpenMpiConfig {
        private AbstractToolRMConfiguration.ToolsConfig toolsConfig;
        private String versionId;

        public OpenMpiConfig() {
            this(new AbstractToolRMConfiguration.ToolsConfig(), null);
        }

        public OpenMpiConfig(AbstractToolRMConfiguration.ToolsConfig toolsConfig, String versionId) {
            this.toolsConfig = toolsConfig;
            this.versionId = versionId;
        }

        public AbstractToolRMConfiguration.ToolsConfig getToolsConfig() {
            return this.toolsConfig;
        }

        public void setToolsConfig(AbstractToolRMConfiguration.ToolsConfig toolsConfig) {
            this.toolsConfig = toolsConfig;
        }

        public String getVersionId() {
            return this.versionId;
        }

        public void setVersionId(String versionId) {
            this.versionId = versionId;
        }
    }
}

