/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.ui.preferences;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;

public class RelativeDirectoryFieldEditor
extends StringButtonFieldEditor {
    IPath relativeRoot = null;

    public RelativeDirectoryFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.setErrorMessage(JFaceResources.getString((String)"DirectoryFieldEditor.errorMessage"));
        this.setChangeButtonText(JFaceResources.getString((String)"openBrowse"));
        this.setValidateStrategy(1);
        this.createControl(parent);
    }

    public IPath getRelativeRoot() {
        return this.relativeRoot;
    }

    public void setRelativeRoot(IPath relativeRoot) {
        this.relativeRoot = relativeRoot;
    }

    private IPath getPathFromText() {
        String path = this.getTextControl().getText();
        path = path != null ? path.trim() : "";
        if (path.length() == 0 && !this.isEmptyStringAllowed()) {
            return null;
        }
        Path ipath = new Path(path);
        return ipath;
    }

    private IPath getAbsolutePathFromText() {
        IPath ipath = this.getPathFromText();
        if (ipath == null) {
            return null;
        }
        if (!ipath.isAbsolute()) {
            if (this.relativeRoot != null) {
                ipath = this.relativeRoot.append(ipath);
            } else {
                return null;
            }
        }
        return ipath;
    }

    protected boolean checkState() {
        String msg = null;
        IPath path = this.getPathFromText();
        if (path == null) {
            msg = this.getErrorMessage();
        } else {
            path = this.getAbsolutePathFromText();
            if (this.relativeRoot == null) {
                msg = this.getErrorMessage();
            } else if (!path.toFile().exists()) {
                msg = this.getErrorMessage();
            } else if (!path.toFile().isDirectory()) {
                msg = this.getErrorMessage();
            }
        }
        if (msg != null) {
            this.showErrorMessage(msg);
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    protected String changePressed() {
        IPath path = this.getAbsolutePathFromText();
        if (path != null) {
            File file = path.toFile();
            if (!file.exists()) {
                path = this.relativeRoot;
            }
        } else {
            path = this.relativeRoot;
        }
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        dialog.setFilterPath(path.toOSString());
        String dirName = dialog.open();
        if (dirName != null) {
            Path newPath = new Path(dirName = dirName.trim());
            int matches = newPath.matchingFirstSegments(this.relativeRoot);
            if (matches == this.relativeRoot.segmentCount()) {
                newPath = newPath.removeFirstSegments(matches);
                newPath = newPath.makeRelative();
            }
            return newPath.toOSString();
        }
        return null;
    }
}

