/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.utils.stream;

import java.io.OutputStream;
import org.eclipse.ptp.cell.utils.debug.Debug;
import org.eclipse.ptp.cell.utils.stream.IStreamListener;

public class ListenedOutputStream
extends OutputStream {
    private IStreamListener listener;

    public ListenedOutputStream(IStreamListener listener) {
        this.listener = listener;
        Debug.read();
    }

    public void write(byte[] b, int off, int len) throws java.io.IOException {
        byte[] bytes = new byte[len];
        System.arraycopy(b, off, bytes, 0, len);
        try {
            this.listener.newBytes(bytes, len);
        }
        catch (Exception e) {
            Debug.POLICY.error(Debug.DEBUG_STREAM, e);
            if (e instanceof java.io.IOException) {
                throw (java.io.IOException)e;
            }
            throw new IOException(e);
        }
    }

    public void write(byte[] b) throws java.io.IOException {
        byte[] bytes = new byte[b.length];
        System.arraycopy(b, 0, bytes, 0, b.length);
        try {
            this.listener.newBytes(b, b.length);
        }
        catch (Exception e) {
            Debug.POLICY.error(Debug.DEBUG_STREAM, e);
            if (e instanceof java.io.IOException) {
                throw (java.io.IOException)e;
            }
            throw new IOException(e);
        }
    }

    public void write(int b) throws java.io.IOException {
        byte[] bytes = new byte[]{(byte)b};
        try {
            this.listener.newBytes(bytes, bytes.length);
        }
        catch (Exception e) {
            Debug.POLICY.error(Debug.DEBUG_STREAM, e);
            if (e instanceof java.io.IOException) {
                throw (java.io.IOException)e;
            }
            throw new IOException(e);
        }
    }

    public void close() throws java.io.IOException {
        this.listener.streamClosed();
        super.close();
    }

    public class IOException
    extends java.io.IOException {
        private static final long serialVersionUID = 1L;
        Exception e;

        public IOException(Exception e) {
            super(e.getMessage());
            this.e = e;
        }

        public Throwable getCause() {
            return this.e;
        }
    }
}

