/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.proxy.debug.event;

import java.math.BigInteger;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugArgsEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugBreakpointHitEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugBreakpointSetEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugDataEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugDataExpValueEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugErrorEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugExitEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugInfoThreadsEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugInitEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugMemoryInfoEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugOKEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugPartialAIFEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugSetThreadSelectEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugSignalEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugSignalExitEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugSignalsEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugStackInfoDepthEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugStackframeEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugStepEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugSuspendEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugTypeEvent;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugVarsEvent;
import org.eclipse.ptp.proxy.debug.client.ProxyDebugAIF;
import org.eclipse.ptp.proxy.debug.client.ProxyDebugBreakpoint;
import org.eclipse.ptp.proxy.debug.client.ProxyDebugLineLocation;
import org.eclipse.ptp.proxy.debug.client.ProxyDebugLocator;
import org.eclipse.ptp.proxy.debug.client.ProxyDebugMemory;
import org.eclipse.ptp.proxy.debug.client.ProxyDebugMemoryInfo;
import org.eclipse.ptp.proxy.debug.client.ProxyDebugSignal;
import org.eclipse.ptp.proxy.debug.client.ProxyDebugStackFrame;
import org.eclipse.ptp.proxy.debug.event.AbstractProxyDebugEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugEventFactory;
import org.eclipse.ptp.proxy.event.IProxyEvent;
import org.eclipse.ptp.proxy.event.ProxyEventFactory;
import org.eclipse.ptp.proxy.packet.ProxyPacket;

public class ProxyDebugEventFactory
extends ProxyEventFactory
implements IProxyDebugEventFactory {
    public IProxyEvent toEvent(ProxyPacket packet) {
        AbstractProxyDebugEvent evt = null;
        IProxyEvent e = super.toEvent(packet);
        if (e != null) {
            return e;
        }
        String[] args = packet.getArgs();
        String bits = args[0];
        switch (packet.getID()) {
            case 111: {
                evt = new ProxyDebugOKEvent(packet.getTransID(), bits);
                break;
            }
            case 112: {
                int errCode = Integer.parseInt(args[1]);
                evt = new ProxyDebugErrorEvent(packet.getTransID(), bits, errCode, args[2]);
                break;
            }
            case 110: {
                int num_servers = Integer.parseInt(args[1]);
                evt = new ProxyDebugInitEvent(packet.getTransID(), bits, num_servers);
                break;
            }
            case 113: {
                switch (Integer.parseInt(args[1])) {
                    case 0: {
                        int hitId = Integer.parseInt(args[2]);
                        int bpTid = Integer.parseInt(args[3]);
                        int bpDep = Integer.parseInt(args[4]);
                        int numVars = Integer.parseInt(args[5]);
                        String[] vars = new String[numVars];
                        int i = 0;
                        while (i < numVars) {
                            vars[i] = args[i + 6];
                            ++i;
                        }
                        evt = new ProxyDebugBreakpointHitEvent(packet.getTransID(), bits, hitId, bpTid, bpDep, vars);
                        break;
                    }
                    case 1: {
                        int sigTid = Integer.parseInt(args[12]);
                        int sigDep = Integer.parseInt(args[13]);
                        ProxyDebugStackFrame sigFrame = null;
                        if (args[7].compareTo("*") != 0) {
                            sigFrame = ProxyDebugEventFactory.toFrame(args[7], args[8], args[9], args[11], args[10]);
                        }
                        int numVars = Integer.parseInt(args[14]);
                        String[] vars = new String[numVars];
                        int i = 0;
                        while (i < numVars) {
                            vars[i] = args[i + 15];
                            ++i;
                        }
                        evt = new ProxyDebugSignalEvent(packet.getTransID(), bits, args[2], args[6], sigFrame, sigTid, sigDep, vars);
                        break;
                    }
                    case 2: {
                        ProxyDebugStackFrame frame = ProxyDebugEventFactory.toFrame(args[2], args[3], args[4], args[6], args[5]);
                        int stTid = Integer.parseInt(args[7]);
                        int stDep = Integer.parseInt(args[8]);
                        int numVars = Integer.parseInt(args[9]);
                        String[] vars = new String[numVars];
                        int i = 0;
                        while (i < numVars) {
                            vars[i] = args[i + 10];
                            ++i;
                        }
                        evt = new ProxyDebugStepEvent(packet.getTransID(), bits, frame, stTid, stDep, vars);
                        break;
                    }
                    case 3: {
                        ProxyDebugStackFrame suspendFrame = ProxyDebugEventFactory.toFrame(args[2], args[3], args[4], args[6], args[5]);
                        int susTid = Integer.parseInt(args[7]);
                        int susDep = Integer.parseInt(args[8]);
                        int numVars = Integer.parseInt(args[9]);
                        String[] vars = new String[numVars];
                        int i = 0;
                        while (i < numVars) {
                            vars[i] = args[i + 10];
                            ++i;
                        }
                        evt = new ProxyDebugSuspendEvent(packet.getTransID(), bits, suspendFrame, susTid, susDep, vars);
                    }
                }
                break;
            }
            case 104: {
                int bpId = Integer.parseInt(args[1]);
                ProxyDebugLineLocation loc = ProxyDebugEventFactory.toLineLocation(args[7], args[10]);
                ProxyDebugBreakpoint bpt = ProxyDebugEventFactory.toBreakpoint(args[3], args[4], args[5], args[6], loc);
                evt = new ProxyDebugBreakpointSetEvent(packet.getTransID(), bits, bpId, bpt);
                break;
            }
            case 119: {
                int numSignals = Integer.parseInt(args[1]);
                ProxyDebugSignal[] signals = new ProxyDebugSignal[numSignals];
                int i = 0;
                while (i < numSignals) {
                    signals[i] = new ProxyDebugSignal(args[5 * i + 2], ProxyDebugEventFactory.toBoolean(Integer.parseInt(args[5 * i + 3])), ProxyDebugEventFactory.toBoolean(Integer.parseInt(args[5 * i + 4])), ProxyDebugEventFactory.toBoolean(Integer.parseInt(args[5 * i + 5])), args[5 * i + 6]);
                    ++i;
                }
                evt = new ProxyDebugSignalsEvent(packet.getTransID(), bits, signals);
                break;
            }
            case 102: {
                switch (Integer.parseInt(args[1])) {
                    case 0: {
                        int status = Integer.parseInt(args[2]);
                        evt = new ProxyDebugExitEvent(packet.getTransID(), bits, status);
                        break;
                    }
                    case 1: {
                        evt = new ProxyDebugSignalExitEvent(packet.getTransID(), bits, args[2], args[6]);
                    }
                }
                break;
            }
            case 105: {
                int numFrames = Integer.parseInt(args[1]);
                ProxyDebugStackFrame[] frames = new ProxyDebugStackFrame[numFrames];
                int i = 0;
                while (i < numFrames) {
                    frames[i] = ProxyDebugEventFactory.toFrame(args[5 * i + 2], args[5 * i + 3], args[5 * i + 4], args[5 * i + 6], args[5 * i + 5]);
                    ++i;
                }
                evt = new ProxyDebugStackframeEvent(packet.getTransID(), bits, frames);
                break;
            }
            case 115: {
                int current_thread_id = Integer.parseInt(args[1]);
                ProxyDebugStackFrame th_frame = ProxyDebugEventFactory.toFrame(args[2], args[3], args[4], args[6], args[5]);
                evt = new ProxyDebugSetThreadSelectEvent(packet.getTransID(), bits, current_thread_id, th_frame);
                break;
            }
            case 114: {
                int numThreads = Integer.parseInt(args[2]);
                String[] thread_ids = new String[numThreads + 1];
                thread_ids[0] = args[1];
                int i = 1;
                while (i < thread_ids.length) {
                    thread_ids[i] = args[i + 2];
                    ++i;
                }
                evt = new ProxyDebugInfoThreadsEvent(packet.getTransID(), bits, thread_ids);
                break;
            }
            case 116: {
                int depth = Integer.parseInt(args[1]);
                evt = new ProxyDebugStackInfoDepthEvent(packet.getTransID(), bits, depth);
                break;
            }
            case 117: {
                int numMemories = Integer.parseInt(args[8]);
                ProxyDebugMemory[] memories = new ProxyDebugMemory[numMemories];
                int data_len = 0;
                int i = 0;
                while (i < numMemories) {
                    int new_data_len = Integer.parseInt(args[data_len * i + 11]);
                    String addr = args[data_len * i + 9];
                    String ascii = args[data_len * i + 10];
                    String[] data_str = new String[new_data_len];
                    int j = 0;
                    while (j < new_data_len) {
                        data_str[j] = args[data_len * i + 12 + j];
                        ++j;
                    }
                    data_len = new_data_len;
                    memories[i] = new ProxyDebugMemory(addr, ascii, data_str);
                    ++i;
                }
                evt = new ProxyDebugMemoryInfoEvent(packet.getTransID(), bits, ProxyDebugEventFactory.toMemoryInfo(args[1], args[2], args[3], args[4], args[5], args[6], args[7], memories));
                break;
            }
            case 108: {
                int numVars = Integer.parseInt(args[1]);
                String[] vars = new String[numVars];
                int i = 0;
                while (i < numVars) {
                    vars[i] = args[i + 2];
                    ++i;
                }
                evt = new ProxyDebugVarsEvent(packet.getTransID(), bits, vars);
                break;
            }
            case 109: {
                int numArgs = Integer.parseInt(args[1]);
                String[] arg_strs = new String[numArgs];
                int i = 0;
                while (i < numArgs) {
                    arg_strs[i] = args[i + 2];
                    ++i;
                }
                evt = new ProxyDebugArgsEvent(packet.getTransID(), bits, arg_strs);
                break;
            }
            case 107: {
                evt = new ProxyDebugTypeEvent(packet.getTransID(), bits, args[1]);
                break;
            }
            case 106: {
                ProxyDebugAIF data = new ProxyDebugAIF(args[1], args[2], args[3]);
                evt = new ProxyDebugDataEvent(packet.getTransID(), bits, data);
                break;
            }
            case 120: {
                evt = new ProxyDebugDataExpValueEvent(packet.getTransID(), bits, args[1]);
                break;
            }
            case 121: {
                ProxyDebugAIF partial_data = new ProxyDebugAIF(args[1], args[2], args[3]);
                evt = new ProxyDebugPartialAIFEvent(packet.getTransID(), bits, partial_data, args[4]);
            }
        }
        return evt;
    }

    public static BigInteger decodeAddr(String str) {
        String[] parts = str.split(":");
        int len = Integer.parseInt(parts[0], 16) - 1;
        byte[] strBytes = new byte[len];
        int i = 0;
        int p = 0;
        while (i < len) {
            byte c = (byte)((Character.digit(parts[1].charAt(p), 16) & 0xF) << 4);
            strBytes[i] = c = (byte)(c | (byte)(Character.digit(parts[1].charAt(p + 1), 16) & 0xF));
            ++i;
            p += 2;
        }
        BigInteger a = new BigInteger(strBytes);
        return a;
    }

    public static ProxyDebugBreakpoint toBreakpoint(String ignore, String spec, String del, String type, ProxyDebugLineLocation loc) {
        return new ProxyDebugBreakpoint(ignore, spec, del, type, loc);
    }

    public static ProxyDebugLineLocation toLineLocation(String file, String line) {
        return new ProxyDebugLineLocation(file, line);
    }

    public static ProxyDebugLocator toLocator(String file, String func, String addr, String line) {
        return new ProxyDebugLocator(file, func, line, addr);
    }

    public static ProxyDebugStackFrame toFrame(String level, String file, String func, String line, String addr) {
        int stepLevel = Integer.parseInt(level);
        return new ProxyDebugStackFrame(stepLevel, ProxyDebugEventFactory.toLocator(file, func, addr, line));
    }

    public static ProxyDebugMemoryInfo toMemoryInfo(String addr, String nextRow, String prevRow, String nextPage, String prevPage, String numBytes, String totalBytes, ProxyDebugMemory[] memories) {
        return new ProxyDebugMemoryInfo(addr, nextRow, prevRow, nextPage, prevPage, numBytes, totalBytes, memories);
    }

    public static boolean toBoolean(int value) {
        return value != 0;
    }
}

