/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.includebrowser;

import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.includebrowser.IBMessages;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ptp.internal.rdt.core.includebrowser.IIncludeBrowserService;
import org.eclipse.ptp.internal.rdt.ui.includebrowser.IBViewPart;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class IncludeBrowserUI {
    public static void open(IIncludeBrowserService service, IWorkbenchWindow window, ICElement input) {
        try {
            ITranslationUnit tu = IncludeBrowserUI.convertToTranslationUnit(service, input);
            if (tu != null) {
                IWorkbenchPage page = window.getActivePage();
                IBViewPart result = (IBViewPart)page.showView("org.eclipse.ptp.rdt.ui.includeBrowser");
                result.setInput(tu);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle((CoreException)e, (Shell)window.getShell(), (String)IBMessages.OpenIncludeBrowserAction_label, null);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static void open(IIncludeBrowserService service, ITextEditor editor, ITextSelection sel) {
        if (editor != null) {
            IWorkingCopy inputCElement = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
            IncludeBrowserUI.open(service, editor.getSite().getWorkbenchWindow(), (ICElement)inputCElement);
        }
    }

    private static ITranslationUnit convertToTranslationUnit(IIncludeBrowserService service, ICElement input) throws CoreException, InterruptedException {
        ITranslationUnit result = null;
        if (input instanceof IInclude) {
            result = IncludeBrowserUI.findTargetTranslationUnit(service, (IInclude)input);
        }
        if (result == null && input instanceof ISourceReference) {
            result = ((ISourceReference)input).getTranslationUnit();
        }
        return result;
    }

    private static ITranslationUnit findTargetTranslationUnit(IIncludeBrowserService service, IInclude input) throws CoreException, InterruptedException {
        IIndexFileLocation loc;
        IIndexInclude include;
        ICProject project = input.getCProject();
        if (project != null && (include = service.findInclude(input)) != null && (loc = include.getIncludesLocation()) != null) {
            return CoreModelUtil.findTranslationUnitForLocation((IIndexFileLocation)loc, (ICProject)project);
        }
        return null;
    }
}

