/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.alf.ui.wizard;

import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.cell.alf.ui.Activator;
import org.eclipse.ptp.cell.alf.ui.Messages;
import org.eclipse.ptp.cell.alf.ui.core.ALFBuffer;
import org.eclipse.ptp.cell.alf.ui.core.ALFBufferValidator;
import org.eclipse.ptp.cell.alf.ui.debug.Debug;
import org.eclipse.ptp.cell.alf.ui.wizard.ALFBufferDialog;
import org.eclipse.ptp.cell.alf.ui.wizard.ALFWizard;
import org.eclipse.ptp.cell.alf.ui.wizard.ALFWizardPageA;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ALFWizardPageB
extends WizardPage {
    private static long TOTAL_AVAIL_SPU_MEMORY = 251904L;
    private Table alfBuffersTable;
    private ArrayList alfBuffers;
    private ALFBufferValidator validator;
    private Button addBufferButton;
    private Button editBufferButton;
    private Button removeBufferButton;
    private Text numDTEntry;
    private Text numDTEntryHelp;
    private Text localMemoryRemaining;
    private Text localMemoryHelp;
    private int editIndex;

    protected ALFWizardPageB(String pageName, String title, String description) {
        super(pageName);
        this.setTitle(title);
        this.setDescription(description);
        this.alfBuffers = new ArrayList();
        this.validator = new ALFBufferValidator(this);
        this.editIndex = -1;
    }

    public boolean canFlipToNextPage() {
        this.updateAndValidateBuffers();
        return super.canFlipToNextPage();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setFont(font);
        Label bufferListLabel = new Label(composite, 0);
        bufferListLabel.setText(String.valueOf(Messages.ALFWizardPageB_bufferListTitle) + ":");
        bufferListLabel.setLayoutData((Object)new GridData(36));
        this.alfBuffersTable = new Table(composite, 4);
        GridData tableData = new GridData(768);
        tableData.widthHint = 300;
        tableData.heightHint = 125;
        this.alfBuffersTable.setLayoutData((Object)tableData);
        this.alfBuffersTable.setFont(font);
        this.alfBuffersTable.setLinesVisible(false);
        this.alfBuffersTable.setHeaderVisible(true);
        this.alfBuffersTable.setEnabled(true);
        TableColumn column1 = new TableColumn(this.alfBuffersTable, 16384, 0);
        TableColumn column2 = new TableColumn(this.alfBuffersTable, 131072, 1);
        column1.setText(Messages.ALFWizardPageB_columnOneName);
        column1.setWidth(385);
        column2.setText(Messages.ALFWizardPageB_columnTwoName);
        column2.setWidth(85);
        Composite buttonsComposite = new Composite(composite, 0);
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 3;
        buttonsComposite.setLayout((Layout)layout3);
        this.addBufferButton = new Button(buttonsComposite, 8);
        this.addBufferButton.setLayoutData((Object)new GridData(16));
        this.addBufferButton.setText(Messages.ALFWizardPageB_addBufferButtonText);
        this.addBufferButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    ALFWizardPageB.this.handleAddBufferPressed();
                    ALFWizardPageB.this.updateAndValidateBuffers();
                    ALFWizardPageB.this.getWizard().getContainer().updateButtons();
                }
                catch (Exception e) {
                    Debug.POLICY.logError((Throwable)e);
                }
            }
        });
        this.editBufferButton = new Button(buttonsComposite, 8);
        this.editBufferButton.setLayoutData((Object)new GridData(16));
        this.editBufferButton.setText(Messages.ALFWizardPageB_editBufferButtonText);
        this.editBufferButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    ALFWizardPageB.this.handleEditBufferPressed();
                    ALFWizardPageB.this.updateAndValidateBuffers();
                    ALFWizardPageB.this.getWizard().getContainer().updateButtons();
                }
                catch (Exception e) {
                    Debug.POLICY.logError((Throwable)e);
                }
            }
        });
        this.removeBufferButton = new Button(buttonsComposite, 8);
        this.removeBufferButton.setLayoutData((Object)new GridData(16));
        this.removeBufferButton.setText(Messages.ALFWizardPageB_removeBufferButtonText);
        this.removeBufferButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    ALFWizardPageB.this.handleRemoveBufferPressed();
                    ALFWizardPageB.this.updateAndValidateBuffers();
                    ALFWizardPageB.this.getWizard().getContainer().updateButtons();
                }
                catch (Exception e) {
                    Debug.POLICY.logError((Throwable)e);
                }
            }
        });
        Group localMemoryGroup = new Group(composite, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 2;
        localMemoryGroup.setText(Messages.ALFWizardPageB_localMemoryGroupText);
        localMemoryGroup.setLayout((Layout)layout2);
        localMemoryGroup.setLayoutData((Object)new GridData(768));
        localMemoryGroup.setFont(font);
        Label localMemoryTotalLabel = new Label((Composite)localMemoryGroup, 0);
        localMemoryTotalLabel.setText(Messages.ALFWizardPageB_localMemoryTotalMemoryLabelText);
        localMemoryTotalLabel.setLayoutData((Object)new GridData(36));
        Text localMemoryTotal = new Text((Composite)localMemoryGroup, 12);
        localMemoryTotal.setText(String.valueOf(TOTAL_AVAIL_SPU_MEMORY) + " B");
        localMemoryTotal.setLayoutData((Object)new GridData(36));
        localMemoryTotal.setBackground(localMemoryTotal.getDisplay().getSystemColor(22));
        Label localMemoryRemainingLabel = new Label((Composite)localMemoryGroup, 0);
        localMemoryRemainingLabel.setText(Messages.ALFWizardPageB_localMemoryRemainingMemoryLabelText);
        localMemoryRemainingLabel.setLayoutData((Object)new GridData(36));
        this.localMemoryRemaining = new Text((Composite)localMemoryGroup, 12);
        this.localMemoryRemaining.setText(Messages.ALFWizardPageB_localMemoryRemainingMemoryInitialText);
        this.localMemoryRemaining.setLayoutData((Object)new GridData(36));
        this.localMemoryRemaining.setBackground(this.localMemoryRemaining.getDisplay().getSystemColor(22));
        this.localMemoryHelp = ALFWizard.createWhatsThisHelpText((Composite)localMemoryGroup, this.getShell(), this.getWizard(), "data/local_memory_help.html", 325, 275);
        this.localMemoryHelp.getFont();
        Group numDTEntryGroup = new Group(composite, 0);
        numDTEntryGroup.setText(Messages.ALFWizardPageB_numDTEntryGroupText);
        numDTEntryGroup.setLayout((Layout)layout2);
        numDTEntryGroup.setLayoutData((Object)new GridData(768));
        numDTEntryGroup.setFont(font);
        Label numDTEntryLabel = new Label((Composite)numDTEntryGroup, 0);
        numDTEntryLabel.setText(Messages.ALFWizardPageB_numDTEntryLabelText);
        numDTEntryLabel.setLayoutData((Object)new GridData(36));
        this.numDTEntry = new Text((Composite)numDTEntryGroup, 12);
        GridData gd1 = new GridData(36);
        gd1.widthHint = 75;
        gd1.minimumWidth = 75;
        this.numDTEntry.setLayoutData((Object)gd1);
        this.numDTEntry.setBackground(this.numDTEntry.getDisplay().getSystemColor(22));
        this.numDTEntryHelp = ALFWizard.createWhatsThisHelpText((Composite)numDTEntryGroup, this.getShell(), this.getWizard(), "data/dt_entry_help.html", 550, 275);
        this.numDTEntryHelp.getFont();
        this.updateAndValidateBuffers();
        this.getWizard().getContainer().updateButtons();
        this.initializeDialogUnits((Control)composite);
        this.setControl((Control)composite);
    }

    public boolean doesSameBufferNameExist(String name) {
        int i = 0;
        while (i < this.alfBuffers.size()) {
            ALFBuffer tempBuffer = (ALFBuffer)this.alfBuffers.get(i);
            if (name.equals(tempBuffer.getName()) && this.editIndex != i) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected ArrayList getBuffers() {
        return this.alfBuffers;
    }

    private void handleAddBufferPressed() {
        ALFBuffer newBuffer;
        ALFWizardPageA prevPage = (ALFWizardPageA)this.getPreviousPage();
        if (prevPage == null) {
            throw new RuntimeException(Messages.ALFWizardPageB_previousPageIsNullErrorMsg);
        }
        ALFBufferDialog dialog = new ALFBufferDialog(this.getShell(), Messages.ALFWizardPageB_createAlfBufferDialogTitle, null, this.validator, this);
        dialog.setBlockOnOpen(true);
        int returnCode = dialog.open();
        if (returnCode == 0 && (newBuffer = dialog.getBuffer()) != null) {
            int bufferType = newBuffer.getBufferType();
            TableItem newItem = new TableItem(this.alfBuffersTable, 16384);
            Image nullImage = null;
            newItem.setImage(nullImage);
            newItem.setText(0, newBuffer.getName());
            switch (bufferType) {
                case 0: {
                    newItem.setText(1, Messages.ALFWizardPageB_inputBufferType);
                    break;
                }
                case 1: {
                    newItem.setText(1, Messages.ALFWizardPageB_outputBufferType);
                    break;
                }
                default: {
                    newItem.setText(1, Messages.ALFWizardPageB_notAvailableTxt);
                }
            }
            this.alfBuffersTable.select(this.alfBuffersTable.indexOf(newItem));
            this.alfBuffers.add(newBuffer);
        }
    }

    private void handleEditBufferPressed() {
        ALFBuffer buffer;
        int index = this.alfBuffersTable.getSelectionIndex();
        if (index == -1) {
            return;
        }
        this.editIndex = index;
        ALFBufferDialog dialog = new ALFBufferDialog(this.getShell(), Messages.ALFWizardPageB_editAlfBufferDialogTitle, (ALFBuffer)this.alfBuffers.get(index), this.validator, this);
        int returnCode = dialog.open();
        if (returnCode == 0 && (buffer = dialog.getBuffer()) != null) {
            int bufferType = buffer.getBufferType();
            TableItem item = this.alfBuffersTable.getItem(index);
            item.setText(0, buffer.getName());
            switch (bufferType) {
                case 0: {
                    item.setText(1, Messages.ALFWizardPageB_inputBufferType);
                    break;
                }
                case 1: {
                    item.setText(1, Messages.ALFWizardPageB_outputBufferType);
                    break;
                }
                default: {
                    item.setText(1, Messages.ALFWizardPageB_notAvailableTxt);
                }
            }
            this.alfBuffers.set(index, dialog.getBuffer());
        }
        this.editIndex = -1;
    }

    private void handleRemoveBufferPressed() {
        int selected = this.alfBuffersTable.getSelectionIndex();
        if (selected != -1) {
            String bufferName = this.alfBuffersTable.getItem(selected).getText(0);
            this.alfBuffersTable.remove(selected);
            int i = 0;
            while (i < this.alfBuffers.size()) {
                ALFBuffer temp = (ALFBuffer)this.alfBuffers.get(i);
                if (temp.getName().equals(bufferName)) {
                    this.alfBuffers.remove(i);
                    break;
                }
                ++i;
            }
        }
    }

    public boolean is64bit() {
        ALFWizardPageA pageA = (ALFWizardPageA)this.getPreviousPage();
        if (pageA == null) {
            return false;
        }
        return pageA.is64bit();
    }

    public boolean isNumDTEntriesValid(long numDT) {
        if (numDT < 1L) {
            return false;
        }
        if (this.alfBuffers == null || this.alfBuffers.size() == 0) {
            return true;
        }
        int i = 0;
        while (i < this.alfBuffers.size()) {
            ALFBuffer temp = (ALFBuffer)this.alfBuffers.get(i);
            if (temp.getNumberDTEntries() != numDT) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isPageComplete() {
        this.updateAndValidateBuffers();
        return super.isPageComplete();
    }

    protected void updateAndValidateBuffers() {
        ALFWizardPageA pageA = (ALFWizardPageA)this.getPreviousPage();
        if (pageA == null) {
            if (this.getErrorMessage() != null) {
                this.setErrorMessage(null);
                this.setPageComplete(false);
            }
            this.updateLocalMemorySize();
            this.updateNumDTEntries();
            return;
        }
        if (this.alfBuffers == null || this.alfBuffers.size() == 0) {
            if (this.getErrorMessage() != null) {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
            this.updateLocalMemorySize();
            this.updateNumDTEntries();
            return;
        }
        int expNumAccel = pageA.getExpAccelNum();
        Image errorImage = Activator.getImageDescriptor("data/images/error.jpg").createImage();
        Image nullImage = null;
        boolean allBuffersValid = true;
        int i = 0;
        while (i < this.alfBuffers.size()) {
            ALFBuffer buffer = (ALFBuffer)this.alfBuffers.get(i);
            TableItem item = this.alfBuffersTable.getItem(i);
            if (expNumAccel == 0) {
                if (buffer.getDistributionModelX() == 1 || buffer.getDistributionModelY() == 1 || buffer.getDistributionModelZ() == 1) {
                    if (this.getErrorMessage() == null) {
                        this.setErrorMessage(Messages.ALFWizardPageB_errorMsgInvalidBuffer);
                        this.setPageComplete(false);
                    }
                    buffer.setIsValid(false);
                    item.setImage(errorImage);
                    allBuffersValid = false;
                } else {
                    buffer.setIsValid(true);
                    item.setImage(nullImage);
                }
            } else {
                long newDistSize;
                if (buffer.getDistributionModelX() == 1) {
                    newDistSize = buffer.getDimensionSizeX() / (long)expNumAccel;
                    if (newDistSize > 0L) {
                        buffer.setDistributionSizeX(newDistSize);
                    } else {
                        buffer.setDistributionSizeX(0L);
                    }
                }
                if (buffer.getDistributionSizeY() == 1L) {
                    newDistSize = buffer.getDimensionSizeY() / (long)expNumAccel;
                    if (newDistSize > 0L) {
                        buffer.setDistributionSizeY(newDistSize);
                    } else {
                        buffer.setDistributionSizeY(0L);
                    }
                }
                if (buffer.getDistributionSizeZ() == 1L) {
                    newDistSize = buffer.getDimensionSizeZ() / (long)expNumAccel;
                    if (newDistSize > 0L) {
                        buffer.setDistributionSizeZ(newDistSize);
                    } else {
                        buffer.setDistributionSizeZ(0L);
                    }
                }
                buffer.setIsValid(true);
                item.setImage(nullImage);
            }
            ++i;
        }
        if (allBuffersValid && this.getErrorMessage() != null) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
        this.updateLocalMemorySize();
        this.updateNumDTEntries();
    }

    public boolean updateLocalMemorySize() {
        IWizardPage prevPage = this.getPreviousPage();
        if (prevPage == null || !(prevPage instanceof ALFWizardPageA)) {
            return true;
        }
        ALFWizardPageA pageA = (ALFWizardPageA)prevPage;
        long usedMem = pageA.getExpStackSize();
        long dataTransferSize = 0L;
        if (usedMem == -1L) {
            return true;
        }
        int i = 0;
        while (i < this.alfBuffers.size()) {
            ALFBuffer tempBuffer = (ALFBuffer)this.alfBuffers.get(i);
            dataTransferSize = ALFBufferValidator.computeDataTransferSize(tempBuffer.getElementType(), tempBuffer.getNumDimensions(), tempBuffer.getDistributionSizeX(), tempBuffer.getDistributionSizeY(), tempBuffer.getDistributionSizeZ(), this.is64bit());
            if (dataTransferSize != -1L) {
                usedMem += dataTransferSize;
            }
            ++i;
        }
        long remainingMem = TOTAL_AVAIL_SPU_MEMORY - usedMem;
        this.localMemoryRemaining.setText(String.valueOf(remainingMem) + " B");
        this.localMemoryRemaining.pack(true);
        if (remainingMem < 0L) {
            this.localMemoryRemaining.setForeground(new Color((Device)this.numDTEntry.getDisplay(), 255, 0, 0));
            return false;
        }
        this.localMemoryRemaining.setForeground(this.numDTEntry.getDisplay().getSystemColor(21));
        return true;
    }

    public boolean updateNumDTEntries() {
        if (this.alfBuffers == null || this.alfBuffers.size() == 0) {
            this.numDTEntry.setText(Messages.ALFWizardPageB_numDTEntryStatusNA);
            this.numDTEntry.pack(true);
            this.numDTEntry.setForeground(this.numDTEntry.getDisplay().getSystemColor(21));
            return true;
        }
        ALFBuffer currentBuffer = (ALFBuffer)this.alfBuffers.get(0);
        long currentNumDT = currentBuffer.getNumberDTEntries();
        boolean valid = true;
        int i = 1;
        while (i < this.alfBuffers.size()) {
            currentBuffer = (ALFBuffer)this.alfBuffers.get(i);
            long newNumDT = currentBuffer.getNumberDTEntries();
            if (newNumDT != currentNumDT) {
                valid = false;
                break;
            }
            currentNumDT = newNumDT;
            ++i;
        }
        if (valid) {
            this.numDTEntry.setText(String.valueOf(Messages.ALFWizardPageB_numDTEntryStatusEqual) + " (" + currentNumDT + ")");
            this.numDTEntry.pack(true);
            this.numDTEntry.setForeground(this.numDTEntry.getDisplay().getSystemColor(21));
            return true;
        }
        this.numDTEntry.setText(Messages.ALFWizardPageB_numDTEntryStatusUnequal);
        this.numDTEntry.pack(true);
        this.numDTEntry.setForeground(new Color((Device)this.numDTEntry.getDisplay(), 255, 0, 0));
        return false;
    }
}

