/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.tau.papiselect.papic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.ptp.perf.tau.papiselect.papic.Component;
import org.eclipse.ptp.perf.tau.papiselect.papic.ETItem;
import org.eclipse.ptp.perf.tau.papiselect.papic.Event;
import org.eclipse.ptp.perf.tau.papiselect.papic.EventSet;
import org.eclipse.ptp.perf.tau.papiselect.papic.EventTree;
import org.eclipse.ptp.perf.tau.papiselect.papic.Modifier;
import org.eclipse.ptp.perf.tau.papiselect.papic.PapiCSelect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTreeDialog
extends Dialog {
    CheckboxTreeViewer treeV;
    EventTree et;
    private String toolPath;
    PapiCSelect cSelect;

    public EventTreeDialog(Shell parentShell, String tp) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.toolPath = tp;
    }

    protected Control createDialogArea(Composite top) {
        top.getShell().setText("PAPI Event Selection");
        Composite parent = (Composite)super.createDialogArea(top);
        GridLayout gl = new GridLayout();
        parent.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.heightHint = 500;
        gd.widthHint = 350;
        this.treeV = new CheckboxTreeViewer(parent, 2048);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeV);
        this.cSelect = new PapiCSelect(this.toolPath);
        this.et = this.cSelect.getEventTree();
        this.treeV.setContentProvider((IContentProvider)this.et);
        this.treeV.getTree().setLayoutData((Object)gd);
        this.treeV.setLabelProvider((IBaseLabelProvider)new ETreeCellLabelProvider());
        this.treeV.setInput((Object)this.et);
        this.treeV.setGrayedElements(new Object[0]);
        this.treeV.expandToLevel(3);
        this.treeV.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (EventTreeDialog.this.treeV.getGrayed(element)) {
                    EventTreeDialog.this.treeV.setChecked(element, true);
                    return;
                }
                if (element instanceof ETItem) {
                    EventTreeDialog.this.doCheck((ETItem)element, event.getChecked());
                }
            }
        });
        return parent;
    }

    protected void okPressed() {
        ArrayList<String> badCom = this.checkCommands();
        if (badCom.size() > 0) {
            String events = "";
            int i = 0;
            while (i < badCom.size()) {
                events = String.valueOf(events) + badCom.get(i);
                if (i != badCom.size() - 1) {
                    events = String.valueOf(events) + ", ";
                }
                ++i;
            }
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Event Modifiers Reqired", (String)("Please select at least one modifier for: " + events));
            return;
        }
        super.okPressed();
    }

    public ArrayList<String> getCommands() {
        ArrayList<String> selE = new ArrayList<String>();
        int i = 0;
        while (i < this.et.children.size()) {
            int j = 0;
            while (j < ((ETItem)this.et.children.get((int)i)).children.size()) {
                int k = 0;
                while (k < ((ETItem)this.et.children.get((int)i)).children.get((int)j).children.size()) {
                    Event e = (Event)((ETItem)this.et.children.get((int)i)).children.get((int)j).children.get(k);
                    if (e.getCheck()) {
                        selE.add(e.getCommand());
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return selE;
    }

    public ArrayList<String> checkCommands() {
        ArrayList<String> selE = new ArrayList<String>();
        int i = 0;
        while (i < this.et.children.size()) {
            int j = 0;
            while (j < ((ETItem)this.et.children.get((int)i)).children.size()) {
                int k = 0;
                while (k < ((ETItem)this.et.children.get((int)i)).children.get((int)j).children.size()) {
                    Event e = (Event)((ETItem)this.et.children.get((int)i)).children.get((int)j).children.get(k);
                    if (e.getCheck() && e.children.size() > 0 && e.testCommand().indexOf(":") < 0) {
                        selE.add(e.testCommand());
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return selE;
    }

    private void doCheck(ETItem element, boolean checked) {
        if (element instanceof EventTree || element instanceof Component || element instanceof EventSet) {
            ETItem eti = element;
            ETItem toCheck = null;
            eti.setCheck(checked);
            int i = 0;
            while (i < eti.children.size()) {
                toCheck = eti.children.get(i);
                if (!this.treeV.getGrayed((Object)toCheck) && this.treeV.getChecked((Object)toCheck) != checked) {
                    this.treeV.setChecked((Object)toCheck, checked);
                    this.doCheck(toCheck, checked);
                }
                ++i;
            }
        } else if (element instanceof Modifier) {
            if (!this.treeV.getGrayed((Object)element)) {
                element.checked = checked;
            }
        } else if (element instanceof Event) {
            if (!this.treeV.getGrayed((Object)element)) {
                Event e = (Event)element;
                e.setCheck(checked);
                Component c = (Component)e.parent.parent;
                Set<Integer>[] av = this.cSelect.getAvailable(c.index, c.eNames);
                if (av == null) {
                    return;
                }
                HashSet<Integer> grey = new HashSet<Integer>(((EventSet)c.children.get((int)0)).fullSet);
                grey.removeAll(av[0]);
                ArrayList all = ((EventSet)c.children.get((int)0)).children;
                this.checkGray(all, grey);
                grey = new HashSet<Integer>(((EventSet)c.children.get((int)1)).fullSet);
                grey.removeAll(av[1]);
                all = ((EventSet)c.children.get((int)1)).children;
                this.checkGray(all, grey);
            } else {
                this.treeV.setChecked((Object)element, true);
            }
        }
    }

    private void checkGray(ArrayList<ETItem> all, Set<Integer> grey) {
        boolean isGrey = false;
        Event test = null;
        int i = 0;
        while (i < all.size()) {
            test = (Event)all.get(i);
            boolean bl = isGrey = !test.checked && grey.contains(new Integer(test.index));
            if (isGrey) {
                this.treeV.setGrayChecked((Object)test, true);
            } else {
                this.treeV.setGrayed((Object)test, false);
                if (!test.checked) {
                    this.treeV.setChecked((Object)test, false);
                }
            }
            ++i;
        }
    }

    class ETreeCellLabelProvider
    extends CellLabelProvider {
        ETreeCellLabelProvider() {
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 1000;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 50000;
        }

        public void update(ViewerCell cell) {
            cell.setText(((ETItem)cell.getElement()).label);
        }

        public String getToolTipText(Object o) {
            if (o instanceof ETItem) {
                return ((ETItem)o).desc;
            }
            return null;
        }
    }
}

