/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.upc.editorHelp;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.ptp.pldt.common.editorHelp.CHelpBookImpl;
import org.eclipse.ptp.pldt.common.editorHelp.FunctionPrototypeSummaryImpl;
import org.eclipse.ptp.pldt.common.editorHelp.FunctionSummaryImpl;
import org.eclipse.ptp.pldt.upc.UPCPlugin;

public class UPCCHelpBook
extends CHelpBookImpl {
    private static final String TITLE = "UPC C Help Book";
    private Map<String, String> desc = new HashMap<String, String>();

    public UPCCHelpBook() {
        super(UPCPlugin.getPluginId());
        this.desc.put("upc_addrfield", "Returns an implementation-defined value reflecting the <q>local address</q>of the object pointed to by the pointer-to-shared argument.");
        this.desc.put("upc_affinitysize", "A convenience function which calculates the exact size of the local portion of the data in a shared object with affinity to <code>threadid</code>.");
        this.desc.put("upc_all_alloc", "Allocates shared space");
        this.desc.put("upc_all_broadcast", "Copies a block of memory with affinity to a single thread to a block of shared memory on each thread.");
        this.desc.put("upc_all_lock_alloc", "Dynamically allocates a lock and returns a pointer to it. The lock is created in an unlocked state.");
        this.desc.put("upc_all_exchange", "Copies the ith block of memory from a shared memory area that has affinity to thread j to the jth block of a shared memory area that has affinity to thread i");
        this.desc.put("upc_all_gather", "Copies a block of shared memory that has affinity to the ith thread to the ith block of a shared memory area that has affinity to a single thread.");
        this.desc.put("upc_all_gather_all", "Copies a block of memory from one shared memory area with affinity to the ith thread to the ith block of a shared memory area on each thread.");
        this.desc.put("upc_all_lock_alloc", "Dynamically allocates a lock and returns a pointer to it. The lock is created in an unlocked state.");
        this.desc.put("upc_all_permute", "Copies a block of memory from a shared memory area that has affinity to the ith thread to a block of a shared memory that has affinity to thread perm[i].");
        this.desc.put("upc_all_scatter", "Copies the ith block of an area of shared memory with affinity to a single thread to a block of shared memory with affinity to the ith thread.");
        this.desc.put("upc_alloc", "Allocates shared space of at least nbytes with affinity to the calling thread.");
        this.desc.put("upc_free", "Frees dynamically allocated shared storage");
        this.desc.put("upc_global_alloc", "Allocates shared space");
        this.desc.put("upc_global_exit", "Flushes all I/O, releases all storage, and terminates the execution for all active threads.");
        this.desc.put("upc_global_lock_alloc", "Dynamically allocates a lock and returns a pointer to it. The lock is created in an unlocked state.");
        this.desc.put("upc_local_alloc", "Deprecated. Use upc_alloc instead.\nAllocates shared space.");
        this.desc.put("upc_lock_attempt", "Attempts to set the state of a lock to locked. Return code indicates previous state.");
        this.desc.put("upc_lock_free", "Frees all resources associated with a lock.");
        this.desc.put("upc_lock_t", "UPC type for a lock");
        this.desc.put("upc_lock", "Sets the state of a lock to locked.");
        this.desc.put("upc_memcpy", "Copies n characters from a shared object having affinity with one thread to a shared object having affinity with the same or another thread.");
        this.desc.put("upc_memget", "Copies n characters from a shared object with affinity to any single thread to an object on the calling thread.");
        this.desc.put("upc_memset", "Copies a value, converted to an unsigned char, to a shared object with affinity to any single thread.");
        this.desc.put("upc_phaseof", "Returns the phase component of the pointer-to-shared argument.");
        this.desc.put("upc_resetphase", "Returns a pointer-to-shared which is identical to its input except that it has zero phase");
        this.desc.put("upc_threadof", "Returns the index of the thread that has affinity to the shared object pointed to by the argument.");
        this.desc.put("upc_unlock", "Sets the state of a lock to unlocked.");
        this.desc.put("shared", "this is a shared UPC keyword");
        String desc = "";
        this.funcName2FuncInfo.put("upc_addrfield", this.fps("upc_addrfield", "", desc, "size_t", "shared void *ptr"));
        this.funcName2FuncInfo.put("upc_affinitysize", this.fps("upc_affinitysize", "", desc, "size_t", "size_t totalsize, size_t nbytes, size_t threadid"));
        this.funcName2FuncInfo.put("upc_all_alloc", this.fps("upc_all_alloc", "", desc, "void", "size_t nblocks, size_t nbytes"));
        this.funcName2FuncInfo.put("upc_all_broadcast", this.fps("upc_all_broadcast", "", desc, "void", "shared void * restrict dst, shared const void * restrict src, size_t nbytes, upc_flag_t flags"));
        this.funcName2FuncInfo.put("upc_all_exchange", this.fps("upc_all_exchange", "", desc, "void", "shared void * restrict dst, shared const void * restrict src, size_t nbytes, upc_flag_t flags"));
        this.funcName2FuncInfo.put("upc_all_gather_all", this.fps("upc_all_gather_all", "", desc, "void", "shared void * restrict dst, shared const void * restrict src, size_t nbytes, upc_flag_t flags"));
        this.funcName2FuncInfo.put("upc_all_gather", this.fps("upc_all_gather", "", desc, "void", "shared void * restrict dst, shared const void * restrict src, size_t nbytes, upc_flag_t flags"));
        this.funcName2FuncInfo.put("upc_all_lock_alloc", this.fps("upc_all_lock_alloc", "", desc, "upc_lock_t", "void"));
        this.funcName2FuncInfo.put("upc_all_permute", this.fps("upc_all_permute", "", desc, "void", "shared void * restrict dst, shared const void * restrict src, shared const int * restrict perm, size_t nbytes, upc_flag_t flags"));
        this.funcName2FuncInfo.put("upc_all_scatter", this.fps("upc_all_scatter", "", desc, "void", "shared void * restrict dst, shared const void * restrict src, size_t nbytes, upc_flag_t flags"));
        this.funcName2FuncInfo.put("upc_alloc", this.fps("upc_alloc", "", desc, "void", "size_t nbytes"));
        this.funcName2FuncInfo.put("upc_free", this.fps("upc_free", "", desc, "void", "shared void *ptr"));
        this.funcName2FuncInfo.put("upc_global_alloc", this.fps("upc_global_alloc", "", desc, "void", "int status"));
        this.funcName2FuncInfo.put("upc_global_exit", this.fps("upc_global_exit", "", desc, "void", "int status"));
        this.funcName2FuncInfo.put("upc_global_lock_alloc", this.fps("upc_global_lock_alloc", "", desc, "upc_lock_t", "void"));
        this.funcName2FuncInfo.put("upc_local_alloc", this.fps("upc_local_alloc", "", desc, "void", "size_t nblocks, size_t nbytes"));
        this.funcName2FuncInfo.put("upc_lock_attempt", this.fps("upc_lock_attempt", "", desc, "int", "upc_lock_t *ptr"));
        this.funcName2FuncInfo.put("upc_lock_free", this.fps("upc_lock_free", "", desc, "upc_lock_t", "void"));
        this.funcName2FuncInfo.put("upc_lock", this.fps("upc_lock", "", desc, "void", "upc_lock_t *ptr"));
        this.funcName2FuncInfo.put("upc_memcpy", this.fps("upc_memcpy", "", desc, "void", "shared void * restrict dst, shared const void * restrict src, size_t n"));
        this.funcName2FuncInfo.put("upc_memget", this.fps("upc_memget", "", desc, "void", "void * restrict dst, shared const void * restrict src, size_t n"));
        this.funcName2FuncInfo.put("upc_memset", this.fps("upc_memset", "", desc, "void", "shared void *dst, int c, size_t n"));
        this.funcName2FuncInfo.put("upc_phaseof", this.fps("upc_memset", "", desc, "size_t", "shared void *ptr"));
        this.funcName2FuncInfo.put("upc_resetphase", this.fps("upc_resetphase", "", desc, "void", "shared void *ptr"));
        this.funcName2FuncInfo.put("upc_threadof", this.fps("upc_threadof", "", desc, "size_t", "shared void *ptr"));
        this.funcName2FuncInfo.put("upc_unlock", this.fps("upc_unlock", "", desc, "void", "upc_lock_t *ptr"));
        this.funcName2FuncInfo.put("shared", this.fps("shared", "", desc, "", ""));
        this.setTitle(TITLE);
    }

    protected IFunctionSummary fps(String name, String namespace, String description, String returnType, String args) {
        if (description == null || description.length() == 0) {
            description = this.getDesc(name);
        }
        FunctionSummaryImpl fps = new FunctionSummaryImpl(name, namespace, description, (IFunctionSummary.IFunctionPrototypeSummary)new FunctionPrototypeSummaryImpl(name, returnType, args), null);
        return fps;
    }

    protected String getDesc(String key) {
        String description = this.desc.get(key);
        if (description == null) {
            description = String.valueOf(key) + " description";
        }
        return description;
    }

    public int getCHelpType() {
        return -1;
    }
}

