/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.debug.be.cdi.command;

import java.util.ArrayList;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;
import org.eclipse.ptp.cell.debug.be.BEMessages;
import org.eclipse.ptp.cell.debug.be.cdi.command.output.MISPUEvent;

public class CellMISPUEventInfoInfo
extends MIInfo {
    MISPUEvent[] events;

    public CellMISPUEventInfoInfo(MIOutput out) {
        super(out);
    }

    public MISPUEvent[] getEvents() {
        if (this.events == null) {
            this.parse();
        }
        return this.events;
    }

    protected void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                MIValue val;
                String var = results[i].getVariable();
                if (var.equals("SPUInfoEvent") && (val = results[i].getMIValue()) instanceof MITuple) {
                    this.parseEvent((MITuple)val);
                }
                ++i;
            }
        }
    }

    protected void parseEvent(MITuple tuple) {
        MIResult[] args = tuple.getMIResults();
        ArrayList<MISPUEvent> eventsList = new ArrayList<MISPUEvent>();
        if (args.length == 2) {
            eventsList.add(new MISPUEvent(args[0]));
            eventsList.add(new MISPUEvent(args[1]));
            this.events = eventsList.toArray(new MISPUEvent[0]);
        } else {
            eventsList.add(new MISPUEvent("event_mask", BEMessages.getString("SPUEnhancementsProcessor.0")));
            eventsList.add(new MISPUEvent("event_status", BEMessages.getString("SPUEnhancementsProcessor.1")));
            this.events = eventsList.toArray(new MISPUEvent[0]);
        }
    }
}

