/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse.core;

import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.core.exception.UnableToForwardPortException;
import org.eclipse.ptp.remote.rse.core.Activator;
import org.eclipse.ptp.remote.rse.core.messages.Messages;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;

public class RSEConnection
implements IRemoteConnection {
    private IHost rseHost;
    private IFileSystem fileSystem;
    private IShellService shellService = null;
    private ISubSystem subSystem = null;
    private IRemoteConnectionManager conMgr;
    private final IRemoteConnection connection = this;
    private ICommunicationsListener commsListener = new ICommunicationsListener(){

        public void communicationsStateChange(CommunicationsEvent event) {
            switch (event.getState()) {
                case 2: {
                    RSEConnection.this.conMgr.fireConnectionChangeEvent(new IRemoteConnectionChangeEvent(){

                        public IRemoteConnection getConnection() {
                            return RSEConnection.this.connection;
                        }

                        public int getType() {
                            return 2;
                        }
                    });
                    break;
                }
                case 4: {
                    RSEConnection.this.conMgr.fireConnectionChangeEvent(new IRemoteConnectionChangeEvent(){

                        public IRemoteConnection getConnection() {
                            return RSEConnection.this.connection;
                        }

                        public int getType() {
                            return 1;
                        }
                    });
                    break;
                }
                case 5: {
                    RSEConnection.this.conMgr.fireConnectionChangeEvent(new IRemoteConnectionChangeEvent(){

                        public IRemoteConnection getConnection() {
                            return RSEConnection.this.connection;
                        }

                        public int getType() {
                            return 4;
                        }
                    });
                }
            }
        }

        public boolean isPassiveCommunicationsListener() {
            return true;
        }
    };

    public RSEConnection(IHost host, IFileSystem fileSystem, IRemoteConnectionManager conMgr) {
        this.rseHost = host;
        this.fileSystem = fileSystem;
        this.conMgr = conMgr;
    }

    public void close(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.RSEConnection_close, 1);
        if (this.subSystem != null && this.subSystem.isConnected()) {
            try {
                this.subSystem.disconnect();
            }
            catch (Exception exception) {}
        }
        monitor.done();
    }

    public void forwardLocalPort(int localPort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.RSEConnection_noPortFwd);
    }

    public int forwardLocalPort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.RSEConnection_noPortFwd);
    }

    public void forwardRemotePort(int remotePort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.RSEConnection_noPortFwd);
    }

    public int forwardRemotePort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.RSEConnection_noPortFwd);
    }

    public String getAddress() {
        return this.rseHost.getHostName();
    }

    public IFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public IHost getHost() {
        return this.rseHost;
    }

    public String getName() {
        return this.rseHost.getAliasName();
    }

    public IShellService getRemoteShellService() {
        return this.shellService;
    }

    public String getUsername() {
        return this.rseHost.getDefaultUserId();
    }

    public boolean isOpen() {
        return this.subSystem != null && this.subSystem.isConnected();
    }

    public void open(IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            RSECorePlugin.waitForInitCompletion();
        }
        catch (InterruptedException e) {
            Activator.log(e);
            return;
        }
        if (!this.subSystem.isConnected()) {
            try {
                this.subSystem.connect(monitor, false);
            }
            catch (Exception exception) {}
            if (!this.subSystem.isConnected()) {
                throw new RemoteConnectionException(Messages.RSEConnection_noShellService);
            }
        }
    }

    public void setAddress(String address) {
        this.rseHost.setHostName(address);
    }

    public void setUsername(String username) {
        this.rseHost.setDefaultUserId(username);
    }

    public boolean supportsTCPPortForwarding() {
        return false;
    }

    protected void dispose() {
        this.subSystem.getConnectorService().removeCommunicationsListener(this.commsListener);
    }

    protected boolean initialize() {
        if (this.subSystem == null) {
            ISubSystem[] subSystems;
            ISubSystem[] iSubSystemArray = subSystems = this.rseHost.getSubSystems();
            int n = subSystems.length;
            int n2 = 0;
            while (n2 < n) {
                ISubSystem sub = iSubSystemArray[n2];
                if (sub instanceof IShellServiceSubSystem) {
                    this.subSystem = sub;
                    break;
                }
                ++n2;
            }
            if (this.subSystem == null) {
                return false;
            }
            this.subSystem.getConnectorService().addCommunicationsListener(this.commsListener);
            this.shellService = ((IShellServiceSubSystem)this.subSystem).getShellService();
        }
        return true;
    }
}

