/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse.core;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.rse.core.RSEConnection;

public class RSEFileManager
implements IRemoteFileManager {
    private RSEConnection connection;

    public RSEFileManager(RSEConnection conn) {
        this.connection = conn;
    }

    public IFileStore getResource(IPath path, IProgressMonitor monitor) throws IOException {
        return this.connection.getFileSystem().getStore(this.toURI(path));
    }

    public IPath getWorkingDirectory() {
        return new Path("/");
    }

    public IPath toPath(URI uri) {
        return new Path(uri.getPath());
    }

    public URI toURI(IPath path) {
        try {
            return new URI("rse", this.connection.getHost().getHostName(), path.toPortableString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

