/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.ptp.remote.core.AbstractRemoteProcess;
import org.eclipse.ptp.remote.core.NullInputStream;

public class RemoteToolsProcess
extends AbstractRemoteProcess {
    private Process remoteProcess;
    private InputStream procStdout;
    private InputStream procStderr;
    private Thread stdoutReader;
    private Thread stderrReader;

    public RemoteToolsProcess(Process proc, boolean merge) throws IOException {
        this.remoteProcess = proc;
        if (merge) {
            PipedOutputStream pipedOutput = new PipedOutputStream();
            this.procStdout = new PipedInputStream(pipedOutput);
            this.procStderr = new NullInputStream();
            this.stderrReader = new Thread(new ProcReader(proc.getErrorStream(), pipedOutput));
            this.stdoutReader = new Thread(new ProcReader(proc.getInputStream(), pipedOutput));
            this.stderrReader.start();
            this.stdoutReader.start();
        } else {
            this.procStdout = proc.getInputStream();
            this.procStderr = proc.getErrorStream();
        }
    }

    public void destroy() {
        this.remoteProcess.destroy();
    }

    public int exitValue() {
        return this.remoteProcess.exitValue();
    }

    public InputStream getErrorStream() {
        return this.procStderr;
    }

    public InputStream getInputStream() {
        return this.procStdout;
    }

    public OutputStream getOutputStream() {
        return this.remoteProcess.getOutputStream();
    }

    public int waitFor() throws InterruptedException {
        return this.remoteProcess.waitFor();
    }

    public boolean isCompleted() {
        try {
            this.remoteProcess.exitValue();
            return true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return false;
        }
    }

    private class ProcReader
    implements Runnable {
        private static final int BUF_SIZE = 8192;
        private InputStream input;
        private OutputStream output;

        public ProcReader(InputStream input, OutputStream output) {
            this.input = input;
            this.output = output;
        }

        public void run() {
            byte[] b = new byte[8192];
            try {
                int len;
                while ((len = this.input.read(b)) > 0) {
                    this.output.write(b, 0, len);
                }
            }
            catch (IOException iOException) {}
            try {
                this.input.close();
            }
            catch (IOException iOException) {}
            try {
                this.output.close();
            }
            catch (IOException iOException) {}
        }
    }
}

