/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.ptp.remotetools.core.IRemoteScriptExecution;
import org.eclipse.ptp.remotetools.core.RemoteProcess;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteExecutionException;

public class SSHRemoteProcess
extends RemoteProcess {
    IRemoteScriptExecution execution;
    private InputStream errorStream;
    private InputStream inputStream;
    private OutputStream outputStream;

    public SSHRemoteProcess(IRemoteScriptExecution execution) {
        this.execution = execution;
        try {
            this.errorStream = execution.getInputStreamFromProcessErrorStream();
            this.outputStream = execution.getOutputStreamToProcessInputStream();
            this.inputStream = execution.getInputStreamFromProcessOutputStream();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        new ExecutionCloser().start();
    }

    public void destroy() {
        if (!this.execution.wasFinished()) {
            this.execution.cancel();
        }
    }

    public int exitValue() {
        if (this.execution.wasCanceled()) {
            return -1;
        }
        if (this.execution.wasFinished()) {
            return this.execution.getReturnCode();
        }
        throw new IllegalThreadStateException();
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public int waitFor() throws InterruptedException {
        try {
            this.execution.waitForEndOfExecution();
        }
        catch (RemoteConnectionException remoteConnectionException) {
            return -1;
        }
        catch (CancelException cancelException) {
            return -1;
        }
        catch (RemoteExecutionException remoteExecutionException) {
            return -1;
        }
        return this.exitValue();
    }

    public IRemoteScriptExecution getRemoteExecution() {
        return this.execution;
    }

    class ExecutionCloser
    extends Thread {
        ExecutionCloser() {
        }

        public void run() {
            try {
                SSHRemoteProcess.this.execution.waitForEndOfExecution();
            }
            catch (RemoteConnectionException remoteConnectionException) {
            }
            catch (RemoteExecutionException remoteExecutionException) {
            }
            catch (CancelException cancelException) {}
            SSHRemoteProcess.this.execution.close();
        }
    }
}

