/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ui.wizards;

import org.eclipse.ptp.rm.ui.wizards.WizardPageDataSource;
import org.eclipse.ptp.rm.ui.wizards.WizardPageWidgetListener;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizard;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractConfigurationWizardPage
extends RMConfigurationWizardPage {
    private final WizardPageWidgetListener listener = this.createListener();
    private final WizardPageDataSource dataSource = this.createDataSource();

    public AbstractConfigurationWizardPage(RMConfigurationWizard wizard, String pageName) {
        super(wizard, pageName);
    }

    protected abstract WizardPageWidgetListener createListener();

    protected abstract WizardPageDataSource createDataSource();

    protected WizardPageWidgetListener getWidgetListener() {
        return this.listener;
    }

    protected WizardPageDataSource getDataSource() {
        return this.dataSource;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.resetErrorMessages();
            this.listener.disable();
            this.dataSource.setConfig(this.getConfigurationWizard().getConfiguration());
            this.dataSource.loadAndUpdate();
            this.listener.enable();
            this.updateControls();
        }
        super.setVisible(visible);
    }

    protected abstract void updateControls();

    protected Button createButton(Composite parent, String label, int type) {
        Button button = new Button(parent, type);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    protected Button createCheckButton(Composite parent, String label) {
        return this.createButton(parent, label, 16416);
    }

    protected void resetErrorMessages() {
        this.setPageComplete(true);
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    public void createControl(Composite parent) {
        this.listener.disable();
        Composite composite = this.doCreateContents(parent);
        this.setControl((Control)composite);
        this.listener.enable();
    }

    protected abstract Composite doCreateContents(Composite var1);
}

