/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.internal.ui;

import java.io.IOException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.debug.sdm.internal.ui.Messages;
import org.eclipse.ptp.debug.sdm.ui.SDMDebugUIPlugin;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.rm.remote.core.AbstractRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SDMPage
extends AbstractLaunchConfigurationTab {
    private static final String SDM_LOCATION = "last_valid_applied_location_of_sdm_executable";
    protected static final String EMPTY_STRING = "";
    private IResourceManagerControl resourceManager = null;
    private IRemoteServices remoteServices = null;
    private String errMsg = null;
    private boolean pathIsDirty = true;
    private boolean pathIsValid = false;
    protected Text fRMDebuggerPathText = null;
    protected Text fRMDebuggerAddressText = null;
    protected Button fRMDebuggerBrowseButton = null;

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        try {
            this.fRMDebuggerAddressText.setText(this.getAddress(workingCopy));
            this.fRMDebuggerPathText.setText(workingCopy.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", EMPTY_STRING));
        }
        catch (CoreException coreException) {}
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("SDMDebuggerPage.path"));
        GridData gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fRMDebuggerPathText = new Text(comp, 2052);
        this.fRMDebuggerPathText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fRMDebuggerPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SDMPage.this.pathIsDirty = true;
                SDMPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.fRMDebuggerBrowseButton = this.createPushButton(comp, Messages.getString("SDMDebuggerPage.browse"), null);
        this.fRMDebuggerBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String file = SDMPage.this.browseFile();
                if (file != null) {
                    SDMPage.this.fRMDebuggerPathText.setText(file);
                }
            }
        });
        label = new Label(comp, 0);
        label.setText(Messages.getString("SDMDebuggerPage.host"));
        gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fRMDebuggerAddressText = new Text(comp, 2052);
        this.fRMDebuggerAddressText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fRMDebuggerAddressText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SDMPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.setControl((Control)parent);
    }

    public String getName() {
        return Messages.getString("SDMDebuggerPage.debuggname");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String rmId = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", EMPTY_STRING);
            this.resourceManager = (IResourceManagerControl)PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(rmId);
            this.fRMDebuggerAddressText.setText(configuration.getAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", EMPTY_STRING));
            this.fRMDebuggerPathText.setText(configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", EMPTY_STRING));
        }
        catch (CoreException coreException) {}
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.getFieldContent(this.fRMDebuggerAddressText.getText()) == null) {
            this.setErrorMessage(Messages.getString("SDMDebuggerPage.err3"));
        } else if (this.getFieldContent(this.fRMDebuggerPathText.getText()) == null) {
            this.setErrorMessage(Messages.getString("SDMDebuggerPage.err1"));
        } else {
            if (this.pathIsDirty) {
                this.pathIsValid = this.verifyPath(this.fRMDebuggerPathText.getText());
                this.pathIsDirty = false;
            }
            if (!this.pathIsValid) {
                this.setErrorMessage(Messages.getString("SDMDebuggerPage.err4"));
            }
        }
        return this.getErrorMessage() == null;
    }

    public boolean canSave() {
        this.setErrorMessage(null);
        if (this.getFieldContent(this.fRMDebuggerAddressText.getText()) == null) {
            this.setErrorMessage(Messages.getString("SDMDebuggerPage.err3"));
        } else if (this.getFieldContent(this.fRMDebuggerPathText.getText()) == null) {
            this.setErrorMessage(Messages.getString("SDMDebuggerPage.err1"));
        } else {
            if (this.pathIsDirty) {
                this.pathIsValid = this.verifyPath(this.fRMDebuggerPathText.getText());
                this.pathIsDirty = false;
            }
            if (!this.pathIsValid) {
                this.setErrorMessage(Messages.getString("SDMDebuggerPage.err4"));
            }
        }
        return this.getErrorMessage() == null;
    }

    private boolean verifyPath(String path) {
        IRemoteConnection rmConn = this.getRemoteConnection();
        if (rmConn != null) {
            IRemoteFileManager fileManager = this.getRemoteServices().getFileManager(rmConn);
            try {
                IFileStore res = fileManager.getResource((IPath)new Path(path), (IProgressMonitor)new NullProgressMonitor());
                if (res.fetchInfo().exists()) {
                    return true;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return new Path(path).toFile().exists();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isValid((ILaunchConfiguration)configuration)) {
            configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", this.getFieldContent(this.fRMDebuggerPathText.getText()));
            configuration.setAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", this.getFieldContent(this.fRMDebuggerAddressText.getText()));
            SDMDebugUIPlugin plugin = SDMDebugUIPlugin.getDefault();
            Preferences prefs = plugin.getPluginPreferences();
            prefs.setValue(SDM_LOCATION, this.getFieldContent(this.fRMDebuggerPathText.getText()));
            plugin.savePluginPreferences();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        String path = EMPTY_STRING;
        try {
            String rmId = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", EMPTY_STRING);
            IResourceManagerControl rm = (IResourceManagerControl)PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(rmId);
            if (rm != null) {
                SDMDebugUIPlugin plugin;
                Preferences prefs;
                IResourceManagerConfiguration rmConfig = rm.getConfiguration();
                if (rmConfig instanceof AbstractRemoteResourceManagerConfiguration) {
                    AbstractRemoteResourceManagerConfiguration remConfig = (AbstractRemoteResourceManagerConfiguration)rmConfig;
                    Path rmPath = new Path(remConfig.getProxyServerPath());
                    path = rmPath.removeLastSegments(1).append("sdm").toString();
                }
                if ((path.equals("sdm") || path.equals(EMPTY_STRING)) && ((path = (prefs = (plugin = SDMDebugUIPlugin.getDefault()).getPluginPreferences()).getString(SDM_LOCATION)) == null || path.equals(EMPTY_STRING))) {
                    path = "sdm";
                }
            }
        }
        catch (CoreException coreException) {}
        configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", path);
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", this.getAddress(configuration));
    }

    private String browseFile() {
        IRemoteUIServices remoteUISrv = this.getRemoteUIServices();
        if (remoteUISrv != null) {
            IRemoteUIFileManager fileManager = remoteUISrv.getUIFileManager();
            if (fileManager != null) {
                fileManager.setConnection(this.getRemoteConnection());
                IPath path = fileManager.browseFile(this.getShell(), Messages.getString("SDMDebuggerPage.selectDebuggerExe"), this.fRMDebuggerPathText.getText());
                if (path != null) {
                    return path.toString();
                }
            }
        } else {
            FileDialog dialog = new FileDialog(this.getShell());
            dialog.setText(Messages.getString("SDMDebuggerPage.selectDebuggerExe"));
            dialog.setFileName(this.fRMDebuggerPathText.getText());
            return dialog.open();
        }
        return null;
    }

    private String getAddress(ILaunchConfigurationWorkingCopy configuration) {
        String rmId;
        String address;
        try {
            address = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", EMPTY_STRING);
            rmId = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", EMPTY_STRING);
        }
        catch (CoreException coreException) {
            return EMPTY_STRING;
        }
        IResourceManagerControl rm = (IResourceManagerControl)PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(rmId);
        if (rm != null && this.resourceManager != rm) {
            this.resourceManager = rm;
            AbstractRemoteResourceManagerConfiguration config = this.getRemoteResourceManagerConfigure();
            if (config != null) {
                if (config.testOption(2)) {
                    return this.getRemoteConnection().getAddress();
                }
                return config.getLocalAddress();
            }
            return "localhost";
        }
        return address;
    }

    private AbstractRemoteResourceManagerConfiguration getRemoteResourceManagerConfigure() {
        IResourceManagerConfiguration rmConfig;
        if (this.resourceManager != null && (rmConfig = this.resourceManager.getConfiguration()) instanceof AbstractRemoteResourceManagerConfiguration) {
            return (AbstractRemoteResourceManagerConfiguration)rmConfig;
        }
        return null;
    }

    private IRemoteServices getRemoteServices() {
        IResourceManagerConfiguration rmConfig;
        if (this.resourceManager == null) {
            return null;
        }
        if (this.remoteServices == null && (rmConfig = this.resourceManager.getConfiguration()) instanceof AbstractRemoteResourceManagerConfiguration) {
            AbstractRemoteResourceManagerConfiguration remConfig = (AbstractRemoteResourceManagerConfiguration)rmConfig;
            this.remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(remConfig.getRemoteServicesId());
        }
        return this.remoteServices;
    }

    private IRemoteUIServices getRemoteUIServices() {
        IRemoteServices rsrv = this.getRemoteServices();
        if (rsrv != null) {
            return PTPRemoteUIPlugin.getDefault().getRemoteUIServices(rsrv);
        }
        return null;
    }

    private IRemoteConnection getRemoteConnection() {
        AbstractRemoteResourceManagerConfiguration config;
        IRemoteServices rsrv = this.getRemoteServices();
        if (rsrv != null && (config = this.getRemoteResourceManagerConfigure()) != null) {
            return rsrv.getConnectionManager().getConnection(config.getConnectionName());
        }
        return null;
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }
}

