/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.internal.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.debug.sdm.core.SDMDebugCorePlugin;
import org.eclipse.ptp.debug.sdm.core.SDMPreferenceConstants;
import org.eclipse.ptp.debug.sdm.internal.ui.preferences.PreferenceMessages;
import org.eclipse.ptp.debug.ui.PreferencesAdapter;
import org.eclipse.ptp.ui.preferences.AbstractPreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SDMPreferencePage
extends AbstractPreferencePage {
    private Text sdmBackendPathText = null;
    private Text sdmArgsText = null;
    private Combo sdmBackendCombo = null;
    protected WidgetListener listener = new WidgetListener();

    public SDMPreferencePage() {
        this.setPreferenceStore((IPreferenceStore)new PreferencesAdapter(SDMDebugCorePlugin.getDefault().getPluginPreferences()));
        this.setDescription(PreferenceMessages.getString("SDMPreferencePage.sdm_desc"));
    }

    public boolean isValid() {
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.sdmArgsText.setText(store.getDefaultString(SDMPreferenceConstants.SDM_DEBUGGER_ARGS));
        this.sdmBackendCombo.select(this.sdmBackendCombo.indexOf(store.getDefaultString(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_TYPE)));
        this.sdmBackendPathText.setText(store.getDefaultString(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_PATH));
        super.performDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        SDMDebugCorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.setValid(this.isValid());
    }

    private void handleSDMComboSelected() {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createSpacer(composite, 1);
        this.createSDMSetting(composite);
        this.setValues();
        return composite;
    }

    protected void createSDMSetting(Composite parent) {
        Composite group = this.createGroupComposite(parent, 1, false, PreferenceMessages.getString("SDMPreferencePage.sdm_group"));
        Composite comp = this.createComposite(group, 2);
        GridData gd = new GridData(768);
        new Label(comp, 0).setText(PreferenceMessages.getString("SDMPreferencePage.sdm_backend"));
        this.sdmBackendCombo = new Combo(comp, 8);
        this.sdmBackendCombo.setLayoutData((Object)gd);
        this.sdmBackendCombo.setItems(SDMPreferenceConstants.SDM_DEBUGGER_BACKENDS);
        this.sdmBackendCombo.addSelectionListener((SelectionListener)this.listener);
        new Label(comp, 0).setText(PreferenceMessages.getString("SDMPreferencePage.sdm_backend_path"));
        this.sdmBackendPathText = new Text(comp, 2052);
        this.sdmBackendPathText.setLayoutData((Object)gd);
        this.sdmBackendPathText.addModifyListener((ModifyListener)this.listener);
        new Label(comp, 0).setText(PreferenceMessages.getString("SDMPreferencePage.sdm_args"));
        this.sdmArgsText = new Text(comp, 2052);
        this.sdmArgsText.setLayoutData((Object)gd);
        this.sdmArgsText.addModifyListener((ModifyListener)this.listener);
    }

    protected void setValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.sdmArgsText.setText(store.getString(SDMPreferenceConstants.SDM_DEBUGGER_ARGS));
        this.sdmBackendCombo.select(this.sdmBackendCombo.indexOf(store.getString(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_TYPE)));
        this.sdmBackendPathText.setText(store.getString(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_PATH));
    }

    protected void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(SDMPreferenceConstants.SDM_DEBUGGER_ARGS, this.sdmArgsText.getText());
        store.setValue(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_TYPE, this.sdmBackendCombo.getItem(this.sdmBackendCombo.getSelectionIndex()));
        store.setValue(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_PATH, this.sdmBackendPathText.getText());
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            SDMPreferencePage.this.setValid(SDMPreferencePage.this.isValid());
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == SDMPreferencePage.this.sdmBackendCombo) {
                SDMPreferencePage.this.handleSDMComboSelected();
            }
        }
    }
}

