/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.sputiming.core;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.ptp.cell.sputiming.core.CommonOperations;
import org.eclipse.ptp.cell.sputiming.core.ExternalTools;
import org.eclipse.ptp.cell.sputiming.core.Messages;
import org.eclipse.ptp.cell.sputiming.debug.Debug;
import org.eclipse.ptp.cell.sputiming.execution.CompilerParameters;
import org.eclipse.ptp.cell.sputiming.execution.SPUTimingExecution;
import org.eclipse.ptp.cell.sputiming.execution.SPUTimingParameters;
import org.eclipse.ui.console.IOConsole;

public class LaunchConfigurationDelegate
implements ILaunchConfigurationDelegate,
ILaunchConfigurationDelegate2 {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.LaunchConfigurationDelegate_Task_Name, 4);
        Debug.read();
        Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Start sputiming launcher delegate.");
        Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Launch configuration map: {0}", new Object[]{configuration.getAttributes().toString()});
        try {
            String projectName = configuration.getAttribute("profilerproject", "");
            Path projectDirPath = new Path(configuration.getAttribute("defaultworkingdir", ""));
            Path srcFilePath = new Path(configuration.getAttribute("srcfilename", ""));
            if (!srcFilePath.isAbsolute()) {
                srcFilePath = projectDirPath.append((IPath)srcFilePath);
            }
            String compbin = configuration.getAttribute("compilername", "");
            String compflags = configuration.getAttribute("compilerflags", "");
            String spubin = configuration.getAttribute("spuexecname", "");
            ICProject cproj = CoreModel.getDefault().getCModel().getCProject(projectName);
            CommonOperations commonOperations = new CommonOperations(cproj.getProject(), (IPath)srcFilePath);
            IOConsole console = commonOperations.createConsole(Messages.LaunchConfigurationDelegate_Console_Name);
            IPath workDirPath = commonOperations.getWorkingDirectory();
            commonOperations.createWorkingDirectory(monitor);
            Path asmPath = new Path(configuration.getAttribute("asmfilename", ""));
            if (!asmPath.isAbsolute()) {
                asmPath = workDirPath.append((IPath)asmPath);
            }
            String architecture = configuration.getAttribute("march", "cell");
            String spu_parameter = null;
            if (architecture.equals("cell")) {
                spu_parameter = "-march=cell";
            } else if (architecture.equals("efp")) {
                spu_parameter = "-march=celledp";
            }
            CompilerParameters cp = new CompilerParameters(compbin, compflags, null, srcFilePath.toOSString(), workDirPath.toFile(), console);
            SPUTimingParameters spup = new SPUTimingParameters(spubin, spu_parameter, asmPath.toOSString(), workDirPath.toFile(), console);
            Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Given compiler parameters: {0}", new Object[]{cp.toString()});
            Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Given sputiming parameters: {0}", new Object[]{spup.toString()});
            monitor.worked(1);
            SPUTimingExecution spuexec = SPUTimingExecution.createExecution(cp, spup);
            Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Request to compiler");
            spuexec.startCompiler();
            monitor.worked(1);
            Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Request to sputiming");
            spuexec.startSPUTimingTool();
            monitor.worked(1);
            IPath sputGenFilePath = workDirPath.append(asmPath.addFileExtension("timing").lastSegment());
            Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Read output file: ''{0}''", new Object[]{sputGenFilePath.toString()});
            commonOperations.displayOutputFile(sputGenFilePath, console);
            monitor.worked(1);
            Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Request to extension points");
            ExternalTools.callExtensions(sputGenFilePath);
        }
        finally {
            Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Finished sputiming launcher delegate.");
        }
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return true;
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return null;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return true;
    }
}

