/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.simulator.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.ptp.cell.simulator.tools.ContentRetrieverTool;

public class LaunchProfile {
    String id;
    String name;
    String tclScriptPath;
    URL tclScriptURL;
    String[] deployPaths;
    URL[] deployURLs;

    public LaunchProfile(String id, String name, String tclScriptPath, URL tclScriptURL, String[] deployPaths, URL[] deployURLs) {
        this.id = id;
        this.name = name;
        this.tclScriptPath = tclScriptPath;
        this.tclScriptURL = tclScriptURL;
        this.deployPaths = deployPaths;
        this.deployURLs = deployURLs;
    }

    public String toString() {
        return String.valueOf(this.id) + "; " + this.name + "; " + this.tclScriptPath + "; " + this.tclScriptURL + "; " + Integer.toString(this.deployPaths.length);
    }

    public String[] getDeployPaths() {
        return this.deployPaths;
    }

    public void setDeployPaths(String[] deployPaths) {
        this.deployPaths = deployPaths;
    }

    public URL[] getDeployURLs() {
        return this.deployURLs;
    }

    public void setDeployURLs(URL[] deployURLs) {
        this.deployURLs = deployURLs;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTclScriptPath() {
        return this.tclScriptPath;
    }

    public void setTclScriptPath(String tclScriptPath) {
        this.tclScriptPath = tclScriptPath;
    }

    public URL getTclScriptURL() {
        return this.tclScriptURL;
    }

    public void setTclScriptURL(URL tclScriptURL) {
        this.tclScriptURL = tclScriptURL;
    }

    public String getTclScriptContent() throws IOException {
        InputStreamReader inputReader = new InputStreamReader(this.getTclScriptInputStream());
        return ContentRetrieverTool.readStreamContent(inputReader);
    }

    public InputStream getTclScriptInputStream() throws IOException {
        URLConnection connection = this.tclScriptURL.openConnection();
        return connection.getInputStream();
    }

    public void writeTclScriptTo(OutputStream outputStream) throws IOException {
        InputStream inputStream = this.getTclScriptInputStream();
        ContentRetrieverTool.copyStreamContent(outputStream, inputStream);
    }

    public String getDeployContent(int index) throws IOException {
        InputStreamReader inputReader = new InputStreamReader(this.getDeployInputStream(index));
        return ContentRetrieverTool.readStreamContent(inputReader);
    }

    public InputStream getDeployInputStream(int index) throws IOException {
        URLConnection connection = this.deployURLs[index].openConnection();
        return connection.getInputStream();
    }

    public void writeDeployContentTo(OutputStream outputStream, int index) throws IOException {
        InputStream inputStream = this.getDeployInputStream(index);
        ContentRetrieverTool.copyStreamContent(outputStream, inputStream);
    }
}

