/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.simulator.internal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ptp.cell.simulator.internal.ITSimRequest;
import org.eclipse.ptp.cell.simulator.internal.TSimQueue;
import org.eclipse.ptp.cell.simulator.internal.TSimSocket;

public class TSimDispatcher
extends Thread {
    TSimQueue queue = null;
    TSimSocket socket = null;

    public TSimDispatcher(TSimSocket socket, TSimQueue queue) {
        super("Simulator TCL dispatcher");
        this.socket = socket;
        this.queue = queue;
    }

    public TSimDispatcher(TSimSocket socket) {
        this.socket = socket;
        this.queue = new TSimQueue();
    }

    public void run() {
        Assert.isNotNull((Object)this.queue);
        Assert.isNotNull((Object)this.socket);
        while (!this.isInterrupted()) {
            try {
                ITSimRequest request = this.queue.popRequest();
                String query = request.getQuery();
                String[] response = this.socket.query(query);
                request.parseResponse(response);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                return;
            }
            catch (EOFException eOFException) {
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public TSimQueue getQueue() {
        return this.queue;
    }

    public TSimSocket getSocket() {
        return this.socket;
    }
}

