/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.propertypages;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.ptp.debug.core.PDebugModel;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.model.IPSignal;
import org.eclipse.ptp.debug.internal.ui.dialogfields.SelectionButtonDialogField;
import org.eclipse.ptp.debug.internal.ui.propertypages.PropertyPageMessages;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class SignalPropertyPage
extends PropertyPage {
    private SelectionButtonDialogField fPassButton;
    private SelectionButtonDialogField fStopButton;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        Font font = parent.getFont();
        composite.setFont(font);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        try {
            String description = this.getSignal().getDescription();
            Label label = new Label(composite, 64);
            label.setText(MessageFormat.format(PropertyPageMessages.getString("SignalPropertyPage.0"), description));
            GridData data = new GridData(772);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(font);
        }
        catch (DebugException debugException) {}
        try {
            boolean pass = this.getSignal().isPassEnabled();
            this.fPassButton = new SelectionButtonDialogField(32);
            this.fPassButton.setLabelText(PropertyPageMessages.getString("SignalPropertyPage.1"));
            this.fPassButton.setSelection(pass);
            this.fPassButton.setEnabled(this.getSignal().canModify());
            this.fPassButton.doFillIntoGrid(composite, 1);
        }
        catch (DebugException debugException) {}
        try {
            boolean stop = this.getSignal().isStopEnabled();
            this.fStopButton = new SelectionButtonDialogField(32);
            this.fStopButton.setLabelText(PropertyPageMessages.getString("SignalPropertyPage.2"));
            this.fStopButton.setSelection(stop);
            this.fStopButton.setEnabled(this.getSignal().canModify());
            this.fStopButton.doFillIntoGrid(composite, 1);
        }
        catch (DebugException debugException) {}
        this.setValid(true);
        return composite;
    }

    protected SelectionButtonDialogField getPassButton() {
        return this.fPassButton;
    }

    protected SelectionButtonDialogField getStopButton() {
        return this.fStopButton;
    }

    public IPSignal getSignal() {
        return (IPSignal)this.getElement();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result) {
            DebugPlugin.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (!SignalPropertyPage.this.getSignal().canModify()) {
                        return;
                    }
                    if (SignalPropertyPage.this.getPassButton() != null) {
                        try {
                            SignalPropertyPage.this.getSignal().setPassEnabled(SignalPropertyPage.this.getPassButton().isSelected());
                        }
                        catch (DebugException e) {
                            SignalPropertyPage.this.failed(PropertyPageMessages.getString("SignalPropertyPage.5"), e);
                        }
                    }
                    if (SignalPropertyPage.this.getStopButton() != null) {
                        try {
                            SignalPropertyPage.this.getSignal().setStopEnabled(SignalPropertyPage.this.getStopButton().isSelected());
                        }
                        catch (DebugException e) {
                            SignalPropertyPage.this.failed(PropertyPageMessages.getString("SignalPropertyPage.5"), e);
                        }
                    }
                }
            });
        }
        return result;
    }

    protected void failed(String message, Throwable e) {
        MultiStatus ms = new MultiStatus(PDebugModel.getPluginIdentifier(), 10002, message, null);
        ms.add((IStatus)new Status(4, PDebugModel.getPluginIdentifier(), 10002, e.getMessage(), null));
        PDebugUtils.error((IStatus)ms, (Object)this.getSignal());
    }
}

