/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.core;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.core.ITargetEnvironmentEventListener;
import org.eclipse.ptp.remotetools.environment.core.ITargetEventListener;
import org.eclipse.ptp.remotetools.environment.core.TargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetEnvironmentEventManager;
import org.eclipse.ptp.remotetools.environment.core.TargetTypeElement;
import org.eclipse.ptp.remotetools.environment.extension.ITargetTypeExtension;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class TargetEnvironmentManager {
    private static String ENVIRONMENTS = "Environments";
    private static String ENVIRONMENTS_TYPE = "Type";
    private static String ENVIRONMENTS_TYPE_NAME = "Name";
    private static String ENVIRONMENTS_TYPE_CONFIG = "Configuration";
    private static String ENVIRONMENTS_TYPE_CONFIG_NAME = "CfgName";
    private List targetTypeElements;
    private List eventListeners = new ArrayList();
    private List modelChangedListeners = new ArrayList();
    private TargetEnvironmentEventManager manager;
    private Map storedCypherEnvToKeyMap;

    public TargetEnvironmentManager() {
        Map targets = EnvironmentPlugin.getDefault().getControls();
        this.targetTypeElements = new ArrayList();
        this.manager = new TargetEnvironmentEventManager(this);
        URL pluginURL = EnvironmentPlugin.getDefault().getBundle().getEntry("/");
        Map cypherEnvTypeMap = Platform.getAuthorizationInfo((URL)pluginURL, (String)"", (String)"");
        this.storedCypherEnvToKeyMap = new HashMap();
        File file = EnvironmentPlugin.getDefault().getStateLocation().append("environments.xml").toFile();
        try {
            XMLMemento memento;
            if (!file.exists()) {
                file.createNewFile();
            }
            FileReader reader = new FileReader(file);
            try {
                memento = XMLMemento.createReadRoot((Reader)reader);
                targets = this.initContentFromFile(memento, targets, cypherEnvTypeMap);
            }
            catch (WorkbenchException workbenchException) {
                memento = XMLMemento.createWriteRoot((String)ENVIRONMENTS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Iterator keys = targets.keySet().iterator();
        HashSet<String> cipherKeySet = new HashSet<String>();
        while (keys.hasNext()) {
            String name = (String)keys.next();
            ITargetTypeExtension env = (ITargetTypeExtension)targets.get(name);
            this.targetTypeElements.add(new TargetTypeElement(name, env, this));
            String[] controlKeysCypher = env.getControlAttributeNamesForCipheredKeys();
            if (controlKeysCypher != null) {
                List<String> keyList = Arrays.asList(controlKeysCypher);
                cipherKeySet.addAll(keyList);
            }
            this.storedCypherEnvToKeyMap.put(name, cipherKeySet);
        }
    }

    public Map initContentFromFile(XMLMemento memento, Map targets, Map cypherEnvTypeMap) {
        IMemento[] children = memento.getChildren(ENVIRONMENTS_TYPE);
        int i = 0;
        while (i < children.length) {
            String name = children[i].getString(ENVIRONMENTS_TYPE_NAME);
            ITargetTypeExtension env = (ITargetTypeExtension)targets.get(name);
            Map cypherConfigNameMap = null;
            if (cypherEnvTypeMap != null) {
                cypherConfigNameMap = (Map)cypherEnvTypeMap.get(name);
            }
            if (env != null) {
                HashSet<String> cipherKeySet = new HashSet<String>();
                String[] controlKeysCypher = env.getControlAttributeNamesForCipheredKeys();
                if (controlKeysCypher != null) {
                    List<String> keyList = Arrays.asList(controlKeysCypher);
                    cipherKeySet.addAll(keyList);
                }
                this.storedCypherEnvToKeyMap.put(name, cipherKeySet);
                TargetTypeElement typeElement = new TargetTypeElement(name, env, this);
                IMemento[] childrenElements = children[i].getChildren(ENVIRONMENTS_TYPE_CONFIG);
                int j = 0;
                while (j < childrenElements.length) {
                    String nameElement = childrenElements[j].getString(ENVIRONMENTS_TYPE_CONFIG_NAME);
                    HashMap<String, String> attrsElement = new HashMap<String, String>();
                    String[] controlKeys = env.getControlAttributeNames();
                    int k = 0;
                    while (k < controlKeys.length) {
                        attrsElement.put(controlKeys[k], childrenElements[j].getString(controlKeys[k]));
                        ++k;
                    }
                    Map cypherPasswdKeyMap = null;
                    if (cypherConfigNameMap != null) {
                        cypherPasswdKeyMap = (Map)cypherConfigNameMap.get(nameElement);
                    }
                    if (controlKeysCypher != null) {
                        int k2 = 0;
                        while (k2 < controlKeysCypher.length) {
                            if (cypherPasswdKeyMap == null) {
                                attrsElement.put(controlKeysCypher[k2], "");
                            } else {
                                attrsElement.put(controlKeysCypher[k2], (String)cypherPasswdKeyMap.get(controlKeysCypher[k2]));
                            }
                            cipherKeySet.add(controlKeysCypher[k2]);
                            ++k2;
                        }
                    }
                    String id = childrenElements[j].getString("core-environmentid") == null ? EnvironmentPlugin.getDefault().getEnvironmentUniqueID() : childrenElements[j].getString("core-environmentid");
                    typeElement.addElement(new TargetElement(typeElement, nameElement, attrsElement, id));
                    ++j;
                }
                this.targetTypeElements.add(typeElement);
                targets.remove(name);
            }
            ++i;
        }
        return targets;
    }

    public void writeToFile() {
        HashMap cypherEnvTypeMap = new HashMap();
        File file = EnvironmentPlugin.getDefault().getStateLocation().append("environments.xml").toFile();
        Iterator iterator = this.targetTypeElements.iterator();
        XMLMemento memento = XMLMemento.createWriteRoot((String)ENVIRONMENTS);
        while (iterator.hasNext()) {
            TargetTypeElement type = (TargetTypeElement)iterator.next();
            IMemento typeMemento = memento.createChild(ENVIRONMENTS_TYPE);
            typeMemento.putString(ENVIRONMENTS_TYPE_NAME, type.getName());
            HashMap cypherConfigNameMap = new HashMap();
            Set cypherKeySet = (Set)this.storedCypherEnvToKeyMap.get(type.getName());
            for (ITargetElement element : type.getElements()) {
                IMemento elementMemento = typeMemento.createChild(ENVIRONMENTS_TYPE_CONFIG);
                elementMemento.putString(ENVIRONMENTS_TYPE_CONFIG_NAME, element.getName());
                Map elementAttr = element.getAttributes();
                HashMap<String, String> cypherPasswdKeyMap = new HashMap<String, String>();
                for (String key : elementAttr.keySet()) {
                    if (cypherKeySet.contains(key)) {
                        cypherPasswdKeyMap.put(key, (String)elementAttr.get(key));
                        continue;
                    }
                    elementMemento.putString(key, (String)elementAttr.get(key));
                }
                elementMemento.putString("core-environmentid", element.getId());
                cypherConfigNameMap.put(element.getName(), cypherPasswdKeyMap);
            }
            cypherEnvTypeMap.put(type.getName(), cypherConfigNameMap);
        }
        URL pluginURL = EnvironmentPlugin.getDefault().getBundle().getEntry("/");
        try {
            Platform.addAuthorizationInfo((URL)pluginURL, (String)"", (String)"", cypherEnvTypeMap);
        }
        catch (CoreException e1) {
            throw new RuntimeException(e1);
        }
        try {
            FileWriter writer = new FileWriter(file);
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List getTypeElements() {
        return this.targetTypeElements;
    }

    public synchronized ITargetElement[] getConfigElements() {
        ArrayList rsp = new ArrayList();
        Iterator i = this.targetTypeElements.iterator();
        while (i.hasNext()) {
            rsp.addAll(((TargetTypeElement)i.next()).getElements());
        }
        ITargetElement[] rspObj = null;
        if (rsp.size() > 0) {
            rspObj = rsp.toArray(new ITargetElement[0]);
        }
        return rspObj;
    }

    public synchronized void addModelEventListener(ITargetEventListener listener) {
        if (listener != null && !this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removeModelEventListener(ITargetEventListener listener) {
        if (listener != null && this.eventListeners.contains(listener)) {
            this.eventListeners.remove(listener);
        }
    }

    public synchronized void addModelChangedListener(ITargetEnvironmentEventListener listener) {
        if (listener != null && !this.modelChangedListeners.contains(listener)) {
            this.modelChangedListeners.add(listener);
        }
    }

    public synchronized void removeModelChangedListener(ITargetEnvironmentEventListener listener) {
        if (listener != null && this.modelChangedListeners.contains(listener)) {
            this.modelChangedListeners.remove(listener);
        }
    }

    public void fireModelChanged(int action, ITargetElement oldElement, TargetElement newElement) {
        block3: {
            Iterator i;
            block2: {
                i = this.modelChangedListeners.iterator();
                if (oldElement != null || newElement == null) break block2;
                while (i.hasNext()) {
                    ITargetEnvironmentEventListener listener = (ITargetEnvironmentEventListener)i.next();
                    listener.elementAdded(newElement);
                }
                break block3;
            }
            if (oldElement == null || newElement != null) break block3;
            while (i.hasNext()) {
                ITargetEnvironmentEventListener listener = (ITargetEnvironmentEventListener)i.next();
                listener.elementRemoved(oldElement);
            }
        }
    }

    public synchronized void fireElementEvent(int event, TargetElement element) {
        int status = 1;
        switch (event) {
            case 0: {
                status = 0;
                break;
            }
            case 1: {
                status = 1;
                break;
            }
            case 2: {
                status = 2;
                break;
            }
            case 3: {
                status = 3;
            }
        }
        element.setStatus(status);
        for (ITargetEventListener listener : this.eventListeners) {
            listener.handleStateChangeEvent(status, element);
        }
    }

    public ITargetControl selectControl(String id) {
        ITargetElement[] elements = this.getConfigElements();
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                ITargetElement element = elements[i];
                if (element.getName().equals(id)) {
                    try {
                        return element.getControl();
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
        return null;
    }

    public String[] getAllConfigNames() {
        ITargetElement[] elements = this.getConfigElements();
        ArrayList<String> names = new ArrayList<String>();
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                ITargetElement element = elements[i];
                names.add(element.getName());
                ++i;
            }
        }
        return names.toArray(new String[0]);
    }
}

