/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.IByteConverter;
import org.eclipse.dstore.core.model.IByteStreamHandler;

public class ByteStreamHandler
implements IByteStreamHandler {
    protected DataStore _dataStore;
    protected DataElement _log;
    protected static final String FILEMSG_REMOTE_SAVE_FAILED = "RSEF5006";

    public ByteStreamHandler(DataStore dataStore, DataElement log) {
        this._dataStore = dataStore;
        this._log = log;
    }

    public String getId() {
        return this.getClass().getName();
    }

    public void receiveBytes(String remotePath, byte[] buffer, int size, boolean binary) {
        remotePath = new String(remotePath.replace('\\', '/'));
        DataElement status = this.findStatusFor(remotePath);
        String fileName = this._dataStore.mapToLocalPath(remotePath);
        if (fileName != null) {
            try {
                File file = new File(fileName);
                if (!file.exists()) {
                    File parent = new File(file.getParent());
                    parent.mkdirs();
                }
                File newFile = new File(fileName);
                FileOutputStream fileStream = new FileOutputStream(newFile);
                if (binary) {
                    fileStream.write(buffer, 0, size);
                } else {
                    IByteConverter byteConverter = this._dataStore.getByteConverter();
                    byteConverter.setContext(file);
                    byte[] convertedBytes = byteConverter.convertClientBytesToHostBytes(buffer, 0, size);
                    fileStream.write(convertedBytes, 0, convertedBytes.length);
                }
                fileStream.close();
                if (status == null) {
                    return;
                }
                status.setAttribute(4, "success");
                this._dataStore.refresh(status.getParent());
            }
            catch (IOException e) {
                System.out.println(e);
                if (status == null) {
                    return;
                }
                status.setAttribute(3, FILEMSG_REMOTE_SAVE_FAILED);
                status.setAttribute(4, "failed");
                this._dataStore.refresh(status.getParent());
            }
            catch (Exception e) {
                System.out.println(e);
                if (status == null) {
                    return;
                }
                status.setAttribute(3, FILEMSG_REMOTE_SAVE_FAILED);
                status.setAttribute(4, "failed");
                this._dataStore.refresh(status.getParent());
            }
        }
    }

    public void receiveAppendedBytes(String remotePath, byte[] buffer, int size, boolean binary) {
        remotePath = new String(remotePath.replace('\\', '/'));
        DataElement status = this.findStatusFor(remotePath);
        String fileName = this._dataStore.mapToLocalPath(remotePath);
        if (fileName != null) {
            try {
                File file = new File(fileName);
                if (!file.exists()) {
                    File parent = new File(file.getParent());
                    parent.mkdirs();
                    File newFile = new File(fileName);
                    FileOutputStream fileStream = new FileOutputStream(newFile);
                    if (binary) {
                        fileStream.write(buffer, 0, size);
                    } else {
                        IByteConverter byteConverter = this._dataStore.getByteConverter();
                        byteConverter.setContext(file);
                        byte[] convertedBytes = byteConverter.convertClientBytesToHostBytes(buffer, 0, size);
                        fileStream.write(convertedBytes, 0, convertedBytes.length);
                    }
                    fileStream.close();
                } else {
                    FileOutputStream outStream = new FileOutputStream(fileName, true);
                    if (binary) {
                        outStream.write(buffer, 0, size);
                    } else {
                        IByteConverter byteConverter = this._dataStore.getByteConverter();
                        byteConverter.setContext(file);
                        byte[] convertedBytes = byteConverter.convertClientBytesToHostBytes(buffer, 0, size);
                        outStream.write(convertedBytes, 0, convertedBytes.length);
                    }
                    outStream.close();
                }
                if (status == null) {
                    return;
                }
                status.setAttribute(4, "success");
                this._dataStore.refresh(status.getParent());
            }
            catch (IOException e) {
                System.out.println(e);
                if (status == null) {
                    return;
                }
                status.setAttribute(3, FILEMSG_REMOTE_SAVE_FAILED);
                status.setAttribute(4, "failed");
                this._dataStore.refresh(status.getParent());
            }
        }
    }

    protected void internalSendBytes(String path, byte[] bytes, int size, boolean binary) {
        if (this._dataStore.isVirtual()) {
            this._dataStore.replaceFile(path, bytes, size, binary);
        } else {
            this._dataStore.updateFile(path, bytes, size, binary);
        }
    }

    protected void internalSendAppendBytes(String path, byte[] bytes, int size, boolean binary) {
        if (this._dataStore.isVirtual()) {
            this._dataStore.replaceAppendFile(path, bytes, size, binary);
        } else {
            this._dataStore.updateAppendFile(path, bytes, size, binary);
        }
    }

    protected DataElement findStatusFor(String remotePath) {
        if (this._log != null) {
            int i = 0;
            while (i < this._log.getNestedSize()) {
                DataElement child = this._log.get(i);
                if (child.getName().equals(remotePath)) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }
}

