/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.processes.handlers;

import org.eclipse.rse.services.clientserver.processes.handlers.ProcessHandler;
import org.eclipse.rse.services.clientserver.processes.handlers.UniversalAIXProcessHandler;
import org.eclipse.rse.services.clientserver.processes.handlers.UniversalLinuxProcessHandler;
import org.eclipse.rse.services.clientserver.processes.handlers.UniversalMacOSXProcessHandler;
import org.eclipse.rse.services.clientserver.processes.handlers.UniversalZOSProcessHandler;

public class ProcessHandlerManager {
    protected static ProcessHandlerManager _instance = new ProcessHandlerManager();

    public static ProcessHandlerManager getInstance() {
        return _instance;
    }

    public ProcessHandler getNewProcessHandler() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("linux")) {
            return new UniversalLinuxProcessHandler();
        }
        if (osName.startsWith("aix")) {
            return new UniversalAIXProcessHandler();
        }
        if (osName.startsWith("z/os")) {
            return new UniversalZOSProcessHandler();
        }
        if (osName.startsWith("mac os x")) {
            return new UniversalMacOSXProcessHandler();
        }
        return null;
    }
}

