/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;

class Cost {
    public static final int NO_USERDEFINED_CONVERSION = 0;
    public static final int AMBIGUOUS_USERDEFINED_CONVERSION = 1;
    public static final int USERDEFINED_CONVERSION = 2;
    public static final int NO_MATCH_RANK = -1;
    public static final int IDENTITY_RANK = 0;
    public static final int LVALUE_OR_QUALIFICATION_RANK = 0;
    public static final int PROMOTION_RANK = 1;
    public static final int CONVERSION_RANK = 2;
    public static final int DERIVED_TO_BASE_CONVERSION = 3;
    public static final int USERDEFINED_CONVERSION_RANK = 4;
    public static final int ELLIPSIS_CONVERSION = 5;
    public static final int FUZZY_TEMPLATE_PARAMETERS = 6;
    public IType source;
    public IType target;
    public boolean targetHadReference = false;
    public int lvalue;
    public int promotion;
    public int conversion;
    public int qualification;
    public int userDefined = 0;
    public int rank = -1;
    public int detail;

    public Cost(IType s, IType t) {
        this.source = s;
        this.target = t;
    }

    public int compare(Cost cost) throws DOMException {
        int result = 0;
        if (this.rank != cost.rank) {
            return cost.rank - this.rank;
        }
        if (this.userDefined == cost.userDefined) {
            if (this.userDefined == 1) {
                return 0;
            }
        } else {
            if (this.userDefined == 0 || cost.userDefined == 0) {
                return cost.userDefined - this.userDefined;
            }
            return 0;
        }
        if (this.promotion > 0 || cost.promotion > 0) {
            result = cost.promotion - this.promotion;
        }
        if (this.conversion > 0 || cost.conversion > 0) {
            result = this.detail == cost.detail ? cost.conversion - this.conversion : cost.detail - this.detail;
        }
        if (result == 0) {
            IPointerType op2;
            IPointerType op1;
            if (cost.qualification != this.qualification) {
                return cost.qualification - this.qualification;
            }
            if (this.qualification == 0) {
                return 0;
            }
            IType t1 = cost.target;
            IType t2 = this.target;
            int subOrSuper = 0;
            while (true) {
                op1 = null;
                op2 = null;
                while (t1 instanceof ITypedef) {
                    try {
                        t1 = ((ITypedef)t1).getType();
                    }
                    catch (DOMException e) {
                        t1 = e.getProblem();
                    }
                }
                if (t1 instanceof IPointerType) {
                    op1 = (IPointerType)t1;
                }
                while (t2 instanceof ITypedef) {
                    try {
                        t2 = ((ITypedef)t2).getType();
                    }
                    catch (DOMException e) {
                        t2 = e.getProblem();
                    }
                }
                if (t2 instanceof IPointerType) {
                    op2 = (IPointerType)t2;
                }
                if (op1 == null || op2 == null) break;
                int cmp = (op1.isConst() ? 1 : 0) + (op1.isVolatile() ? 1 : 0) - (op2.isConst() ? 1 : 0) + (op2.isVolatile() ? 1 : 0);
                if (cmp != 0) {
                    if (subOrSuper == 0) {
                        subOrSuper = cmp;
                    } else if (subOrSuper > 0 != cmp > 0) {
                        return 0;
                    }
                }
                t1 = op1.getType();
                t2 = op2.getType();
            }
            if (op1 != null) {
                return 1;
            }
            if (op2 != null) {
                return -1;
            }
            return 0;
        }
        return result;
    }
}

