/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.core.runtime.CoreException;

public class PDOMLanguage {
    private PDOM pdom;
    private int record;
    private static final int NEXT = 0;
    private static final int ID = 4;
    private static final int NAME = 6;
    private static int RECORD_SIZE = 10;

    public PDOMLanguage(PDOM pdom, int record) {
        this.pdom = pdom;
        this.record = record;
    }

    public PDOMLanguage(PDOM pdom, String name, int id, int next) throws CoreException {
        this.pdom = pdom;
        Database db = pdom.getDB();
        this.record = db.malloc(RECORD_SIZE);
        db.putInt(this.record + 0, next);
        db.putChar(this.record + 4, (char)id);
        db.putInt(this.record + 6, db.newString(name).getRecord());
    }

    public int getRecord() {
        return this.record;
    }

    public int getId() throws CoreException {
        return this.pdom.getDB().getChar(this.record + 4);
    }

    public IString getName() throws CoreException {
        Database db = this.pdom.getDB();
        int rec = db.getInt(this.record + 6);
        return db.getString(rec);
    }

    public PDOMLanguage getNext() throws CoreException {
        int nextrec = this.pdom.getDB().getInt(this.record + 0);
        return nextrec != 0 ? new PDOMLanguage(this.pdom, nextrec) : null;
    }

    public boolean equals(String id) throws CoreException {
        return this.getName().equals(id);
    }
}

