/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexChangeListener;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexerStateListener;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.index.IndexerSetupParticipant;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ILanguageMappingChangeListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexManager;
import org.eclipse.cdt.internal.core.index.IndexChangeEvent;
import org.eclipse.cdt.internal.core.index.IndexFactory;
import org.eclipse.cdt.internal.core.index.IndexerStateEvent;
import org.eclipse.cdt.internal.core.index.provider.IndexProviderManager;
import org.eclipse.cdt.internal.core.pdom.CModelListener;
import org.eclipse.cdt.internal.core.pdom.CProjectDescriptionListener;
import org.eclipse.cdt.internal.core.pdom.IPDOM;
import org.eclipse.cdt.internal.core.pdom.IndexUpdatePolicy;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.cdt.internal.core.pdom.JobChangeListener;
import org.eclipse.cdt.internal.core.pdom.LanguageMappingChangeListener;
import org.eclipse.cdt.internal.core.pdom.Messages;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.PDOMIndexerJob;
import org.eclipse.cdt.internal.core.pdom.PDOMProxy;
import org.eclipse.cdt.internal.core.pdom.TeamPDOMExportOperation;
import org.eclipse.cdt.internal.core.pdom.TeamPDOMImportOperation;
import org.eclipse.cdt.internal.core.pdom.WritablePDOM;
import org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMProjectIndexLocationConverter;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMNullIndexer;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMRebuildTask;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMUpdateTask;
import org.eclipse.cdt.internal.core.pdom.indexer.ProjectIndexerInputAdapter;
import org.eclipse.cdt.internal.core.pdom.indexer.TranslationUnitCollector;
import org.eclipse.cdt.internal.core.pdom.indexer.TriggerNotificationTask;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDOMManager
implements IWritableIndexManager,
PDOM.IListener {
    public static final int UPDATE_EXTERNAL_FILES_FOR_PROJECT = 65536;
    private static final String SETTINGS_FOLDER_NAME = ".settings";
    private static final QualifiedName dbNameProperty = new QualifiedName("org.eclipse.cdt.core", "pdomName");
    private static final ISchedulingRule NOTIFICATION_SCHEDULING_RULE = new PerInstanceSchedulingRule();
    private static final ISchedulingRule INDEXER_SCHEDULING_RULE = new PerInstanceSchedulingRule();
    private static final ISchedulingRule INIT_INDEXER_SCHEDULING_RULE = new PerInstanceSchedulingRule();
    public static final int[] IDS_FOR_LINKAGES_TO_INDEX = new int[]{1, 2, 3};
    private final LinkedList<IPDOMIndexerTask> fTaskQueue = new LinkedList();
    private PDOMIndexerJob fIndexerJob;
    private IPDOMIndexerTask fCurrentTask;
    private int fSourceCount;
    private int fHeaderCount;
    private int fTickCount;
    private Map<IProject, IPDOM> fProjectToPDOM = new HashMap<IProject, IPDOM>();
    private Map<File, ICProject> fFileToProject = new HashMap<File, ICProject>();
    private ListenerList fChangeListeners = new ListenerList();
    private ListenerList fStateListeners = new ListenerList();
    private IndexChangeEvent fIndexChangeEvent = new IndexChangeEvent();
    private IndexerStateEvent fIndexerStateEvent = new IndexerStateEvent();
    private CModelListener fCModelListener = new CModelListener(this);
    private ILanguageMappingChangeListener fLanguageChangeListener = new LanguageMappingChangeListener(this);
    private final ICProjectDescriptionListener fProjectDescriptionListener;
    private final JobChangeListener fJobChangeListener;
    private IndexFactory fIndexFactory = new IndexFactory(this);
    private IndexProviderManager fIndexProviderManager = new IndexProviderManager();
    private HashMap<ICProject, IndexUpdatePolicy> fUpdatePolicies = new HashMap();
    private HashMap<IProject, PCL> fPrefListeners = new HashMap();
    private ArrayList<IndexerSetupParticipant> fSetupParticipants = new ArrayList();
    private HashSet<ICProject> fPostponedProjects = new HashSet();
    private int fLastNotifiedState = 0;

    public PDOMManager() {
        this.fProjectDescriptionListener = new CProjectDescriptionListener(this);
        this.fJobChangeListener = new JobChangeListener(this);
    }

    public Job startup() {
        Job postStartupJob = new Job(CCorePlugin.getResourceString((String)"CCorePlugin.startupJob")){

            protected IStatus run(IProgressMonitor monitor) {
                PDOMManager.this.postStartup();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == PDOMManager.this;
            }
        };
        postStartupJob.setSystem(true);
        return postStartupJob;
    }

    protected void postStartup() {
        this.initializeDatabaseCache();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this.fJobChangeListener);
        this.fIndexProviderManager.startup();
        CoreModel model = CoreModel.getDefault();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fCModelListener, 16);
        model.addElementChangedListener((IElementChangedListener)this.fCModelListener);
        LanguageManager.getInstance().registerLanguageChangeListener(this.fLanguageChangeListener);
        CCorePlugin.getDefault().getProjectDescriptionManager().addCProjectDescriptionListener(this.fProjectDescriptionListener, 16);
        try {
            ICProject[] projects = model.getCModel().getCProjects();
            int i = 0;
            while (i < projects.length) {
                this.addProject(projects[i]);
                ++i;
            }
        }
        catch (CModelException e) {
            CCorePlugin.log((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        CCorePlugin.getDefault().getProjectDescriptionManager().removeCProjectDescriptionListener(this.fProjectDescriptionListener);
        CoreModel model = CoreModel.getDefault();
        model.removeElementChangedListener((IElementChangedListener)this.fCModelListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fCModelListener);
        LanguageManager.getInstance().unregisterLanguageChangeListener(this.fLanguageChangeListener);
        PDOMIndexerJob jobToCancel = null;
        LinkedList<IPDOMIndexerTask> linkedList = this.fTaskQueue;
        synchronized (linkedList) {
            this.fTaskQueue.clear();
            jobToCancel = this.fIndexerJob;
        }
        if (jobToCancel != null) {
            assert (!Thread.holdsLock(this.fTaskQueue));
            jobToCancel.cancelJobs(null, false);
        }
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)this.fJobChangeListener);
    }

    private void initializeDatabaseCache() {
        this.adjustCacheSize();
        CCorePlugin.getDefault().getPluginPreferences().addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                String prop = event.getProperty();
                if (prop.equals("org.eclipse.cdt.core.indexDBCacheSizePct") || prop.equals("org.eclipse.cdt.core.maxIndexDBCacheSizeMB")) {
                    PDOMManager.this.adjustCacheSize();
                }
            }
        });
    }

    protected void adjustCacheSize() {
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
        int cachePct = prefs.getInt("org.eclipse.cdt.core.indexDBCacheSizePct");
        int cacheMax = prefs.getInt("org.eclipse.cdt.core.maxIndexDBCacheSizeMB");
        cachePct = Math.max(1, Math.min(50, cachePct));
        cacheMax = Math.max(1, cacheMax);
        long m1 = Runtime.getRuntime().maxMemory() / 100L * (long)cachePct;
        long m2 = Math.min(m1, (long)cacheMax * 1024L * 1024L);
        ChunkCache.getSharedInstance().setMaxSize(m2);
    }

    public IndexProviderManager getIndexProviderManager() {
        return this.fIndexProviderManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPDOM getPDOM(ICProject project) throws CoreException {
        Map<IProject, IPDOM> map = this.fProjectToPDOM;
        synchronized (map) {
            IProject rproject = project.getProject();
            IPDOM pdom = this.fProjectToPDOM.get(rproject);
            if (pdom == null) {
                pdom = new PDOMProxy();
                this.fProjectToPDOM.put(rproject, pdom);
            }
            return pdom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WritablePDOM getOrCreatePDOM(ICProject project) throws CoreException {
        Map<IProject, IPDOM> map = this.fProjectToPDOM;
        synchronized (map) {
            WritablePDOM pdom;
            IProject rproject = project.getProject();
            IPDOM pdomProxy = this.fProjectToPDOM.get(rproject);
            if (pdomProxy instanceof WritablePDOM) {
                return (WritablePDOM)pdomProxy;
            }
            String dbName = rproject.getPersistentProperty(dbNameProperty);
            File dbFile = null;
            if (dbName != null) {
                dbFile = this.fileFromDatabaseName(dbName);
                if (!dbFile.exists()) {
                    dbFile = null;
                    dbName = null;
                } else {
                    ICProject currentCOwner = this.fFileToProject.get(dbFile);
                    if (currentCOwner != null) {
                        IProject currentOwner = currentCOwner.getProject();
                        if (!currentOwner.exists()) {
                            this.fFileToProject.remove(dbFile);
                            dbFile.delete();
                        }
                        dbName = null;
                        dbFile = null;
                    }
                }
            }
            boolean fromScratch = false;
            if (dbName == null) {
                dbName = this.createNewDatabaseName(project);
                dbFile = this.fileFromDatabaseName(dbName);
                this.storeDatabaseName(rproject, dbName);
                fromScratch = true;
            }
            if (!(pdom = new WritablePDOM(dbFile, new PDOMProjectIndexLocationConverter(rproject), this.getLinkageFactories())).isSupportedVersion() || fromScratch) {
                try {
                    pdom.acquireWriteLock();
                }
                catch (InterruptedException e) {
                    throw new CoreException(CCorePlugin.createStatus((String)Messages.PDOMManager_creationOfIndexInterrupted, (Throwable)e));
                }
                if (fromScratch) {
                    pdom.setCreatedFromScratch(true);
                } else {
                    pdom.clear();
                    pdom.setClearedBecauseOfVersionMismatch(true);
                }
                PDOMManager.writeProjectPDOMProperties(pdom, rproject);
                pdom.releaseWriteLock();
            }
            pdom.setASTFilePathResolver(new ProjectIndexerInputAdapter(project, false));
            pdom.addListener(this);
            this.fFileToProject.put(dbFile, project);
            this.fProjectToPDOM.put(rproject, pdom);
            if (pdomProxy instanceof PDOMProxy) {
                ((PDOMProxy)pdomProxy).setDelegate(pdom);
            }
            return pdom;
        }
    }

    private Map<String, IPDOMLinkageFactory> getLinkageFactories() {
        return LanguageManager.getInstance().getPDOMLinkageFactoryMappings();
    }

    private void storeDatabaseName(IProject rproject, String dbName) throws CoreException {
        rproject.setPersistentProperty(dbNameProperty, dbName);
    }

    private String createNewDatabaseName(ICProject project) {
        String dbName;
        File file;
        long time = System.currentTimeMillis();
        while ((file = this.fileFromDatabaseName(dbName = this.getDefaultName(project, time++))).exists()) {
        }
        return dbName;
    }

    private File fileFromDatabaseName(String dbName) {
        return CCorePlugin.getDefault().getStateLocation().append(dbName).toFile();
    }

    private String getDefaultName(ICProject project, long time) {
        return String.valueOf(project.getElementName()) + "." + time + ".pdom";
    }

    @Override
    public String getDefaultIndexerId() {
        return this.getIndexerId(null);
    }

    @Override
    public void setDefaultIndexerId(String indexerId) {
        IndexerPreferences.setDefaultIndexerId(indexerId);
    }

    @Override
    public String getIndexerId(ICProject project) {
        IProject prj = project != null ? project.getProject() : null;
        return IndexerPreferences.get(prj, "indexerId", "org.eclipse.cdt.core.nullindexer");
    }

    @Override
    public void setIndexerId(ICProject project, String indexerId) {
        IProject prj = project.getProject();
        IndexerPreferences.set(prj, "indexerId", indexerId);
        CCoreInternals.savePreferences((IProject)prj, (IndexerPreferences.getScope(prj) == 2 ? 1 : 0) != 0);
    }

    protected void onPreferenceChange(ICProject cproject, IEclipsePreferences.PreferenceChangeEvent event) {
        if ("updatePolicy".equals(event.getKey())) {
            this.changeUpdatePolicy(cproject);
        } else {
            IProject project = cproject.getProject();
            if (project.exists() && project.isOpen()) {
                try {
                    this.changeIndexer(cproject);
                }
                catch (Exception e) {
                    CCorePlugin.log((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeUpdatePolicy(ICProject cproject) {
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        HashMap<ICProject, IndexUpdatePolicy> hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            IPDOMIndexerTask task;
            IndexUpdatePolicy policy = this.getPolicy(cproject);
            if (policy != null && (task = policy.changePolicy(IndexerPreferences.getUpdatePolicy(cproject.getProject()))) != null) {
                this.enqueue(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeIndexer(ICProject cproject) throws CoreException {
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        IPDOMIndexer oldIndexer = this.getIndexer(cproject);
        if (oldIndexer == null) {
            return;
        }
        IProject prj = cproject.getProject();
        String newid = IndexerPreferences.get(prj, "indexerId", "org.eclipse.cdt.core.nullindexer");
        Properties props = IndexerPreferences.getProperties(prj);
        HashMap<ICProject, IndexUpdatePolicy> hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            oldIndexer = this.getIndexer(cproject);
            if (oldIndexer != null) {
                if (oldIndexer.getID().equals(newid) && !oldIndexer.needsToRebuildForProperties(props)) {
                    oldIndexer.setProperties(props);
                    return;
                }
                IPDOMIndexer indexer = this.createIndexer(cproject, newid, props);
                this.registerIndexer(cproject, indexer);
                this.createPolicy(cproject).clearTUs();
                this.enqueue(new PDOMRebuildTask(indexer));
            }
        }
        if (oldIndexer != null) {
            this.stopIndexer(oldIndexer);
        }
    }

    private void registerIndexer(ICProject project, IPDOMIndexer indexer) {
        assert (Thread.holdsLock(this.fUpdatePolicies));
        indexer.setProject(project);
        this.registerPreferenceListener(project);
        this.createPolicy(project).setIndexer(indexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IPDOMIndexer getIndexer(ICProject project) {
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        HashMap<ICProject, IndexUpdatePolicy> hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            IndexUpdatePolicy policy = this.getPolicy(project);
            if (policy != null) {
                return policy.getIndexer();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexer(ICProject project, IProgressMonitor pm) {
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        IProject prj = project.getProject();
        try {
            IndexUpdatePolicy policy;
            IPDOMIndexer indexer;
            Properties props;
            HashMap<ICProject, IndexUpdatePolicy> hashMap = this.fUpdatePolicies;
            synchronized (hashMap) {
                boolean rebuild;
                WritablePDOM pdom = this.getOrCreatePDOM(project);
                props = IndexerPreferences.getProperties(prj);
                indexer = this.createIndexer(project, this.getIndexerId(project), props);
                policy = this.createPolicy(project);
                boolean bl = rebuild = pdom.isClearedBecauseOfVersionMismatch() || pdom.isCreatedFromScratch() || policy.isInitialRebuildRequested();
                if (rebuild) {
                    if ("org.eclipse.cdt.core.nullindexer".equals(indexer.getID())) {
                        rebuild = false;
                    }
                    pdom.setClearedBecauseOfVersionMismatch(false);
                    pdom.setCreatedFromScratch(false);
                }
                if (!rebuild) {
                    this.registerIndexer(project, indexer);
                    IPDOMIndexerTask task = this.createPolicy(project).createTask();
                    if (task != null) {
                        this.enqueue(task);
                    } else {
                        this.enqueue(new TriggerNotificationTask(this, pdom));
                    }
                    return;
                }
            }
            TeamPDOMImportOperation operation = new TeamPDOMImportOperation(project);
            operation.run(pm);
            HashMap<ICProject, IndexUpdatePolicy> hashMap2 = this.fUpdatePolicies;
            synchronized (hashMap2) {
                props = IndexerPreferences.getProperties(prj);
                indexer = this.createIndexer(project, this.getIndexerId(project), props);
                this.registerIndexer(project, indexer);
                policy = this.createPolicy(project);
                policy.clearTUs();
                policy.clearInitialFlags();
                IPDOMIndexerTask task = null;
                task = operation.wasSuccessful() ? new PDOMUpdateTask(indexer, 2) : new PDOMRebuildTask(indexer);
                this.enqueue(task);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
    }

    private IPDOMIndexer createIndexer(ICProject project, String indexerId, Properties props) throws CoreException {
        IPDOMIndexer indexer = null;
        IExtension indexerExt = Platform.getExtensionRegistry().getExtension("org.eclipse.cdt.core.CIndexer", indexerId);
        if (indexerExt != null) {
            IConfigurationElement[] elements = indexerExt.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                if ("run".equals(element.getName())) {
                    try {
                        indexer = (IPDOMIndexer)element.createExecutableExtension("class");
                        indexer.setProperties(props);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log((Throwable)e);
                    }
                    break;
                }
                ++i;
            }
        }
        if (indexer == null) {
            indexer = new PDOMNullIndexer();
        }
        return indexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(IPDOMIndexerTask subjob) {
        HashSet<IProject> referencing = new HashSet<IProject>();
        IPDOMIndexer indexer = subjob.getIndexer();
        if (indexer != null) {
            this.getReferencingProjects(indexer.getProject().getProject(), referencing);
        }
        LinkedList<IPDOMIndexerTask> linkedList = this.fTaskQueue;
        synchronized (linkedList) {
            int i = 0;
            for (IPDOMIndexerTask task : this.fTaskQueue) {
                IPDOMIndexer ti = task.getIndexer();
                if (ti != null && referencing.contains(ti.getProject().getProject())) {
                    this.fTaskQueue.add(i, subjob);
                    break;
                }
                ++i;
            }
            if (i == this.fTaskQueue.size()) {
                this.fTaskQueue.addLast(subjob);
            }
            if (this.fIndexerJob == null) {
                this.fTickCount = 0;
                this.fHeaderCount = 0;
                this.fSourceCount = 0;
                this.fIndexerJob = new PDOMIndexerJob(this);
                this.fIndexerJob.setRule(INDEXER_SCHEDULING_RULE);
                this.fIndexerJob.schedule();
            }
        }
    }

    private void getReferencingProjects(IProject prj, HashSet<IProject> result) {
        LinkedList<IProject> projectsToSearch = new LinkedList<IProject>();
        projectsToSearch.add(prj);
        while (!projectsToSearch.isEmpty()) {
            prj = (IProject)projectsToSearch.removeFirst();
            if (!result.add(prj)) continue;
            projectsToSearch.addAll(Arrays.asList(prj.getReferencingProjects()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IPDOMIndexerTask getNextTask() {
        IPDOMIndexerTask result = null;
        LinkedList<IPDOMIndexerTask> linkedList = this.fTaskQueue;
        synchronized (linkedList) {
            if (this.fTaskQueue.isEmpty()) {
                this.fCurrentTask = null;
                this.fIndexerJob = null;
            } else {
                if (this.fCurrentTask != null) {
                    IndexerProgress info = this.fCurrentTask.getProgressInformation();
                    this.fSourceCount += info.fCompletedSources;
                    this.fHeaderCount += info.fCompletedHeaders;
                    this.fTickCount += info.fCompletedSources + info.fPrimaryHeaderCount;
                }
                result = this.fCurrentTask = this.fTaskQueue.removeFirst();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelledJob(boolean byManager) {
        LinkedList<IPDOMIndexerTask> linkedList = this.fTaskQueue;
        synchronized (linkedList) {
            this.fCurrentTask = null;
            if (!byManager) {
                this.fTaskQueue.clear();
            }
            if (this.fTaskQueue.isEmpty()) {
                this.fIndexerJob = null;
            } else {
                this.fIndexerJob = new PDOMIndexerJob(this);
                this.fIndexerJob.setRule(INDEXER_SCHEDULING_RULE);
                this.fIndexerJob.schedule();
            }
        }
    }

    @Override
    public boolean isIndexerIdle() {
        return Job.getJobManager().find((Object)this).length == 0;
    }

    void addProject(final ICProject cproject) {
        final IProject project = cproject.getProject();
        Job addProject = new Job(Messages.PDOMManager_StartJob_name){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("", 100);
                if (project.isOpen() && !PDOMManager.this.postponeSetup(cproject)) {
                    this.syncronizeProjectSettings(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (PDOMManager.this.getIndexer(cproject) == null) {
                        PDOMManager.this.createIndexer(cproject, (IProgressMonitor)new SubProgressMonitor(monitor, 99));
                    }
                }
                return Status.OK_STATUS;
            }

            private void syncronizeProjectSettings(IProject project2, IProgressMonitor monitor) {
                try {
                    IFolder settings = project2.getFolder(PDOMManager.SETTINGS_FOLDER_NAME);
                    settings.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    CCorePlugin.log((Throwable)e);
                }
                monitor.done();
            }

            public boolean belongsTo(Object family) {
                return family == PDOMManager.this;
            }
        };
        IWorkspaceRoot rule = project.getWorkspace().getRoot();
        rule = project.contains((ISchedulingRule)rule) ? MultiRule.combine((ISchedulingRule)project, (ISchedulingRule)INIT_INDEXER_SCHEDULING_RULE) : (rule.contains((ISchedulingRule)project) ? MultiRule.combine((ISchedulingRule)rule, (ISchedulingRule)INIT_INDEXER_SCHEDULING_RULE) : MultiRule.combine((ISchedulingRule[])new ISchedulingRule[]{rule, project, INIT_INDEXER_SCHEDULING_RULE}));
        addProject.setRule((ISchedulingRule)rule);
        addProject.setSystem(true);
        addProject.schedule();
    }

    private void registerPreferenceListener(ICProject project) {
        IProject prj = project.getProject();
        PCL pcl = this.fPrefListeners.get(prj);
        if (pcl == null) {
            pcl = new PCL(project);
            this.fPrefListeners.put(prj, pcl);
        }
        IndexerPreferences.addChangeListener(prj, pcl);
        Preferences pref = CCorePlugin.getDefault().getPluginPreferences();
        pref.addPropertyChangeListener((Preferences.IPropertyChangeListener)pcl);
    }

    private void unregisterPreferenceListener(ICProject project) {
        IProject prj = project.getProject();
        PCL pcl = this.fPrefListeners.remove(prj);
        if (pcl != null) {
            IndexerPreferences.removeChangeListener(prj, pcl);
            Preferences pref = CCorePlugin.getDefault().getPluginPreferences();
            pref.removePropertyChangeListener((Preferences.IPropertyChangeListener)pcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeProject(ICProject project, ITranslationUnit[] added, ITranslationUnit[] changed, ITranslationUnit[] removed) {
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        IPDOMIndexer indexer = this.getIndexer(project);
        if (indexer != null && indexer.getID().equals("org.eclipse.cdt.core.nullindexer")) {
            return;
        }
        if (added.length > 0 || changed.length > 0 || removed.length > 0) {
            HashMap<ICProject, IndexUpdatePolicy> hashMap = this.fUpdatePolicies;
            synchronized (hashMap) {
                IndexUpdatePolicy policy = this.createPolicy(project);
                IPDOMIndexerTask task = policy.handleDelta(added, changed, removed);
                if (task != null) {
                    this.enqueue(task);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexUpdatePolicy createPolicy(ICProject project) {
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        HashMap<ICProject, IndexUpdatePolicy> hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            IndexUpdatePolicy policy = this.fUpdatePolicies.get(project);
            if (policy == null) {
                policy = new IndexUpdatePolicy(project, IndexerPreferences.getUpdatePolicy(project.getProject()));
                this.fUpdatePolicies.put(project, policy);
            }
            return policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexUpdatePolicy getPolicy(ICProject project) {
        HashMap<ICProject, IndexUpdatePolicy> hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            return this.fUpdatePolicies.get(project);
        }
    }

    public void preDeleteProject(ICProject cproject) {
        this.preRemoveProject(cproject, true);
    }

    public void preCloseProject(ICProject cproject) {
        this.preRemoveProject(cproject, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preRemoveProject(ICProject cproject, final boolean delete) {
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        IPDOMIndexer indexer = this.getIndexer(cproject);
        if (indexer != null) {
            this.stopIndexer(indexer);
        }
        this.unregisterPreferenceListener(cproject);
        IPDOM pdom = null;
        Map<IProject, IPDOM> map = this.fProjectToPDOM;
        synchronized (map) {
            IProject rproject = cproject.getProject();
            pdom = this.fProjectToPDOM.remove(rproject);
            if (pdom instanceof WritablePDOM && !delete) {
                this.fFileToProject.remove(((WritablePDOM)pdom).getDB().getLocation());
            }
        }
        if (pdom instanceof WritablePDOM) {
            final WritablePDOM finalpdom = (WritablePDOM)pdom;
            Job job = new Job(Messages.PDOMManager_ClosePDOMJob){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        finalpdom.acquireWriteLock();
                        try {
                            try {
                                finalpdom.close();
                                if (delete) {
                                    finalpdom.getDB().getLocation().delete();
                                }
                            }
                            catch (CoreException e) {
                                CCorePlugin.log((Throwable)e);
                                finalpdom.releaseWriteLock();
                            }
                        }
                        finally {
                            finalpdom.releaseWriteLock();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
        map = this.fUpdatePolicies;
        synchronized (map) {
            this.fUpdatePolicies.remove(cproject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProject(ICProject cproject, ICElementDelta delta) {
        Map<IProject, IPDOM> map = this.fProjectToPDOM;
        synchronized (map) {
            IProject rproject = cproject.getProject();
            this.fProjectToPDOM.remove(rproject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopIndexer(IPDOMIndexer indexer) {
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        assert (!Thread.holdsLock(this.fUpdatePolicies));
        ICProject project = indexer.getProject();
        HashMap<ICProject, IndexUpdatePolicy> hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            IndexUpdatePolicy policy = this.getPolicy(project);
            if (policy != null && policy.getIndexer() == indexer) {
                policy.clearTUs();
                policy.setIndexer(null);
            }
        }
        this.cancelIndexerJobs(indexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelIndexerJobs(IPDOMIndexer indexer) {
        PDOMIndexerJob jobToCancel = null;
        LinkedList<IPDOMIndexerTask> linkedList = this.fTaskQueue;
        synchronized (linkedList) {
            Iterator iter = this.fTaskQueue.iterator();
            while (iter.hasNext()) {
                IPDOMIndexerTask task = (IPDOMIndexerTask)iter.next();
                if (task.getIndexer() != indexer) continue;
                iter.remove();
            }
            jobToCancel = this.fIndexerJob;
        }
        if (jobToCancel != null) {
            assert (!Thread.holdsLock(this.fTaskQueue));
            jobToCancel.cancelJobs(indexer, true);
        }
    }

    @Override
    public void reindex(final ICProject project) {
        Job job = new Job(Messages.PDOMManager_notifyJob_label){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                IPDOMIndexer indexer = null;
                HashMap hashMap = PDOMManager.this.fUpdatePolicies;
                synchronized (hashMap) {
                    indexer = PDOMManager.this.getIndexer(project);
                    if (indexer == null) {
                        PDOMManager.this.createPolicy(project).requestInitialReindex();
                        return Status.OK_STATUS;
                    }
                }
                PDOMManager.this.cancelIndexerJobs(indexer);
                hashMap = PDOMManager.this.fUpdatePolicies;
                synchronized (hashMap) {
                    indexer = PDOMManager.this.getIndexer(project);
                    if (indexer != null) {
                        PDOMManager.this.createPolicy(project).clearTUs();
                        PDOMManager.this.enqueue(new PDOMRebuildTask(indexer));
                    }
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == PDOMManager.this;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    @Override
    public void addIndexChangeListener(IIndexChangeListener listener) {
        this.fChangeListeners.add((Object)listener);
    }

    @Override
    public void removeIndexChangeListener(IIndexChangeListener listener) {
        this.fChangeListeners.remove((Object)listener);
    }

    @Override
    public void addIndexerStateListener(IIndexerStateListener listener) {
        this.fStateListeners.add((Object)listener);
    }

    @Override
    public void removeIndexerStateListener(IIndexerStateListener listener) {
        this.fStateListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireStateChange(final int state) {
        ListenerList listenerList = this.fStateListeners;
        synchronized (listenerList) {
            if (this.fLastNotifiedState == state) {
                return;
            }
            this.fLastNotifiedState = state;
            if (this.fStateListeners.isEmpty()) {
                return;
            }
            Job notify = new Job(Messages.PDOMManager_notifyJob_label){

                protected IStatus run(IProgressMonitor monitor) {
                    PDOMManager.this.fIndexerStateEvent.setState(state);
                    Object[] listeners = PDOMManager.this.fStateListeners.getListeners();
                    monitor.beginTask(Messages.PDOMManager_notifyTask_message, listeners.length);
                    int i = 0;
                    while (i < listeners.length) {
                        final IIndexerStateListener listener = (IIndexerStateListener)listeners[i];
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                                CCorePlugin.log((Throwable)exception);
                            }

                            public void run() throws Exception {
                                listener.indexChanged(PDOMManager.this.fIndexerStateEvent);
                            }
                        });
                        monitor.worked(1);
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
            };
            notify.setRule(NOTIFICATION_SCHEDULING_RULE);
            notify.setSystem(true);
            notify.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleChange(PDOM pdom, final PDOM.ChangeEvent e) {
        ICProject project;
        if (this.fChangeListeners.isEmpty()) {
            return;
        }
        Map<IProject, IPDOM> map = this.fProjectToPDOM;
        synchronized (map) {
            project = this.fFileToProject.get(pdom.getPath());
        }
        if (project != null) {
            final ICProject finalProject = project;
            Job notify = new Job(Messages.PDOMManager_notifyJob_label){

                protected IStatus run(IProgressMonitor monitor) {
                    PDOMManager.this.fIndexChangeEvent.setAffectedProject(finalProject, e);
                    Object[] listeners = PDOMManager.this.fChangeListeners.getListeners();
                    monitor.beginTask(Messages.PDOMManager_notifyTask_message, listeners.length);
                    int i = 0;
                    while (i < listeners.length) {
                        final IIndexChangeListener listener = (IIndexChangeListener)listeners[i];
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                                CCorePlugin.log((Throwable)exception);
                            }

                            public void run() throws Exception {
                                listener.indexChanged(PDOMManager.this.fIndexChangeEvent);
                            }
                        });
                        monitor.worked(1);
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
            };
            notify.setRule(NOTIFICATION_SCHEDULING_RULE);
            notify.setSystem(true);
            notify.schedule();
        }
    }

    @Override
    public boolean joinIndexer(final int waitMaxMillis, final IProgressMonitor monitor) {
        boolean bl;
        assert (monitor != null);
        Thread th = null;
        if (waitMaxMillis != -1) {
            th = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(waitMaxMillis);
                        monitor.setCanceled(true);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            };
            th.setDaemon(true);
            th.start();
        }
        try {
            Job.getJobManager().join((Object)this, monitor);
            return true;
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InterruptedException interruptedException) {}
        {
            bl = Job.getJobManager().find((Object)this).length == 0;
        }
        return bl;
        finally {
            if (th != null) {
                th.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMonitorMessage(IProgressMonitor monitor, int currentTicks, int base) {
        int newTick;
        int tickCount;
        int tickEstimate;
        int headerCount;
        int sourceCount;
        int sourceEstimate;
        assert (!Thread.holdsLock(this.fTaskQueue));
        String detail = null;
        LinkedList<IPDOMIndexerTask> linkedList = this.fTaskQueue;
        synchronized (linkedList) {
            sourceCount = sourceEstimate = this.fSourceCount;
            headerCount = this.fHeaderCount;
            tickCount = tickEstimate = this.fTickCount;
            for (IPDOMIndexerTask task : this.fTaskQueue) {
                IndexerProgress info = task.getProgressInformation();
                sourceEstimate += info.fRequestedFilesCount;
                tickEstimate += info.getEstimatedTicks();
            }
            if (this.fCurrentTask != null) {
                IndexerProgress info = this.fCurrentTask.getProgressInformation();
                sourceCount += info.fCompletedSources;
                sourceEstimate += info.fRequestedFilesCount - info.fPrimaryHeaderCount;
                headerCount += info.fCompletedHeaders;
                tickCount += info.fCompletedSources + info.fPrimaryHeaderCount;
                tickEstimate += info.getEstimatedTicks();
                detail = PDOMIndexerJob.sMonitorDetail;
            }
        }
        String msg = MessageFormat.format(Messages.PDOMManager_indexMonitorDetail, new Integer(sourceCount), new Integer(sourceEstimate), new Integer(headerCount));
        if (detail != null) {
            msg = String.valueOf(msg) + ": " + detail;
        }
        monitor.subTask(msg);
        if (tickCount > 0 && tickCount <= tickEstimate && (newTick = tickCount * base / tickEstimate) > currentTicks) {
            monitor.worked(newTick - currentTicks);
            return newTick;
        }
        return currentTicks;
    }

    @Override
    public IWritableIndex getWritableIndex(ICProject project) throws CoreException {
        return this.fIndexFactory.getWritableIndex(project);
    }

    @Override
    public IIndex getIndex(ICProject project) throws CoreException {
        return this.fIndexFactory.getIndex(new ICProject[]{project}, 0);
    }

    @Override
    public IIndex getIndex(ICProject[] projects) throws CoreException {
        return this.fIndexFactory.getIndex(projects, 0);
    }

    @Override
    public IIndex getIndex(ICProject project, int options) throws CoreException {
        return this.fIndexFactory.getIndex(new ICProject[]{project}, options);
    }

    @Override
    public IIndex getIndex(ICProject[] projects, int options) throws CoreException {
        return this.fIndexFactory.getIndex(projects, options);
    }

    public void exportProjectPDOM(ICProject cproject, File targetLocation, IIndexLocationConverter newConverter) throws CoreException {
        boolean deleted;
        if (targetLocation.exists() && !(deleted = targetLocation.delete())) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.PDOMManager_ExistingFileCollides, targetLocation));
        }
        try {
            WritablePDOM pdom = this.getOrCreatePDOM(cproject);
            pdom.acquireReadLock();
            String oldID = null;
            try {
                oldID = pdom.getProperty("org.eclipse.cdt.internal.core.index.fragment.id");
                ((PDOM)pdom).flush();
                FileChannel to = new FileOutputStream(targetLocation).getChannel();
                pdom.getDB().transferTo(to);
                to.close();
            }
            finally {
                pdom.releaseReadLock();
            }
            WritablePDOM newPDOM = new WritablePDOM(targetLocation, pdom.getLocationConverter(), this.getLinkageFactories());
            newPDOM.acquireWriteLock();
            try {
                newPDOM.rewriteLocations(newConverter);
                newPDOM.setProperty("org.eclipse.cdt.internal.core.index.fragment.id", "exported." + oldID);
                newPDOM.close();
            }
            finally {
                newPDOM.releaseWriteLock();
            }
        }
        catch (IOException ioe) {
            throw new CoreException(CCorePlugin.createStatus((String)ioe.getMessage()));
        }
        catch (InterruptedException ie) {
            throw new CoreException(CCorePlugin.createStatus((String)ie.getMessage()));
        }
    }

    public void importProjectPDOM(ICProject project, InputStream stream) throws CoreException, IOException {
        String newName = this.createNewDatabaseName(project);
        File newFile = this.fileFromDatabaseName(newName);
        FileOutputStream out = new FileOutputStream(newFile);
        try {
            int read;
            int version = 0;
            int i = 0;
            while (i < 4) {
                byte b = (byte)stream.read();
                version = (version << 8) + (b & 0xFF);
                ((OutputStream)out).write(b);
                ++i;
            }
            if (version < PDOM.MIN_SUPPORTED_VERSION || version > PDOM.MAX_SUPPORTED_VERSION) {
                Status status = new Status(2, "org.eclipse.cdt.core", 0, CCorePlugin.getResourceString((String)"PDOMManager.unsupportedVersion"), null);
                throw new CoreException((IStatus)status);
            }
            byte[] buffer = new byte[2048];
            while ((read = stream.read(buffer)) >= 0) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        finally {
            ((OutputStream)out).close();
        }
        WritablePDOM pdom = (WritablePDOM)this.getPDOM(project);
        try {
            pdom.acquireWriteLock();
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        try {
            pdom.reloadFromFile(newFile);
            this.storeDatabaseName(project.getProject(), newName);
            PDOMManager.writeProjectPDOMProperties(pdom, project.getProject());
        }
        finally {
            pdom.releaseWriteLock();
        }
    }

    @Override
    public void export(ICProject project, String location, int options, IProgressMonitor monitor) throws CoreException {
        TeamPDOMExportOperation operation = new TeamPDOMExportOperation(project);
        operation.setTargetLocation(location);
        operation.setOptions(options);
        operation.run(monitor);
    }

    public static void writeProjectPDOMProperties(WritablePDOM pdom, IProject project) throws CoreException {
        String DELIM = "\u0000";
        String id = "org.eclipse.cdt.core.pdom.project." + DELIM + project.getName() + DELIM;
        pdom.setProperty("org.eclipse.cdt.internal.core.index.fragment.id", id);
    }

    @Override
    public boolean isProjectIndexed(ICProject proj) {
        return !"org.eclipse.cdt.core.nullindexer".equals(this.getIndexerId(proj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIndexerSetupPostponed(ICProject proj) {
        ArrayList<IndexerSetupParticipant> arrayList = this.fSetupParticipants;
        synchronized (arrayList) {
            return this.fPostponedProjects.contains(proj);
        }
    }

    @Override
    public void update(ICElement[] tuSelection, int options) throws CoreException {
        Map<ICProject, List<ICElement>> projectsToElements = this.splitSelection(tuSelection);
        for (Map.Entry<ICProject, List<ICElement>> entry : projectsToElements.entrySet()) {
            ICProject project = entry.getKey();
            List<ICElement> filesAndFolders = entry.getValue();
            this.update(project, filesAndFolders, options);
        }
    }

    private Map<ICProject, List<ICElement>> splitSelection(ICElement[] tuSelection) {
        HashMap<ICProject, List<ICElement>> result = new HashMap<ICProject, List<ICElement>>();
        int i = 0;
        while (i < tuSelection.length) {
            block5: {
                ICElement element = tuSelection[i];
                if (element instanceof ICProject || element instanceof ICContainer || element instanceof ITranslationUnit) {
                    ICProject project = element.getCProject();
                    List<ICElement> set = result.get(project);
                    if (set == null) {
                        set = new ArrayList<ICElement>();
                        result.put(project, set);
                    }
                    int j = 0;
                    while (j < set.size()) {
                        ICElement other = set.get(j);
                        if (this.contains(other, element)) break block5;
                        if (this.contains(element, other)) {
                            set.set(j, element);
                            break block5;
                        }
                        ++j;
                    }
                    set.add(element);
                }
            }
            ++i;
        }
        return result;
    }

    private boolean contains(ICElement a, ICElement b) {
        if (a.equals(b)) {
            return true;
        }
        if ((b = b.getParent()) == null) {
            return false;
        }
        return this.contains(a, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(ICProject project, List<ICElement> filesAndFolders, int options) throws CoreException {
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        HashMap<ICProject, IndexUpdatePolicy> hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            IPDOMIndexer indexer = this.getIndexer(project);
            PDOMUpdateTask task = new PDOMUpdateTask(indexer, options);
            task.setTranslationUnitSelection(filesAndFolders);
            if (indexer != null) {
                this.enqueue(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePostBuildEvent() {
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        HashMap<ICProject, IndexUpdatePolicy> hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            for (IndexUpdatePolicy policy : this.fUpdatePolicies.values()) {
                IPDOMIndexerTask task = policy.createTask();
                if (task == null) continue;
                this.enqueue(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean postponeSetup(final ICProject cproject) {
        ArrayList<IndexerSetupParticipant> arrayList = this.fSetupParticipants;
        synchronized (arrayList) {
            IndexerSetupParticipant sp;
            Iterator<IndexerSetupParticipant> iterator = this.fSetupParticipants.iterator();
            do {
                if (iterator.hasNext()) continue;
                this.fPostponedProjects.remove(cproject);
                final IndexerSetupParticipant[] participants = this.fSetupParticipants.toArray(new IndexerSetupParticipant[this.fSetupParticipants.size()]);
                Job notify = new Job(Messages.PDOMManager_notifyJob_label){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.PDOMManager_notifyTask_message, participants.length);
                        IndexerSetupParticipant[] indexerSetupParticipantArray = participants;
                        int n = participants.length;
                        int n2 = 0;
                        while (n2 < n) {
                            final IndexerSetupParticipant p = indexerSetupParticipantArray[n2];
                            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                                public void handleException(Throwable exception) {
                                    CCorePlugin.log((Throwable)exception);
                                }

                                public void run() throws Exception {
                                    p.onIndexerSetup(cproject);
                                }
                            });
                            monitor.worked(1);
                            ++n2;
                        }
                        return Status.OK_STATUS;
                    }
                };
                notify.setRule(NOTIFICATION_SCHEDULING_RULE);
                notify.setSystem(true);
                notify.schedule();
                return false;
            } while (!(sp = iterator.next()).postponeIndexerSetup(cproject));
            this.fPostponedProjects.add(cproject);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyIndexerSetup(IndexerSetupParticipant participant, ICProject project) {
        ArrayList<IndexerSetupParticipant> arrayList = this.fSetupParticipants;
        synchronized (arrayList) {
            if (this.fPostponedProjects.contains(project)) {
                this.addProject(project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIndexerSetupParticipant(IndexerSetupParticipant participant) {
        ArrayList<IndexerSetupParticipant> arrayList = this.fSetupParticipants;
        synchronized (arrayList) {
            this.fSetupParticipants.add(participant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIndexerSetupParticipant(IndexerSetupParticipant participant) {
        ArrayList<IndexerSetupParticipant> arrayList = this.fSetupParticipants;
        synchronized (arrayList) {
            this.fSetupParticipants.remove(participant);
            for (ICProject project : this.fPostponedProjects) {
                this.addProject(project);
            }
        }
    }

    public boolean isProjectRegistered(ICProject project) {
        return this.getIndexer(project) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isProjectContentSynced(ICProject cproject) throws CoreException {
        HashSet<ITranslationUnit> sources = new HashSet<ITranslationUnit>();
        cproject.accept((ICElementVisitor)new TranslationUnitCollector(sources, null, (IProgressMonitor)new NullProgressMonitor()));
        try {
            IIndex index = this.getIndex(cproject);
            index.acquireReadLock();
            try {
                IIndexFileLocation location;
                ITranslationUnit tu;
                IResource resource;
                Iterator iterator = sources.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return true;
                } while (!((resource = (tu = (ITranslationUnit)iterator.next()).getResource()) instanceof IFile) || !this.isSubjectToIndexing(tu.getLanguage()) || PDOMManager.areSynchronized(new HashSet<IIndexFileLocation>(), index, resource, location = IndexLocationFactory.getWorkspaceIFL((IFile)resource)));
                return false;
            }
            finally {
                index.releaseReadLock();
            }
        }
        catch (InterruptedException ie) {
            CCorePlugin.log((Throwable)ie);
        }
        return true;
    }

    private boolean isSubjectToIndexing(ILanguage language) {
        int linkageID = language.getLinkageID();
        int[] nArray = IDS_FOR_LINKAGES_TO_INDEX;
        int n = IDS_FOR_LINKAGES_TO_INDEX.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            if (linkageID == id) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean areSynchronized(Set<IIndexFileLocation> trail, IIndex index, IResource resource, IIndexFileLocation location) throws CoreException {
        if (!trail.contains(location)) {
            IIndexInclude[] includes;
            trail.add(location);
            IIndexFile[] file = index.getFiles(location);
            if (file.length < 1 || file.length > 2) {
                return false;
            }
            if (resource.getLocalTimeStamp() != file[0].getTimestamp()) {
                return false;
            }
            IIndexInclude[] iIndexIncludeArray = includes = index.findIncludes(file[0]);
            int n = includes.length;
            int n2 = 0;
            while (n2 < n) {
                IFile newResource;
                String path;
                IIndexInclude inc = iIndexIncludeArray[n2];
                IIndexFileLocation newLocation = inc.getIncludesLocation();
                if (newLocation != null && (path = newLocation.getFullPath()) != null && !PDOMManager.areSynchronized(trail, index, (IResource)(newResource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path))), newLocation)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private final class PCL
    implements IEclipsePreferences.IPreferenceChangeListener,
    Preferences.IPropertyChangeListener {
        private ICProject fProject;

        public PCL(ICProject prj) {
            this.fProject = prj;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (this.fProject.getProject().isOpen()) {
                PDOMManager.this.onPreferenceChange(this.fProject, event);
            }
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("org.eclipse.cdt.core.taskTags") || property.equals("org.eclipse.cdt.core.taskPriorities") || property.equals("org.eclipse.cdt.core.taskCaseSensitive")) {
                PDOMManager.this.reindex(this.fProject);
            }
        }
    }

    private static final class PerInstanceSchedulingRule
    implements ISchedulingRule {
        private PerInstanceSchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

