/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.core.remotemake;

import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector2;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.StreamMonitor;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoConsoleParserFactory;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCMarkerGenerator;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.remotemake.RemoteProcessClosure;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.ptp.rdt.core.messages.Messages;
import org.eclipse.ptp.rdt.core.serviceproviders.IRemoteExecutionServiceProvider;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.services.core.ProjectNotConfiguredException;
import org.eclipse.ptp.rdt.services.core.ServiceModelManager;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteRunSIProvider
implements IExternalScannerInfoProvider {
    private static final String EXTERNAL_SI_PROVIDER_CONSOLE_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".ExternalScannerInfoProviderConsole";

    protected abstract List<String> getCommand(IProject var1, String var2, IScannerConfigBuilderInfo2 var3);

    protected abstract IPath getWorkingDirectory(IProject var1);

    public boolean invokeProvider(IProgressMonitor monitor, IResource resource, String providerId, IScannerConfigBuilderInfo2 buildInfo, IScannerInfoCollector collector) {
        InfoContext context = new InfoContext(resource.getProject());
        return this.invokeProvider(monitor, resource, context, providerId, buildInfo, collector, null);
    }

    public boolean invokeProvider(IProgressMonitor monitor, IResource resource, InfoContext context, String providerId, IScannerConfigBuilderInfo2 buildInfo, IScannerInfoCollector collector, Properties env) {
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        monitor.beginTask(Messages.RemoteRunSiProvider_taskName, 5);
        try {
            boolean bl = this.doInvoke(monitor, resource, context, providerId, buildInfo, collector, env);
            return bl;
        }
        catch (Exception e) {
            RDTLog.logError(e);
            return false;
        }
        finally {
            monitor.done();
        }
    }

    private boolean doInvoke(IProgressMonitor monitor, IResource resource, InfoContext context, String providerId, IScannerConfigBuilderInfo2 buildInfo, IScannerInfoCollector collector, Properties env) throws Exception {
        Object consoleErr;
        IRemoteExecutionServiceProvider executionProvider;
        System.out.println(Messages.RemoteRunSiProvider_taskName);
        IProject project = resource.getProject();
        if (collector instanceof IScannerInfoCollector2) {
            IScannerInfoCollector2 s2 = (IScannerInfoCollector2)collector;
            s2.setProject(project);
        }
        if ((executionProvider = RemoteRunSIProvider.getExecutionServiceProvider(project)) == null || monitor.isCanceled()) {
            return false;
        }
        IRemoteConnection connection = executionProvider.getConnection();
        if (connection == null) {
            return false;
        }
        if (!connection.isOpen()) {
            connection.open(monitor);
        }
        monitor.worked(1);
        List<String> runCommand = this.getCommand(project, providerId, buildInfo);
        if (runCommand == null || runCommand.isEmpty() || monitor.isCanceled()) {
            return false;
        }
        IRemoteServices remoteServices = executionProvider.getRemoteServices();
        IRemoteProcessBuilder processBuilder = remoteServices.getProcessBuilder(connection, runCommand);
        processBuilder.redirectErrorStream(true);
        String configPath = executionProvider.getConfigLocation();
        IRemoteFileManager remoteFileManager = remoteServices.getFileManager(connection);
        IFileStore workingDir = remoteFileManager.getResource((IPath)new Path(configPath), monitor);
        processBuilder.directory(workingDir);
        monitor.worked(1);
        IConsole console = CCorePlugin.getDefault().getConsole(EXTERNAL_SI_PROVIDER_CONSOLE_ID);
        console.start(project);
        StreamMonitor cos = new StreamMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 70), (OutputStream)console.getOutputStream(), 100);
        SCMarkerGenerator markerGenerator = new SCMarkerGenerator();
        ConsoleOutputSniffer sniffer = ScannerInfoConsoleParserFactory.getESIProviderOutputSniffer((OutputStream)cos, (OutputStream)cos, (IProject)project, (InfoContext)context, (String)providerId, (IScannerConfigBuilderInfo2)buildInfo, (IScannerInfoCollector)collector, (IMarkerGenerator)markerGenerator);
        Object consoleOut = sniffer == null ? cos : sniffer.getOutputStream();
        Object object = consoleErr = sniffer == null ? cos : sniffer.getErrorStream();
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.worked(1);
        IRemoteProcess remoteProcess = processBuilder.start();
        RemoteProcessClosure remoteProcessClosure = new RemoteProcessClosure(remoteProcess, (OutputStream)consoleOut, (OutputStream)consoleErr);
        remoteProcessClosure.runNonBlocking();
        remoteProcess.waitFor();
        ((OutputStream)consoleOut).close();
        ((OutputStream)consoleErr).close();
        cos.close();
        monitor.worked(1);
        return true;
    }

    private static IRemoteExecutionServiceProvider getExecutionServiceProvider(IProject project) {
        ServiceModelManager smm = ServiceModelManager.getInstance();
        try {
            IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project);
            IService buildService = smm.getService("org.eclipse.ptp.rdt.core.BuildService");
            IServiceProvider provider = serviceConfig.getServiceProvider(buildService);
            if (provider instanceof IRemoteExecutionServiceProvider) {
                return (IRemoteExecutionServiceProvider)provider;
            }
        }
        catch (ProjectNotConfiguredException projectNotConfiguredException) {
            return null;
        }
        return null;
    }
}

