/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.serviceproviders;

import java.io.IOException;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.internal.rdt.core.index.IIndexLifecycleService;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.IServiceModelEvent;
import org.eclipse.ptp.rdt.services.core.IServiceModelEventListener;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.services.core.ServiceModelManager;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class IndexLocationChangeListener
implements IServiceModelEventListener {
    private static final IndexLocationChangeListener instance = new IndexLocationChangeListener();

    private IndexLocationChangeListener() {
    }

    public static void startListening() {
        ServiceModelManager.getInstance().addEventListener((IServiceModelEventListener)instance, 4);
    }

    public static void stopListening() {
        ServiceModelManager.getInstance().removeEventListener((IServiceModelEventListener)instance);
    }

    public void handleEvent(IServiceModelEvent event) {
        if (event.getType() != 4) {
            return;
        }
        final ServiceModelManager smm = ServiceModelManager.getInstance();
        IService service = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService");
        IServiceConfiguration config = (IServiceConfiguration)event.getSource();
        if (config.isDisabled(service)) {
            return;
        }
        Set projects = smm.getProjectsForConfiguration(config);
        if (projects == null || projects.isEmpty()) {
            return;
        }
        IServiceProvider sp = config.getServiceProvider(service);
        if (!(sp instanceof IIndexServiceProvider)) {
            return;
        }
        final IIndexServiceProvider provider = (IIndexServiceProvider)sp;
        IServiceProvider oldProvider = event.getOldProvider();
        if (!(oldProvider instanceof IIndexServiceProvider)) {
            return;
        }
        String oldIndexLocation = ((IIndexServiceProvider)oldProvider).getIndexLocation();
        if (!oldIndexLocation.equals(provider.getIndexLocation())) {
            final IIndexLifecycleService indexService = provider.getIndexLifeCycleService();
            Set scopes = smm.getProjectsForConfiguration(config);
            for (IProject project : scopes) {
                final String scope = project.getName();
                Job job = new Job(Messages.getString("ServiceModelPropertyPage.0")){

                    protected IStatus run(IProgressMonitor monitor) {
                        final String newIndexLocation = provider.getIndexLocation();
                        final String actualLocation = indexService.moveIndexFile(scope, newIndexLocation, monitor);
                        if (actualLocation == null || !actualLocation.equals(newIndexLocation)) {
                            UIJob uijob = new UIJob(Messages.getString("ServiceModelPropertyPage.0")){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("ServiceModelPropertyPage.1"), (String)Messages.getString("ServiceModelPropertyPage.2", newIndexLocation, actualLocation));
                                    provider.setIndexLocation(actualLocation);
                                    try {
                                        smm.saveModelConfiguration();
                                    }
                                    catch (IOException e) {
                                        RDTLog.logError((Throwable)e);
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            uijob.schedule();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
    }
}

