/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.internal.common.Debug;
import org.eclipse.ptp.remotetools.internal.ssh.Connection;
import org.eclipse.ptp.remotetools.internal.ssh.Messages;
import org.eclipse.ptp.remotetools.utils.stream.ILineStreamListener;
import org.eclipse.ptp.remotetools.utils.stream.TextStreamObserver;

public class ControlChannel
implements ILineStreamListener {
    static final String marker = "//";
    static final String markerPID = "PID:";
    static final String markerPIID = "PIID:";
    static final String markerSSH = "SSH_TTY:";
    final Pattern pidPattern = Pattern.compile("^//PID:\\p{Digit}+//PIID:\\p{Digit}+//$");
    final Pattern pidFilterPattern = Pattern.compile("\\p{Digit}+");
    final Pattern terminalPathPattern = Pattern.compile("^//SSH_TTY:.+//$");
    OutputStream outputToControlTerminalInput;
    InputStream inputFromControlTerminalOutput;
    ChannelExec shell;
    String controlTerminalPath;
    TextStreamObserver controlTerminalObserver;
    private Connection connection;

    public ControlChannel(Connection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws RemoteConnectionException {
        try {
            this.shell = this.connection.createExecChannel(false);
            this.shell.setPty(true);
            this.shell.setCommand("/bin/bash");
            this.inputFromControlTerminalOutput = this.shell.getInputStream();
            this.outputToControlTerminalInput = this.shell.getOutputStream();
            this.shell.connect();
        }
        catch (JSchException e) {
            this.close();
            throw new RemoteConnectionException(Messages.ControlChannel_Open_FailedCreateAuxiliaryShell, e);
        }
        catch (IOException e) {
            this.close();
            throw new RemoteConnectionException(Messages.ControlChannel_Open_FailedCreateIOStream, e);
        }
        this.controlTerminalObserver = new TextStreamObserver(this.inputFromControlTerminalOutput, (ILineStreamListener)this);
        this.controlTerminalObserver.start();
        try {
            this.outputToControlTerminalInput.write("export PS1=\n".getBytes());
            this.outputToControlTerminalInput.write(new String("echo \"//SSH_TTY:$SSH_TTY//\"\n").getBytes());
            this.outputToControlTerminalInput.flush();
        }
        catch (IOException e) {
            throw new RemoteConnectionException(Messages.ControlChannel_Open_FailedSendInitCommands, e);
        }
        Debug.println2(Messages.ControlChannel_Debug_StartedWaitingControlTerminalPath);
        ControlChannel controlChannel = this;
        synchronized (controlChannel) {
            while (this.controlTerminalPath == null) {
                try {
                    this.wait(200L);
                }
                catch (InterruptedException e) {
                    throw new RemoteConnectionException(Messages.ControlChannel_Open_WaitControlTerminalPathInterrupted, e);
                }
            }
        }
        Debug.println2(String.valueOf(Messages.ControlChannel_Debug_ReceivedControlTerminalPath) + this.controlTerminalPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newLine(String line) {
        Debug.println2(String.valueOf(Messages.ControlChannel_Debug_ControlConnectionReceived) + line);
        Matcher pidmatch = this.pidPattern.matcher(line);
        if (pidmatch.find()) {
            Matcher pidmatch2 = this.pidFilterPattern.matcher(line);
            pidmatch2.find();
            String temppid = pidmatch2.group();
            pidmatch2.find();
            String temppiid = pidmatch2.group();
            this.connection.setPID(Integer.parseInt(temppiid), Integer.parseInt(temppid));
            return;
        }
        Matcher terminalPathMatcher = this.terminalPathPattern.matcher(line);
        if (terminalPathMatcher.find()) {
            int pre = new String("//SSH_TTY:").length();
            int pos = marker.length();
            ControlChannel controlChannel = this;
            synchronized (controlChannel) {
                this.controlTerminalPath = line.substring(pre, line.length() - pos);
                this.notifyAll();
            }
        }
    }

    public void streamClosed() {
    }

    public void streamError(Exception e) {
        Debug.println2(String.valueOf(Messages.ControlChannel_Debug_ControlConnectionReceived) + e);
    }

    public synchronized String getControlTerminalPath() {
        return this.controlTerminalPath;
    }

    public void killRemoteProcess(int pid) {
        try {
            this.outputToControlTerminalInput.write(new String("kill -9 " + pid + "\n").getBytes());
            this.outputToControlTerminalInput.flush();
        }
        catch (IOException iOException) {}
    }

    public synchronized String getKillablePrefix(int internaID) {
        return "echo //PID:$$//PIID:" + Integer.toString(internaID) + marker + " > " + this.controlTerminalPath;
    }

    public void close() {
        if (this.controlTerminalObserver != null) {
            this.controlTerminalObserver.kill();
        }
        this.controlTerminalObserver = null;
        this.outputToControlTerminalInput = null;
        this.inputFromControlTerminalOutput = null;
        if (this.shell != null) {
            this.shell.disconnect();
        }
        this.shell = null;
        this.connection = null;
    }
}

