/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.analysis;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTStatement;

public class BarrierExpression {
    protected BarrierExpressionOP op_;
    protected BarrierExpression operand1_;
    protected BarrierExpression operand2_;
    protected int length;
    public static final int TOP = -3;
    public static int count_branch = 0;
    public static int count_repeat = 0;
    public static int count_node = 0;
    boolean visited;
    boolean ceVisited;
    public static final int BE_bot = 1;
    public static final int BE_ID = 2;
    public static final int BE_func = 3;
    protected int type;
    protected int barrierID;
    protected String funcName_;
    protected BarrierExpression parent_;
    protected boolean error = false;

    public BarrierExpression() {
        this.init();
    }

    public BarrierExpression(int operator, IASTExpression cond, IASTStatement stmt) {
        this.init();
        this.op_ = new BarrierExpressionOP(operator, cond, stmt);
        if (this.op_.getOperator() == 3) {
            ++count_branch;
        } else if (this.op_.getOperator() == 2) {
            ++count_repeat;
        }
    }

    public BarrierExpression(String func) {
        this.init();
        this.type = 3;
        this.funcName_ = func;
        ++count_node;
    }

    public BarrierExpression(int id) {
        this.init();
        if (id == 1) {
            this.type = id;
        } else {
            this.type = 2;
            this.barrierID = id;
        }
        ++count_node;
    }

    private void init() {
        this.op_ = null;
        this.operand1_ = null;
        this.operand2_ = null;
        this.length = -1;
        this.type = -1;
        this.barrierID = 0;
        this.funcName_ = null;
        this.parent_ = null;
        this.visited = false;
        this.ceVisited = false;
    }

    public void setOperand1(BarrierExpression op1) {
        op1.setParent(this);
        this.operand1_ = op1;
    }

    public void setOperand2(BarrierExpression op2) {
        op2.setParent(this);
        this.operand2_ = op2;
    }

    public BarrierExpression getOP1() {
        return this.operand1_;
    }

    public BarrierExpression getOP2() {
        return this.operand2_;
    }

    public BarrierExpression getParent() {
        return this.parent_;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int l) {
        this.length = l;
    }

    public void setParent(BarrierExpression parent) {
        this.parent_ = parent;
    }

    public boolean isBot() {
        return this.type == 1;
    }

    public boolean isBarrier() {
        return this.type == 2;
    }

    public boolean isFunc() {
        return this.type == 3;
    }

    public BarrierExpressionOP getOP() {
        return this.op_;
    }

    public int getBarrierID() {
        return this.barrierID;
    }

    public String getFuncName() {
        return this.funcName_;
    }

    public void setErrorFlag(boolean val) {
        this.error = val;
    }

    public boolean getErrorFlag() {
        return this.error;
    }

    public static BarrierExpression concatBE(BarrierExpression BE1, BarrierExpression BE2) {
        BarrierExpression be = null;
        if (BE1.isBot()) {
            be = BE2;
        } else if (BE2.isBot()) {
            be = BE1;
        } else {
            be = new BarrierExpression(1, null, null);
            be.setOperand1(BE1);
            be.setOperand2(BE2);
        }
        return be;
    }

    public static BarrierExpression concatBE(BarrierExpression BE1, BarrierExpression BE2, BarrierExpression BE3) {
        return BarrierExpression.concatBE(BarrierExpression.concatBE(BE1, BE2), BE3);
    }

    public static BarrierExpression repeatBE(BarrierExpression BE, IASTExpression cond, IASTStatement stmt) {
        BarrierExpression be = null;
        if (BE.isBot()) {
            be = BE;
        } else {
            be = new BarrierExpression(2, cond, stmt);
            be.setOperand1(BE);
        }
        return be;
    }

    public static BarrierExpression branchBE(BarrierExpression BE1, BarrierExpression BE2, IASTExpression cond, IASTStatement stmt) {
        BarrierExpression be = null;
        if (BE1.isBot() && BE2.isBot()) {
            be = BE2;
        } else {
            be = new BarrierExpression(3, cond, stmt);
            be.setOperand1(BE1);
            be.setOperand2(BE2);
        }
        return be;
    }

    public String prettyPrinter() {
        if (this.op_ != null && this.op_.operator == 1) {
            return String.valueOf(this.operand1_.prettyPrinter()) + "." + this.operand2_.prettyPrinter();
        }
        if (this.op_ != null && this.op_.operator == 2) {
            return "(" + this.operand1_.prettyPrinter() + ")*";
        }
        if (this.op_ != null && this.op_.operator == 3) {
            return "((" + this.operand1_.prettyPrinter() + ") | (" + this.operand2_.prettyPrinter() + "))";
        }
        if (this.type == 2) {
            Integer i = new Integer(this.barrierID);
            return i.toString();
        }
        if (this.type == 3) {
            return this.funcName_;
        }
        if (this.type == 1) {
            return "(\bot)";
        }
        return null;
    }

    public class BarrierExpressionOP {
        public static final int op_concat = 1;
        public static final int op_repeat = 2;
        public static final int op_branch = 3;
        private int operator;
        private IASTExpression condition_;
        private IASTStatement condStmt_;

        public BarrierExpressionOP() {
            this.operator = 0;
            this.condition_ = null;
        }

        public BarrierExpressionOP(int op, IASTExpression cond, IASTStatement stmt) {
            this.operator = op;
            this.condition_ = cond;
            this.condStmt_ = stmt;
        }

        public boolean withCondition() {
            return this.operator == 3 | this.operator == 2;
        }

        public int getOperator() {
            return this.operator;
        }

        public IASTExpression getCondition() {
            return this.condition_;
        }

        public IASTStatement getStatement() {
            return this.condStmt_;
        }
    }
}

