/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.analysis;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.core.resources.IResource;
import org.eclipse.ptp.pldt.common.util.SourceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarrierTable {
    protected Hashtable<String, List<BarrierInfo>> table_ = new Hashtable();
    protected int commCounter = 0;

    public Hashtable<String, List<BarrierInfo>> getTable() {
        return this.table_;
    }

    public boolean isEmpty() {
        return this.table_.isEmpty();
    }

    public BarrierInfo addBarrier(IASTFunctionCallExpression barE, int id, IResource res, String func) {
        BarrierInfo bar = new BarrierInfo(barE, id, res, func);
        if (this.table_.containsKey(bar.getComm())) {
            List<BarrierInfo> list = this.table_.get(bar.getComm());
            list.add(bar);
        } else {
            ArrayList<BarrierInfo> list = new ArrayList<BarrierInfo>();
            list.add(bar);
            this.table_.put(bar.getComm(), list);
        }
        return bar;
    }

    public int isBarrier(IASTFunctionCallExpression funcE) {
        IASTExpression funcname = funcE.getFunctionNameExpression();
        String signature = funcname.getRawSignature();
        if (!signature.equals("MPI_Barrier")) {
            return -1;
        }
        Enumeration<List<BarrierInfo>> e = this.table_.elements();
        while (e.hasMoreElements()) {
            ArrayList list = (ArrayList)e.nextElement();
            for (BarrierInfo bar : list) {
                if (bar.getFunc() != funcE) continue;
                return bar.getID();
            }
        }
        return -1;
    }

    public String getComm(int id) {
        Enumeration<List<BarrierInfo>> e = this.table_.elements();
        while (e.hasMoreElements()) {
            ArrayList list = (ArrayList)e.nextElement();
            for (BarrierInfo bar : list) {
                if (bar.getID() != id) continue;
                return bar.getComm();
            }
        }
        return null;
    }

    public BarrierInfo searchBarrierbyID(int id) {
        Enumeration<List<BarrierInfo>> e = this.table_.elements();
        while (e.hasMoreElements()) {
            ArrayList list = (ArrayList)e.nextElement();
            for (BarrierInfo bar : list) {
                if (bar.getID() != id) continue;
                return bar;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BarrierInfo {
        protected String comm_ = null;
        protected IASTFunctionCallExpression barrier_ = null;
        protected int id = -1;
        protected String fileName_ = null;
        protected SourceInfo sourceInfo_ = null;
        protected List<BarrierInfo> matchingSet_ = null;
        protected IResource resource_ = null;
        protected String enclosingFunc_ = null;

        public BarrierInfo(IASTFunctionCallExpression funcE, int id, IResource res, String func) {
            this.barrier_ = funcE;
            this.id = id;
            this.setComm();
            this.setSourceInfo();
            this.matchingSet_ = new ArrayList<BarrierInfo>();
            this.resource_ = res;
            this.enclosingFunc_ = func;
        }

        protected void setComm() {
            IASTExpression parameter = this.barrier_.getParameterExpression();
            if (parameter instanceof IASTUnaryExpression) {
                IASTUnaryExpression commExpr = (IASTUnaryExpression)parameter;
                if (commExpr.getOperand() instanceof IASTUnaryExpression) {
                    IASTUnaryExpression commOprd = (IASTUnaryExpression)commExpr.getOperand();
                    if (commOprd.getOperand() instanceof IASTLiteralExpression) {
                        IASTLiteralExpression comm = (IASTLiteralExpression)commOprd.getOperand();
                        this.comm_ = comm.toString();
                    } else if (commOprd.getOperand() instanceof IASTIdExpression) {
                        IASTIdExpression comm = (IASTIdExpression)commOprd.getOperand();
                        this.comm_ = comm.getName().toString();
                    } else if (commOprd.getOperand() instanceof IASTName) {
                        this.comm_ = commOprd.getOperand().toString();
                    } else {
                        this.comm_ = "COMM_" + BarrierTable.this.commCounter;
                        ++BarrierTable.this.commCounter;
                    }
                } else {
                    this.comm_ = "COMM_" + BarrierTable.this.commCounter;
                    ++BarrierTable.this.commCounter;
                }
            } else if (parameter instanceof IASTIdExpression) {
                IASTIdExpression idE = (IASTIdExpression)parameter;
                this.comm_ = idE.getName().toString();
                if (!this.comm_.equals("MPI_COMM_WORLD")) {
                    this.comm_ = "COMM_" + BarrierTable.this.commCounter;
                    ++BarrierTable.this.commCounter;
                }
            } else {
                this.comm_ = "COMM_" + BarrierTable.this.commCounter;
                ++BarrierTable.this.commCounter;
            }
        }

        protected void setSourceInfo() {
            IASTExpression funcNameE = this.barrier_.getFunctionNameExpression();
            IASTNodeLocation[] locations = funcNameE.getNodeLocations();
            if (locations.length == 1) {
                IASTFileLocation astFileLocation = null;
                if (locations[0] instanceof IASTFileLocation) {
                    astFileLocation = (IASTFileLocation)locations[0];
                    this.fileName_ = astFileLocation.getFileName();
                    this.sourceInfo_ = new SourceInfo();
                    this.sourceInfo_.setStartingLine(astFileLocation.getStartingLineNumber());
                    this.sourceInfo_.setStart(astFileLocation.getNodeOffset());
                    this.sourceInfo_.setEnd(astFileLocation.getNodeOffset() + astFileLocation.getNodeLength());
                    this.sourceInfo_.setConstructType(1);
                }
            }
        }

        public String getComm() {
            return this.comm_;
        }

        public IASTFunctionCallExpression getFunc() {
            return this.barrier_;
        }

        public int getID() {
            return this.id;
        }

        public String getFileName() {
            return this.fileName_;
        }

        public SourceInfo getSourceInfo() {
            return this.sourceInfo_;
        }

        public List<BarrierInfo> getMatchingSet() {
            return this.matchingSet_;
        }

        public IResource getResource() {
            return this.resource_;
        }

        public String getEnclosingFunc() {
            return this.enclosingFunc_;
        }
    }
}

