/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.debug.cdi.ui.pages;

import java.util.Observable;
import org.eclipse.cdt.debug.mi.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.ComboDialogField;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.StringDialogField;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.cell.debug.CellDebugPlugin;
import org.eclipse.ptp.cell.debug.cdi.ui.pages.PagesMessages;
import org.eclipse.ptp.cell.debug.launch.CellDebugRemoteDebugger;
import org.eclipse.ptp.cell.debug.launch.ICellDebugLaunchConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AdvancedTCPSettingsBlock
extends Observable {
    private static final String DEFAULT_PORT_NUMBER = "10000";
    private static final String DEFAULT_REMOTEDBGCONFIG_KEY = "Cell PPU gdbserver";
    private String[] fRemoteDBGconfigs;
    private Shell fShell;
    private StringDialogField fPortNumberField;
    private Button fFlag;
    private ComboDialogField fConfigCombo;
    private StringDialogField fGDBServerBinary;
    private Control fControl;
    private String fErrorMessage = null;
    private boolean init = true;

    public AdvancedTCPSettingsBlock() {
        CellDebugPlugin plugin = CellDebugPlugin.getDefault();
        this.fRemoteDBGconfigs = plugin.getRemoteDbgNames();
        this.fConfigCombo = this.createConfigCombo();
        this.fGDBServerBinary = this.createGDBServerBinary();
        this.fPortNumberField = this.createPortNumberField();
    }

    public void createBlock(Composite parent) {
        this.fShell = parent.getShell();
        Composite comp = ControlFactory.createCompositeEx((Composite)parent, (int)2, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        ((GridLayout)comp.getLayout()).marginHeight = 0;
        ((GridLayout)comp.getLayout()).marginWidth = 0;
        comp.setFont(parent.getFont());
        PixelConverter converter = new PixelConverter((Control)comp);
        this.fPortNumberField.doFillIntoGrid(comp, 2);
        ((GridData)this.fPortNumberField.getTextControl(null).getLayoutData()).horizontalAlignment = 1;
        LayoutUtil.setWidthHint((Control)this.fPortNumberField.getTextControl(null), (int)converter.convertWidthInCharsToPixels(10));
        this.fFlag = this.createFlag(comp);
        this.fConfigCombo.doFillIntoGrid(comp, 2);
        ((GridData)this.fConfigCombo.getComboControl(null).getLayoutData()).horizontalAlignment = 1;
        LayoutUtil.setWidthHint((Control)this.fConfigCombo.getComboControl(null), (int)converter.convertWidthInCharsToPixels(30));
        this.fGDBServerBinary.doFillIntoGrid(comp, 2);
        ((GridData)this.fGDBServerBinary.getTextControl(null).getLayoutData()).horizontalAlignment = 1;
        LayoutUtil.setWidthHint((Control)this.fGDBServerBinary.getTextControl(null), (int)converter.convertWidthInCharsToPixels(20));
        this.setControl((Control)comp);
    }

    protected Shell getShell() {
        return this.fShell;
    }

    public void dispose() {
        this.deleteObservers();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.init = true;
        this.initializeFlag(configuration);
        this.initializeConfigCombo(configuration);
        this.flagChanged();
        this.initializePortNumber(configuration);
        this.init = false;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        String remoteCfg;
        try {
            remoteCfg = configuration.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_CFG, DEFAULT_REMOTEDBGCONFIG_KEY);
        }
        catch (CoreException coreException) {
            remoteCfg = DEFAULT_REMOTEDBGCONFIG_KEY;
        }
        CellDebugRemoteDebugger dbgCfg = CellDebugPlugin.getDefault().getRemoteDbgConfigByName(remoteCfg);
        configuration.setAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH, 1);
        configuration.setAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_CFG, dbgCfg.getName());
        configuration.setAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_BINARY, dbgCfg.getDebugConfig().getDbgBinaryName());
        configuration.setAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_PORT, dbgCfg.getDebugConfig().getDbgPort());
        configuration.setAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_DBGID, dbgCfg.getDebuggerId());
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fPortNumberField != null) {
            configuration.setAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_PORT, this.fPortNumberField.getText().trim());
        }
        CellDebugRemoteDebugger dbgCfg = CellDebugPlugin.getDefault().getRemoteDbgConfigByName(this.fRemoteDBGconfigs[this.fConfigCombo.getSelectionIndex()]);
        configuration.setAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH, this.fFlag.getSelection() ? 1 : 0);
        configuration.setAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_CFG, dbgCfg.getName());
        configuration.setAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_BINARY, this.fGDBServerBinary.getText().trim());
        configuration.setAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_DBGID, dbgCfg.getDebuggerId());
    }

    private Button createFlag(Composite parent) {
        Button field = ControlFactory.createCheckBox((Composite)parent, (String)PagesMessages.getString("AdvancedTCPSettingsBlock.0"));
        field.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AdvancedTCPSettingsBlock.this.init) {
                    AdvancedTCPSettingsBlock.this.flagChanged();
                }
            }
        });
        ControlFactory.createEmptySpace((Composite)parent);
        return field;
    }

    private ComboDialogField createConfigCombo() {
        ComboDialogField field = new ComboDialogField(12);
        field.setLabelText(PagesMessages.getString("AdvancedTCPSettingsBlock.1"));
        field.setItems(this.fRemoteDBGconfigs);
        field.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField f) {
                if (!AdvancedTCPSettingsBlock.this.init) {
                    AdvancedTCPSettingsBlock.this.configComboChanged();
                }
            }
        });
        return field;
    }

    private StringDialogField createGDBServerBinary() {
        StringDialogField field = new StringDialogField();
        field.setLabelText(PagesMessages.getString("AdvancedTCPSettingsBlock.2"));
        field.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField f) {
                if (!AdvancedTCPSettingsBlock.this.init) {
                    AdvancedTCPSettingsBlock.this.gdbServerBinaryChanged();
                }
            }
        });
        return field;
    }

    private StringDialogField createPortNumberField() {
        StringDialogField field = new StringDialogField();
        field.setLabelText(PagesMessages.getString("AdvancedTCPSettingsBlock.4"));
        field.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField f) {
                AdvancedTCPSettingsBlock.this.portNumberFieldChanged();
            }
        });
        return field;
    }

    protected void portNumberFieldChanged() {
        this.updateErrorMessage();
        this.setChanged();
        this.notifyObservers();
    }

    protected void flagChanged() {
        if (!this.fFlag.getSelection()) {
            this.fConfigCombo.setEnabled(false);
            this.fGDBServerBinary.setEnabled(false);
        } else {
            this.fConfigCombo.setEnabled(true);
            this.fGDBServerBinary.setEnabled(true);
        }
        this.updateErrorMessage();
        this.setChanged();
        this.notifyObservers();
    }

    protected void configComboChanged() {
        int index = this.fConfigCombo.getSelectionIndex();
        if (index >= 0) {
            CellDebugRemoteDebugger dbgCfg = CellDebugPlugin.getDefault().getRemoteDbgConfigByName(this.fRemoteDBGconfigs[index]);
            this.fGDBServerBinary.setText(dbgCfg.getDebugConfig().getDbgBinaryName());
            this.updateErrorMessage();
            this.setChanged();
            this.notifyObservers();
        }
    }

    protected void gdbServerBinaryChanged() {
        this.updateErrorMessage();
        this.setChanged();
        this.notifyObservers();
    }

    private void initializePortNumber(ILaunchConfiguration configuration) {
        if (this.fPortNumberField != null) {
            try {
                this.fPortNumberField.setText(configuration.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_PORT, DEFAULT_PORT_NUMBER));
            }
            catch (CoreException coreException) {}
        }
    }

    private void initializeFlag(ILaunchConfiguration configuration) {
        try {
            this.fFlag.setSelection(configuration.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH, 1) == 1);
        }
        catch (CoreException coreException) {
            this.fFlag.setSelection(true);
        }
    }

    private void initializeConfigCombo(ILaunchConfiguration configuration) {
        String current;
        int i = 0;
        try {
            current = configuration.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_CFG, DEFAULT_REMOTEDBGCONFIG_KEY);
        }
        catch (CoreException coreException) {
            current = DEFAULT_REMOTEDBGCONFIG_KEY;
        }
        CellDebugRemoteDebugger dbgCfg = CellDebugPlugin.getDefault().getRemoteDbgConfigByName(current);
        String[] items = this.fConfigCombo.getItems();
        i = 0;
        while (i < items.length) {
            if (items[i].equals(current)) break;
            ++i;
        }
        this.fConfigCombo.selectItem(i);
        try {
            this.fGDBServerBinary.setText(configuration.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_BINARY, dbgCfg.getDebugConfig().getDbgBinaryName()));
        }
        catch (CoreException coreException) {
            this.fGDBServerBinary.setText(dbgCfg.getDebugConfig().getDbgBinaryName());
        }
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void setControl(Control control) {
        this.fControl = control;
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        this.updateErrorMessage();
        return this.getErrorMessage() == null;
    }

    private void updateErrorMessage() {
        this.setErrorMessage(null);
        if (this.fPortNumberField != null) {
            if (this.fPortNumberField.getText().trim().length() == 0) {
                this.setErrorMessage(PagesMessages.getString("AdvancedTCPSettingsBlock.5"));
            } else if (!this.portNumberIsValid(this.fPortNumberField.getText().trim())) {
                this.setErrorMessage(PagesMessages.getString("AdvancedTCPSettingsBlock.6"));
            }
        }
        if (this.getErrorMessage() == null && this.fFlag.getSelection()) {
            if (this.fGDBServerBinary.getText() != null) {
                if (this.fGDBServerBinary.getText().trim().length() != 0) {
                    if (!this.gdbServerBinaryIsValid()) {
                        this.setErrorMessage(PagesMessages.getString("AdvancedTCPSettingsBlock.3"));
                    }
                } else {
                    this.setErrorMessage(PagesMessages.getString("AdvancedTCPSettingsBlock.3"));
                }
            } else {
                this.setErrorMessage(PagesMessages.getString("AdvancedTCPSettingsBlock.3"));
            }
        }
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    private void setErrorMessage(String string) {
        this.fErrorMessage = string;
    }

    private boolean portNumberIsValid(String portNumber) {
        try {
            int port = Integer.parseInt(portNumber);
            return port > 0 && port <= 65535;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean gdbServerBinaryIsValid() {
        return true;
    }
}

