/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.pe.core.rmsystem;

import org.eclipse.ptp.rm.ibm.pe.core.rmsystem.PEResourceManagerFactory;
import org.eclipse.ptp.rm.remote.core.AbstractRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.ui.IMemento;

public final class PEResourceManagerConfiguration
extends AbstractRemoteResourceManagerConfiguration {
    private static final String TAG_USE_LOADLEVELER = "PE_UseLoadLeveler";
    private static final String TAG_DEBUG_LEVEL = "PE_DebugLevel";
    private static final String TAG_RUN_MINIPROXY = "PE_RunMiniproxy";
    private static final String TAG_SUSPEND_PROXY = "PE_SuspendProxy";
    private static final String TAG_LOADLEVELER_MODE = "PE_LoadLevelerMode";
    private static final String TAG_MIN_NODE_POLL_INTERVAL = "PE_NodeMinPollInterval";
    private static final String TAG_MAX_NODE_POLL_INTERVAL = "PE_NodeMaxPollInterval";
    private static final String TAG_JOB_POLL_INTERVAL = "PE_JobPollInterval";
    private static final String TAG_LIBRARY_OVERRIDE = "PE_LibraryOverride";
    private String useLoadLeveler;
    private String runMiniproxy;
    private String debugLevel;
    private String suspendProxy;
    private String loadLevelerMode;
    private String nodeMinPollInterval;
    private String nodeMaxPollInterval;
    private String jobPollInterval;
    private String libraryOverride;

    public static IResourceManagerConfiguration load(PEResourceManagerFactory factory, IMemento memento) {
        AbstractRemoteResourceManagerConfiguration.RemoteConfig remoteConfig = PEResourceManagerConfiguration.loadRemote((IResourceManagerFactory)factory, (IMemento)memento);
        String useLoadLeveler = memento.getString(TAG_USE_LOADLEVELER);
        String runMiniproxy = memento.getString(TAG_RUN_MINIPROXY);
        String debugLevel = memento.getString(TAG_DEBUG_LEVEL);
        String suspendProxy = memento.getString(TAG_SUSPEND_PROXY);
        String nodeMinPollInterval = memento.getString(TAG_MIN_NODE_POLL_INTERVAL);
        String nodeMaxPollInterval = memento.getString(TAG_MAX_NODE_POLL_INTERVAL);
        String jobPollInterval = memento.getString(TAG_JOB_POLL_INTERVAL);
        String libraryOverride = memento.getString(TAG_LIBRARY_OVERRIDE);
        String loadLevelerMode = memento.getString(TAG_LOADLEVELER_MODE);
        PEResourceManagerConfiguration config = new PEResourceManagerConfiguration(factory, remoteConfig, useLoadLeveler, runMiniproxy, debugLevel, suspendProxy, loadLevelerMode, libraryOverride, nodeMinPollInterval, nodeMaxPollInterval, jobPollInterval);
        return config;
    }

    public PEResourceManagerConfiguration(PEResourceManagerFactory factory, AbstractRemoteResourceManagerConfiguration.RemoteConfig remoteConfig, String useLoadLeveler, String runMiniproxy, String debugLevel, String suspendProxy, String loadLevelerMode, String libraryOverride, String nodeMinPollInterval, String nodeMaxPollInterval, String jobPollInterval) {
        super(remoteConfig, (IResourceManagerFactory)factory);
        this.useLoadLeveler = useLoadLeveler;
        this.runMiniproxy = runMiniproxy;
        this.debugLevel = debugLevel;
        this.suspendProxy = suspendProxy;
        this.loadLevelerMode = loadLevelerMode;
        this.libraryOverride = libraryOverride;
        this.nodeMinPollInterval = nodeMinPollInterval;
        this.nodeMaxPollInterval = nodeMaxPollInterval;
        this.jobPollInterval = jobPollInterval;
    }

    public PEResourceManagerConfiguration(PEResourceManagerFactory factory) {
        this(factory, new AbstractRemoteResourceManagerConfiguration.RemoteConfig(), "N", "Y", "None", "N", "d", "", "", "", "");
        this.setDefaultNameAndDesc();
    }

    public Object clone() {
        AbstractResourceManagerConfiguration.CommonConfig commonConf = new AbstractResourceManagerConfiguration.CommonConfig(this.getName(), this.getDescription(), this.getUniqueName());
        AbstractRemoteResourceManagerConfiguration.RemoteConfig remoteConf = new AbstractRemoteResourceManagerConfiguration.RemoteConfig(commonConf, this.getRemoteServicesId(), this.getConnectionName(), this.getProxyServerPath(), this.getLocalAddress(), this.getInvocationOptionsStr(), this.getOptions());
        return new PEResourceManagerConfiguration((PEResourceManagerFactory)this.getFactory(), remoteConf, this.getUseLoadLeveler(), this.getRunMiniproxy(), this.getDebugLevel(), this.getSuspendProxy(), this.getLoadLevelerMode(), this.getLibraryOverride(), this.getNodeMinPollInterval(), this.getNodeMaxPollInterval(), this.getJobPollInterval());
    }

    public void setDefaultNameAndDesc() {
        String name = "PE";
        String conn = this.getConnectionName();
        if (conn != null && !conn.equals("")) {
            name = String.valueOf(name) + "@" + conn;
        }
        this.setName(name);
        this.setDescription("PE Resource Manager");
    }

    public String getUseLoadLeveler() {
        return this.useLoadLeveler;
    }

    public String getRunMiniproxy() {
        return this.runMiniproxy;
    }

    public String getDebugLevel() {
        return this.debugLevel;
    }

    public String getSuspendProxy() {
        return this.suspendProxy;
    }

    public void setUseLoadLeveler(String useLoadLeveler) {
        this.useLoadLeveler = useLoadLeveler;
    }

    public void setRunMiniproxy(String runMiniproxy) {
        this.runMiniproxy = runMiniproxy;
    }

    public void setDebugLevel(String debugLevel) {
        this.debugLevel = debugLevel;
    }

    public void setSuspendProxy(String suspendProxy) {
        this.suspendProxy = suspendProxy;
    }

    public String getLoadLevelerMode() {
        return this.loadLevelerMode;
    }

    public void setLoadLevelerMode(String loadLevelerMode) {
        this.loadLevelerMode = loadLevelerMode;
    }

    public String getNodeMinPollInterval() {
        return this.nodeMinPollInterval;
    }

    public void setNodeMinPollInterval(String nodeMinPollInterval) {
        this.nodeMinPollInterval = nodeMinPollInterval;
    }

    public String getNodeMaxPollInterval() {
        return this.nodeMaxPollInterval;
    }

    public void setNodeMaxPollInterval(String nodeMaxPollInterval) {
        this.nodeMaxPollInterval = nodeMaxPollInterval;
    }

    public String getJobPollInterval() {
        return this.jobPollInterval;
    }

    public void setJobPollInterval(String jobPollInterval) {
        this.jobPollInterval = jobPollInterval;
    }

    public String getLibraryOverride() {
        return this.libraryOverride;
    }

    public void setLibraryOverride(String libraryOverride) {
        this.libraryOverride = libraryOverride;
    }
}

