/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.alf.ui.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.cell.alf.ui.Messages;
import org.eclipse.ptp.cell.alf.ui.core.ALFBuffer;
import org.eclipse.ptp.cell.alf.ui.debug.Debug;
import org.eclipse.ptp.cell.alf.ui.wizard.ALFWizard;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ALFWizardCreationAction
implements IRunnableWithProgress {
    private static String PATH_SEPERATOR = "/";
    private static String SPACE = " ";
    private ALFWizard wizard;
    private IPath projectLocation;
    private String projectName;
    private int stackSize;
    private int expAccelNum;
    private int partitionMethod;
    private ArrayList buffers;
    private boolean is64bit;

    public ALFWizardCreationAction(ALFWizard wizard, IPath projectLocation, String projectName, int stackSize, int expAccelNum, int partitionMethod, ArrayList buffers, boolean is64bit) {
        this.wizard = wizard;
        this.projectLocation = projectLocation;
        this.projectName = projectName;
        this.stackSize = stackSize;
        this.expAccelNum = expAccelNum;
        this.partitionMethod = partitionMethod;
        this.buffers = buffers;
        this.is64bit = is64bit;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_CREATE_ACTION);
        boolean wasCanceled = false;
        File tmpDir = null;
        File xmlParameterFile = null;
        IProject ppuProject = null;
        IProject spuProject = null;
        IProject libraryProject = null;
        try {
            try {
                IProjectDescription projectDescription;
                String date = this.getDate();
                monitor.beginTask(Messages.ALFWizardCreationAction_mainTask, 9);
                monitor.setTaskName(Messages.ALFWizardCreationAction_taskName);
                monitor.subTask(Messages.ALFWizardCreationAction_subTask1);
                String tmpDirPath = String.valueOf(Messages.ALFWizardCreationAction_tmpDirLocation) + date;
                tmpDir = new File(tmpDirPath);
                Debug.POLICY.trace(Debug.DEBUG_CREATE_ACTION, "Create tmp dir: ''{0}''", new Object[]{tmpDir.toString()});
                if (!tmpDir.exists()) {
                    tmpDir.mkdir();
                }
                Debug.POLICY.trace(Debug.DEBUG_CREATE_ACTION, "Create the parameter XML file.");
                Document xmlParameterFileDocument = this.createXMLParameterDocument(tmpDir.getAbsolutePath(), date);
                xmlParameterFile = this.createXMLParameterFile(xmlParameterFileDocument, tmpDir);
                if (monitor.isCanceled()) {
                    throw new InterruptedException(Messages.ALFWizardCreationAction_canceled);
                }
                Debug.POLICY.trace(Debug.DEBUG_CREATE_ACTION, "Call the code generator and pass it the parameter description file.");
                monitor.worked(1);
                monitor.subTask(Messages.ALFWizardCreationAction_subTask2);
                String codeGenLocation = Messages.ALFWizardCreationAction_codeGeneratorCommand;
                File codeGenFile = new File(Messages.ALFWizardCreationAction_codeGeneratorCommand);
                if (!codeGenFile.exists()) {
                    codeGenLocation = this.wizard.queryPathLocation(Messages.ALFWizardCreationAction_queryTitle, Messages.ALFWizardCreationAction_queryCodeGenPath, Messages.ALFWizardCreationAction_codeGeneratorCommand);
                }
                if (codeGenLocation == null) {
                    throw new InvocationTargetException(new Exception(), Messages.ALFWizardCreationAction_errorCallingCodeGenMsg);
                }
                Process codeGen = Runtime.getRuntime().exec(String.valueOf(codeGenLocation) + SPACE + Messages.ALFWizardCreationAction_codeGeneratorOptions + SPACE + xmlParameterFile.getAbsolutePath());
                codeGen.waitFor();
                if (monitor.isCanceled()) {
                    throw new InterruptedException(Messages.ALFWizardCreationAction_canceled);
                }
                monitor.worked(1);
                Debug.POLICY.trace(Debug.DEBUG_CREATE_ACTION, "Create the host (PPU), PPU Shared Library, and accelerator (SPU) projects.");
                Debug.POLICY.trace(Debug.DEBUG_CREATE_ACTION, "Create the PPU executable project.");
                monitor.subTask(Messages.ALFWizardCreationAction_subTask3);
                ppuProject = this.createProject("ppu_" + this.projectName, "cell.managedbuild.target.cell.ppu.exe");
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new InterruptedException(Messages.ALFWizardCreationAction_canceled);
                }
                Debug.POLICY.trace(Debug.DEBUG_CREATE_ACTION, "Create the PPU shared library project.");
                monitor.subTask(Messages.ALFWizardCreationAction_subTask4);
                libraryProject = this.createProject("lib" + this.projectName, "cell.managedbuild.target.cell.ppu.so");
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new InterruptedException(Messages.ALFWizardCreationAction_canceled);
                }
                Debug.POLICY.trace(Debug.DEBUG_CREATE_ACTION, "Create the SPU executable project.");
                monitor.subTask(Messages.ALFWizardCreationAction_subTask5);
                spuProject = this.createProject("spu_" + this.projectName, "cell.managedbuild.target.cell.spu.exe");
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new InterruptedException(Messages.ALFWizardCreationAction_canceled);
                }
                Debug.POLICY.trace(Debug.DEBUG_CREATE_ACTION, "Import the source and header files into the projects.");
                monitor.subTask(Messages.ALFWizardCreationAction_subTask6);
                this.importFiles(monitor, tmpDirPath, ppuProject, spuProject);
                monitor.worked(1);
                Debug.POLICY.trace(Debug.DEBUG_CREATE_ACTION, "Configure the projects.");
                Debug.POLICY.trace(Debug.DEBUG_CREATE_ACTION, "Configure SPU executable project.");
                monitor.subTask(Messages.ALFWizardCreationAction_subTask7);
                this.configureSPUProject(spuProject, ppuProject.getName());
                try {
                    spuProject.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, (Throwable)e);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException(Messages.ALFWizardCreationAction_canceled);
                }
                monitor.worked(1);
                Debug.POLICY.trace(Debug.DEBUG_CREATE_ACTION, "Configure PPU shared library project.");
                monitor.subTask(Messages.ALFWizardCreationAction_subTask8);
                try {
                    projectDescription = libraryProject.getDescription();
                    projectDescription.setReferencedProjects(new IProject[]{spuProject});
                    libraryProject.setDescription(projectDescription, null);
                }
                catch (Exception e) {
                    Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, (Throwable)e);
                    Debug.POLICY.logError((Throwable)e);
                }
                this.configureSharedLibraryProject32bit(libraryProject, spuProject.getName());
                this.configureSharedLibraryProject64bit(libraryProject, spuProject.getName());
                try {
                    libraryProject.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, (Throwable)e);
                    Debug.POLICY.logError((Throwable)e);
                }
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new InterruptedException(Messages.ALFWizardCreationAction_canceled);
                }
                Debug.POLICY.trace(Debug.DEBUG_CREATE_ACTION, "Configure the PPU executable project.");
                monitor.subTask(Messages.ALFWizardCreationAction_subTask9);
                try {
                    projectDescription = ppuProject.getDescription();
                    projectDescription.setReferencedProjects(new IProject[]{libraryProject});
                    ppuProject.setDescription(projectDescription, null);
                }
                catch (Exception e) {
                    Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, (Throwable)e);
                }
                this.configurePPUProject32bit(ppuProject, libraryProject.getName(), spuProject.getName());
                this.configurePPUProject64bit(ppuProject, libraryProject.getName(), spuProject.getName());
                try {
                    ppuProject.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, (Throwable)e);
                    Debug.POLICY.logError((Throwable)e);
                }
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new InterruptedException(Messages.ALFWizardCreationAction_canceled);
                }
            }
            catch (FactoryConfigurationError e) {
                Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION, (Throwable)e);
                throw new InvocationTargetException(e, Messages.ALFWizardCreationAction_errorCreatingParamFileMsg);
            }
            catch (ParserConfigurationException e) {
                Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION, (Throwable)e);
                throw new InvocationTargetException(e, Messages.ALFWizardCreationAction_errorCreatingParamFileMsg);
            }
            catch (TransformerException e) {
                Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION, (Throwable)e);
                throw new InvocationTargetException(e, Messages.ALFWizardCreationAction_errorCreatingParamFileMsg);
            }
            catch (IOException e) {
                Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION, (Throwable)e);
                throw new InvocationTargetException(e, Messages.ALFWizardCreationAction_errorCallingCodeGenMsg);
            }
            catch (InterruptedException e) {
                wasCanceled = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Debug.POLICY.trace(Debug.DEBUG_CREATE_ACTION, "Removed tmp dir: ''{0}''", new Object[]{tmpDir.toString()});
            if (xmlParameterFile != null) {
                xmlParameterFile.delete();
            }
            if (tmpDir != null) {
                this.deleteDir(tmpDir);
            }
            if (wasCanceled) {
                if (ppuProject != null) {
                    try {
                        ppuProject.delete(true, true, null);
                    }
                    catch (CoreException e) {
                        Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION, (Throwable)e);
                        Debug.POLICY.logError((Throwable)e);
                    }
                }
                if (spuProject != null) {
                    try {
                        spuProject.delete(true, true, null);
                    }
                    catch (CoreException e) {
                        Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION, (Throwable)e);
                        Debug.POLICY.logError((Throwable)e);
                    }
                }
                if (libraryProject != null) {
                    try {
                        libraryProject.delete(true, true, null);
                    }
                    catch (CoreException e) {
                        Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION, (Throwable)e);
                        Debug.POLICY.logError((Throwable)e);
                    }
                }
            }
            throw throwable;
        }
        Debug.POLICY.trace(Debug.DEBUG_CREATE_ACTION, "Removed tmp dir: ''{0}''", new Object[]{tmpDir.toString()});
        if (xmlParameterFile != null) {
            xmlParameterFile.delete();
        }
        if (tmpDir != null) {
            this.deleteDir(tmpDir);
        }
        if (wasCanceled) {
            if (ppuProject != null) {
                try {
                    ppuProject.delete(true, true, null);
                }
                catch (CoreException e) {
                    Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION, (Throwable)e);
                    Debug.POLICY.logError((Throwable)e);
                }
            }
            if (spuProject != null) {
                try {
                    spuProject.delete(true, true, null);
                }
                catch (CoreException e) {
                    Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION, (Throwable)e);
                    Debug.POLICY.logError((Throwable)e);
                }
            }
            if (libraryProject != null) {
                try {
                    libraryProject.delete(true, true, null);
                }
                catch (CoreException e) {
                    Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION, (Throwable)e);
                    Debug.POLICY.logError((Throwable)e);
                }
            }
        }
        Debug.POLICY.exit(Debug.DEBUG_CREATE_ACTION);
    }

    private boolean configurePPUProject32bit(IProject ppuProject, String libProjectName, String spuProjectName) {
        Debug.POLICY.enter(Debug.DEBUG_CREATE_ACTION_MORE, new Object[]{ppuProject, libProjectName, spuProjectName});
        boolean saveBuildStatus = false;
        IConfiguration[] configs = ManagedBuildManager.getBuildInfo((IResource)ppuProject).getManagedProject().getConfigurations();
        IConfiguration configuration = null;
        int i = 0;
        while (i < configs.length) {
            if (configs[i].getId().startsWith("cell.managedbuild.config.cell.ppu.gnu32.exe.debug")) {
                configuration = configs[i];
                break;
            }
            ++i;
        }
        ManagedBuildManager.performValueHandlerEvent(configuration, (int)1, (boolean)true);
        IToolChain toolChain = configuration.getToolChain();
        ITool linkerTool = toolChain.getToolsBySuperClassId("cell.managedbuild.tool.cell.ppu.gnu32.c.linker")[0];
        IOption libraryOption = linkerTool.getOptionBySuperClassId("cell.ppu.gnu.c.linker.option.libs");
        IOption librarySearchPathOption = linkerTool.getOptionBySuperClassId("gnu.c.link.option.paths");
        ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)linkerTool, (IOption)libraryOption, (String[])new String[]{"dl", "pthread", "spe2", "alf"});
        ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)linkerTool, (IOption)librarySearchPathOption, (String[])new String[]{"/opt/cell/sysroot/usr/lib"});
        ITool compilerTool = toolChain.getToolsBySuperClassId("cell.managedbuild.tool.cell.ppu.gnu32.c.compiler.debug")[0];
        IOption includePathOption = compilerTool.getOptionBySuperClassId("gnu.c.compiler.option.include.paths");
        ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)compilerTool, (IOption)includePathOption, (String[])new String[]{"/opt/cell/sysroot/usr/include", "/opt/cell/sysroot/opt/cell/sdk/usr/include"});
        saveBuildStatus = ManagedBuildManager.saveBuildInfo((IProject)ppuProject, (boolean)true);
        IManagedBuildInfo bi = ManagedBuildManager.getBuildInfo((IResource)ppuProject);
        if (bi != null & bi instanceof ManagedBuildInfo) {
            ((ManagedBuildInfo)bi).initializePathEntries();
        }
        if (!this.is64bit) {
            ManagedBuildManager.setDefaultConfiguration((IProject)ppuProject, (IConfiguration)configuration);
            ManagedBuildManager.setSelectedConfiguration((IProject)ppuProject, (IConfiguration)configuration);
        }
        ManagedBuildManager.performValueHandlerEvent((IConfiguration)configuration, (int)4, (boolean)true);
        if (!saveBuildStatus) {
            Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, "Failed: {0}.", new Object[]{"configurePPUProject32bit"});
            this.wizard.logWarningMessage(Messages.ALFWizardCreationAction_queryTitle, Messages.ALFWizardCreationAction_errorConfiguringPpuProject);
        }
        Debug.POLICY.exit(Debug.DEBUG_CREATE_ACTION_MORE, (Object)saveBuildStatus);
        return saveBuildStatus;
    }

    private boolean configurePPUProject64bit(IProject ppuProject, String libProjectName, String spuProjectName) {
        Debug.POLICY.enter(Debug.DEBUG_CREATE_ACTION_MORE, new Object[]{ppuProject, libProjectName, spuProjectName});
        boolean saveBuildStatus = false;
        IConfiguration[] configs = ManagedBuildManager.getBuildInfo((IResource)ppuProject).getManagedProject().getConfigurations();
        IConfiguration configuration = null;
        int i = 0;
        while (i < configs.length) {
            if (configs[i].getId().startsWith("cell.managedbuild.config.cell.ppu.gnu64.exe.debug")) {
                configuration = configs[i];
                break;
            }
            ++i;
        }
        ManagedBuildManager.performValueHandlerEvent(configuration, (int)1, (boolean)true);
        IToolChain toolChain = configuration.getToolChain();
        ITool linkerTool = toolChain.getToolsBySuperClassId("cell.managedbuild.tool.cell.ppu.gnu64.c.linker")[0];
        IOption libraryOption = linkerTool.getOptionBySuperClassId("cell.ppu.gnu.c.linker.option.libs");
        IOption librarySearchPathOption = linkerTool.getOptionBySuperClassId("gnu.c.link.option.paths");
        ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)linkerTool, (IOption)libraryOption, (String[])new String[]{"dl", "pthread", "spe2", "alf"});
        ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)linkerTool, (IOption)librarySearchPathOption, (String[])new String[]{"/opt/cell/sysroot/usr/lib64"});
        ITool compilerTool = toolChain.getToolsBySuperClassId("cell.managedbuild.tool.cell.ppu.gnu64.c.compiler.debug")[0];
        IOption includePathOption = compilerTool.getOptionBySuperClassId("gnu.c.compiler.option.include.paths");
        ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)compilerTool, (IOption)includePathOption, (String[])new String[]{"/opt/cell/sysroot/usr/include", "/opt/cell/sysroot/opt/cell/sdk/usr/include"});
        IOption definedSymbolOption = compilerTool.getOptionBySuperClassId("gnu.c.compiler.option.preprocessor.def.symbols");
        ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)compilerTool, (IOption)definedSymbolOption, (String[])new String[]{"__64BIT__"});
        saveBuildStatus = ManagedBuildManager.saveBuildInfo((IProject)ppuProject, (boolean)true);
        IManagedBuildInfo bi = ManagedBuildManager.getBuildInfo((IResource)ppuProject);
        if (bi != null & bi instanceof ManagedBuildInfo) {
            ((ManagedBuildInfo)bi).initializePathEntries();
        }
        if (this.is64bit) {
            ManagedBuildManager.setDefaultConfiguration((IProject)ppuProject, (IConfiguration)configuration);
            ManagedBuildManager.setSelectedConfiguration((IProject)ppuProject, (IConfiguration)configuration);
        }
        ManagedBuildManager.performValueHandlerEvent((IConfiguration)configuration, (int)4, (boolean)true);
        if (!saveBuildStatus) {
            Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, "Failed: {0}.", new Object[]{"configurePPUProject64bit"});
            this.wizard.logWarningMessage(Messages.ALFWizardCreationAction_queryTitle, Messages.ALFWizardCreationAction_errorConfiguringPpuProject);
        }
        Debug.POLICY.exit(Debug.DEBUG_CREATE_ACTION_MORE, (Object)saveBuildStatus);
        return saveBuildStatus;
    }

    private boolean configureSharedLibraryProject32bit(IProject libProject, String spuProjectName) {
        Debug.POLICY.enter(Debug.DEBUG_CREATE_ACTION_MORE, new Object[]{libProject, spuProjectName});
        boolean saveBuildStatus = false;
        IConfiguration[] configs = ManagedBuildManager.getBuildInfo((IResource)libProject).getManagedProject().getConfigurations();
        IConfiguration configuration = null;
        int i = 0;
        while (i < configs.length) {
            if (configs[i].getId().startsWith("cell.managedbuild.config.cell.ppu.gnu32.so.debug")) {
                configuration = configs[i];
                break;
            }
            ++i;
        }
        ManagedBuildManager.performValueHandlerEvent(configuration, (int)1, (boolean)true);
        IToolChain toolChain = configuration.getToolChain();
        ITool embedSpuTool = toolChain.getToolsBySuperClassId("cell.managedbuild.tool.cell.ppu.gnu32.embedspu")[0];
        IOption embedSpuInputOption = embedSpuTool.getOptionBySuperClassId("cell.ppu.gnu.embedspu.option.inputs");
        ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)embedSpuTool, (IOption)embedSpuInputOption, (String[])new String[]{"\"${workspace_loc:/" + spuProjectName + "/spu-gnu-debug/" + spuProjectName + "}\""});
        saveBuildStatus = ManagedBuildManager.saveBuildInfo((IProject)libProject, (boolean)true);
        IManagedBuildInfo bi = ManagedBuildManager.getBuildInfo((IResource)libProject);
        if (bi != null & bi instanceof ManagedBuildInfo) {
            ((ManagedBuildInfo)bi).initializePathEntries();
        }
        if (!this.is64bit) {
            ManagedBuildManager.setDefaultConfiguration((IProject)libProject, (IConfiguration)configuration);
            ManagedBuildManager.setSelectedConfiguration((IProject)libProject, (IConfiguration)configuration);
        }
        ManagedBuildManager.performValueHandlerEvent((IConfiguration)configuration, (int)4, (boolean)true);
        if (!saveBuildStatus) {
            Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, "Failed: {0}.", new Object[]{"configureSharedLibraryProject32bit"});
            this.wizard.logWarningMessage(Messages.ALFWizardCreationAction_queryTitle, Messages.ALFWizardCreationAction_errorConfiguringSharedLibraryProject);
        }
        Debug.POLICY.exit(Debug.DEBUG_CREATE_ACTION_MORE, (Object)saveBuildStatus);
        return saveBuildStatus;
    }

    private boolean configureSharedLibraryProject64bit(IProject libProject, String spuProjectName) {
        Debug.POLICY.enter(Debug.DEBUG_CREATE_ACTION_MORE, new Object[]{libProject, spuProjectName});
        boolean saveBuildStatus = false;
        IConfiguration[] configs = ManagedBuildManager.getBuildInfo((IResource)libProject).getManagedProject().getConfigurations();
        IConfiguration configuration = null;
        int i = 0;
        while (i < configs.length) {
            if (configs[i].getId().startsWith("cell.managedbuild.config.cell.ppu.gnu64.so.debug")) {
                configuration = configs[i];
                break;
            }
            ++i;
        }
        ManagedBuildManager.performValueHandlerEvent(configuration, (int)1, (boolean)true);
        IToolChain toolChain = configuration.getToolChain();
        ITool embedSpuTool = toolChain.getToolsBySuperClassId("cell.managedbuild.tool.cell.ppu.gnu64.embedspu")[0];
        IOption embedSpuInputOption = embedSpuTool.getOptionBySuperClassId("cell.ppu.gnu.embedspu.option.inputs");
        ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)embedSpuTool, (IOption)embedSpuInputOption, (String[])new String[]{"\"${workspace_loc:/" + spuProjectName + "/spu-gnu-debug/" + spuProjectName + "}\""});
        saveBuildStatus = ManagedBuildManager.saveBuildInfo((IProject)libProject, (boolean)true);
        IManagedBuildInfo bi = ManagedBuildManager.getBuildInfo((IResource)libProject);
        if (bi != null & bi instanceof ManagedBuildInfo) {
            ((ManagedBuildInfo)bi).initializePathEntries();
        }
        if (this.is64bit) {
            ManagedBuildManager.setDefaultConfiguration((IProject)libProject, (IConfiguration)configuration);
            ManagedBuildManager.setSelectedConfiguration((IProject)libProject, (IConfiguration)configuration);
        }
        ManagedBuildManager.performValueHandlerEvent((IConfiguration)configuration, (int)4, (boolean)true);
        if (!saveBuildStatus) {
            Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, "Failed: {0}.", new Object[]{"configureSharedLibraryProject64bit"});
            this.wizard.logWarningMessage(Messages.ALFWizardCreationAction_queryTitle, Messages.ALFWizardCreationAction_errorConfiguringSharedLibraryProject);
        }
        Debug.POLICY.exit(Debug.DEBUG_CREATE_ACTION_MORE, (Object)saveBuildStatus);
        return saveBuildStatus;
    }

    private boolean configureSPUProject(IProject spuProject, String ppuProjectName) {
        Debug.POLICY.enter(Debug.DEBUG_CREATE_ACTION_MORE, new Object[]{spuProject, ppuProjectName});
        boolean saveBuildStatus = false;
        IConfiguration[] configs = ManagedBuildManager.getBuildInfo((IResource)spuProject).getManagedProject().getConfigurations();
        IConfiguration configuration = null;
        int i = 0;
        while (i < configs.length) {
            if (configs[i].getId().startsWith("cell.managedbuild.config.cell.spu.gnu.exe.debug")) {
                configuration = configs[i];
                break;
            }
            ++i;
        }
        ManagedBuildManager.performValueHandlerEvent(configuration, (int)1, (boolean)true);
        IToolChain toolChain = configuration.getToolChain();
        ITool linkerTool = toolChain.getToolsBySuperClassId("cell.managedbuild.tool.cell.spu.gnu.c.linker")[0];
        IOption libraryOption = linkerTool.getOptionBySuperClassId("cell.gnu.c.linker.option.libs");
        IOption librarySearchPathOption = linkerTool.getOptionBySuperClassId("gnu.c.link.option.paths");
        ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)linkerTool, (IOption)libraryOption, (String[])new String[]{"alf"});
        ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)linkerTool, (IOption)librarySearchPathOption, (String[])new String[]{"/opt/cell/sysroot/usr/spu/lib"});
        ITool compilerTool = toolChain.getToolsBySuperClassId("cell.managedbuild.tool.cell.spu.gnu.c.compiler.debug")[0];
        IOption includePathOption = compilerTool.getOptionBySuperClassId("gnu.c.compiler.option.include.paths");
        ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)compilerTool, (IOption)includePathOption, (String[])new String[]{"/opt/cell/sysroot/usr/spu/include", "\"${workspace_loc:/" + ppuProjectName + "}\""});
        saveBuildStatus = ManagedBuildManager.saveBuildInfo((IProject)spuProject, (boolean)true);
        IManagedBuildInfo bi = ManagedBuildManager.getBuildInfo((IResource)spuProject);
        if (bi != null & bi instanceof ManagedBuildInfo) {
            ((ManagedBuildInfo)bi).initializePathEntries();
        }
        ManagedBuildManager.performValueHandlerEvent((IConfiguration)configuration, (int)4, (boolean)true);
        if (!saveBuildStatus) {
            Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, "Failed: {0}.", new Object[]{"configureSPUProject"});
            this.wizard.logWarningMessage(Messages.ALFWizardCreationAction_queryTitle, Messages.ALFWizardCreationAction_errorConfiguringSpuProject);
        }
        Debug.POLICY.exit(Debug.DEBUG_CREATE_ACTION_MORE, (Object)saveBuildStatus);
        return saveBuildStatus;
    }

    private void cloneProjectConfigurations(IProject project) {
        IConfiguration[] configs = ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject().getConfigurations();
        int i = 0;
        while (i < configs.length) {
            ManagedBuildManager.performValueHandlerEvent((IConfiguration)configs[i], (int)1, (boolean)true);
            IToolChain tempToolChain = configs[i].getToolChain();
            this.cloneTools(tempToolChain, configs[i]);
            ManagedBuildManager.performValueHandlerEvent((IConfiguration)configs[i], (int)4, (boolean)true);
            ++i;
        }
    }

    private void cloneTools(IToolChain toolChain, IConfiguration configuration) {
        Debug.POLICY.enter(Debug.DEBUG_CREATE_ACTION_MORE, new Object[]{toolChain});
        ITool[] tools = toolChain.getTools();
        int i = 0;
        while (i < tools.length) {
            ITool newTool = toolChain.createTool(tools[i], ManagedBuildManager.calculateChildId((String)tools[i].getId(), null), tools[i].getName(), false);
            IOption[] options = tools[i].getOptions();
            int j = 0;
            while (j < options.length) {
                newTool.createOption(options[j], ManagedBuildManager.calculateChildId((String)options[j].getId(), null), options[j].getName(), false);
                ++j;
            }
            ++i;
        }
        toolChain.setDirty(true);
        Debug.POLICY.exit(Debug.DEBUG_CREATE_ACTION_MORE);
    }

    private IProject createProject(String name, String projectTypeID) throws InvocationTargetException {
        Debug.POLICY.enter(Debug.DEBUG_CREATE_ACTION_MORE, new Object[]{name, projectTypeID});
        IProject newProject = null;
        try {
            IStatus initResult;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject newProjectHandle = workspace.getRoot().getProject(name);
            IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
            if (Platform.getLocation().equals((Object)this.projectLocation)) {
                description.setLocation(null);
            } else {
                description.setLocation(this.projectLocation);
            }
            newProject = CCorePlugin.getDefault().createCProject(description, newProjectHandle, null, ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID);
            ManagedCProjectNature.addManagedNature((IProject)newProject, null);
            ManagedCProjectNature.addManagedBuilder((IProject)newProject, null);
            IManagedProject newManagedProject = null;
            ManagedBuildInfo info = null;
            info = ManagedBuildManager.createBuildInfo((IResource)newProject);
            IProjectType parent = ManagedBuildManager.getExtensionProjectType((String)projectTypeID);
            newManagedProject = ManagedBuildManager.createManagedProject((IResource)newProject, (IProjectType)parent);
            if (newManagedProject != null) {
                IConfiguration[] selectedConfigs = parent.getConfigurations();
                int i = 0;
                while (i < selectedConfigs.length) {
                    IConfiguration config = selectedConfigs[i];
                    int id = ManagedBuildManager.getRandomNumber();
                    IConfiguration newConfig = newManagedProject.createConfigurationClone(config, String.valueOf(config.getId()) + "." + id);
                    newConfig.setArtifactName(newManagedProject.getDefaultArtifactName());
                    ++i;
                }
                IConfiguration defaultCfg = null;
                IConfiguration[] newConfigs = newManagedProject.getConfigurations();
                int i2 = 0;
                while (i2 < newConfigs.length) {
                    if (newConfigs[i2].isSupported()) {
                        defaultCfg = newConfigs[i2];
                        break;
                    }
                    ++i2;
                }
                if (defaultCfg == null && newConfigs.length > 0) {
                    defaultCfg = newConfigs[0];
                }
                if (defaultCfg != null) {
                    ManagedBuildManager.setDefaultConfiguration((IProject)newProject, defaultCfg);
                    ManagedBuildManager.setSelectedConfiguration((IProject)newProject, (IConfiguration)defaultCfg);
                }
                ManagedBuildManager.setNewProjectVersion((IProject)newProject);
                ICDescriptor desc = null;
                try {
                    desc = CCorePlugin.getDefault().getCProjectDescription(newProject, true);
                    desc.create("org.eclipse.cdt.core.ScannerInfoProvider", ManagedBuildManager.INTERFACE_IDENTITY);
                }
                catch (CoreException e) {
                    Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, (Throwable)e);
                    throw e;
                }
                if (info != null) {
                    info.setValid(true);
                    ManagedBuildManager.saveBuildInfo((IProject)newProject, (boolean)true);
                }
            }
            if ((initResult = ManagedBuildManager.initBuildInfoContainer((IResource)newProject)).getCode() != 0) {
                Debug.POLICY.logStatus(initResult);
            }
            this.cloneProjectConfigurations(newProject);
        }
        catch (OperationCanceledException e) {
            Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, (Throwable)e);
            throw new InvocationTargetException(e, Messages.ALFWizardCreationAction_errorCreatingProject);
        }
        catch (CoreException e) {
            Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, (Throwable)e);
            throw new InvocationTargetException(e, Messages.ALFWizardCreationAction_errorCreatingProject);
        }
        catch (BuildException e) {
            Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, (Throwable)e);
            throw new InvocationTargetException(e, Messages.ALFWizardCreationAction_errorCreatingProject);
        }
        Debug.POLICY.exit(Debug.DEBUG_CREATE_ACTION_MORE, (Object)newProject);
        return newProject;
    }

    private Document createXMLParameterDocument(String outputDir, String date) throws InvocationTargetException, ParserConfigurationException {
        Debug.POLICY.enter(Debug.DEBUG_CREATE_ACTION_MORE, new Object[]{outputDir, date});
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document doc = parser.newDocument();
        Element alfRoot = doc.createElement(Messages.ALFWizardCreationAction_tag_alf);
        Element global = doc.createElement(Messages.ALFWizardCreationAction_tag_global);
        Element alfVersion = doc.createElement(Messages.ALFWizardCreationAction_tag_ALF_VERSION);
        Text alfVersionText = doc.createTextNode(Messages.ALFWizardCreationAction_alfVersion);
        alfVersion.appendChild(alfVersionText);
        Element dateTime = doc.createElement(Messages.ALFWizardCreationAction_tag_DATE_TIME);
        Text dateTimeText = doc.createTextNode(date);
        dateTime.appendChild(dateTimeText);
        Element templateDir = doc.createElement(Messages.ALFWizardCreationAction_tag_TEMPLATE_DIR);
        String tDirPath = Messages.ALFWizardCreationAction_templateDir;
        File tDir = new File(tDirPath);
        if (!tDir.exists()) {
            tDirPath = this.wizard.queryPathLocation(Messages.ALFWizardCreationAction_queryTitle, Messages.ALFWizardCreationAction_queryTemplateDirMessage, Messages.ALFWizardCreationAction_templateDir);
        }
        if (tDirPath == null) {
            throw new InvocationTargetException(new Exception(), Messages.ALFWizardCreationAction_errorTemplateDir);
        }
        Text templateDirText = doc.createTextNode(tDirPath);
        templateDir.appendChild(templateDirText);
        Element targetDir = doc.createElement(Messages.ALFWizardCreationAction_tag_TARGET_DIR);
        Text targetDirText = doc.createTextNode(outputDir);
        targetDir.appendChild(targetDirText);
        Element projectName = doc.createElement(Messages.ALFWizardCreationAction_tag_PROJECT_NAME);
        Text projectNameText = doc.createTextNode(this.projectName);
        projectName.appendChild(projectNameText);
        Element stackSize = doc.createElement(Messages.ALFWizardCreationAction_tag_STACK_SIZE);
        Text stackSizeText = doc.createTextNode(String.valueOf(this.stackSize));
        stackSize.appendChild(stackSizeText);
        Element partitionMethod = doc.createElement(Messages.ALFWizardCreationAction_tag_PARTITION_METHOD);
        Text partitionMethodText = doc.createTextNode(String.valueOf(this.partitionMethod));
        partitionMethod.appendChild(partitionMethodText);
        Element expAccelNum = doc.createElement(Messages.ALFWizardCreationAction_tag_EXP_ACCEL_NUM);
        Text expAccelNumText = doc.createTextNode(String.valueOf(this.expAccelNum));
        expAccelNum.appendChild(expAccelNumText);
        Element bufferNumber = doc.createElement(Messages.ALFWizardCreationAction_tag_BUFFER_NUMBER);
        Text bufferNumberText = doc.createTextNode(String.valueOf(this.buffers.size()));
        bufferNumber.appendChild(bufferNumberText);
        doc.appendChild(alfRoot);
        alfRoot.appendChild(global);
        global.appendChild(alfVersion);
        global.appendChild(dateTime);
        global.appendChild(templateDir);
        global.appendChild(targetDir);
        global.appendChild(projectName);
        global.appendChild(stackSize);
        global.appendChild(partitionMethod);
        global.appendChild(expAccelNum);
        global.appendChild(bufferNumber);
        int i = 0;
        while (i < this.buffers.size()) {
            ALFBuffer buf = (ALFBuffer)this.buffers.get(i);
            Element buffer = doc.createElement(Messages.ALFWizardCreationAction_tag_buffer);
            alfRoot.appendChild(buffer);
            Element variableName = doc.createElement(Messages.ALFWizardCreationAction_tag_VARIABLE_NAME);
            Text variableNameText = doc.createTextNode(buf.getName());
            variableName.appendChild(variableNameText);
            Element elementType = doc.createElement(Messages.ALFWizardCreationAction_tag_ELEMENT_TYPE);
            Text elementTypeText = doc.createTextNode(buf.getElementType());
            elementType.appendChild(elementTypeText);
            Element elementUnit = doc.createElement(Messages.ALFWizardCreationAction_tag_ELEMENT_UNIT);
            String tempString = null;
            switch (buf.getElementUnit()) {
                case 0: {
                    tempString = Messages.ALFWizardCreationAction_elementUnitByte;
                    break;
                }
                case 1: {
                    tempString = Messages.ALFWizardCreationAction_elementUnitInt16;
                    break;
                }
                case 2: {
                    tempString = Messages.ALFWizardCreationAction_elementUnitInt32;
                    break;
                }
                case 3: {
                    tempString = Messages.ALFWizardCreationAction_elementUnitInt64;
                    break;
                }
                case 4: {
                    tempString = Messages.ALFWizardCreationAction_elementUnitFloat;
                    break;
                }
                case 5: {
                    tempString = Messages.ALFWizardCreationAction_elementUnitDouble;
                    break;
                }
                case 6: {
                    tempString = Messages.ALFWizardCreationAction_elementUnitAddr32;
                    break;
                }
                case 7: {
                    tempString = Messages.ALFWizardCreationAction_elementUnitAddr64;
                    break;
                }
                case 8: {
                    tempString = buf.getElementType();
                    break;
                }
                default: {
                    tempString = null;
                }
            }
            Text elementUnitText = doc.createTextNode(tempString);
            elementUnit.appendChild(elementUnitText);
            Element bufferType = doc.createElement(Messages.ALFWizardCreationAction_tag_BUFFER_TYPE);
            tempString = null;
            switch (buf.getBufferType()) {
                case 0: {
                    tempString = Messages.ALFWizardCreationAction_bufferTypeInput;
                    break;
                }
                case 1: {
                    tempString = Messages.ALFWizardCreationAction_bufferTypeOutput;
                    break;
                }
                default: {
                    tempString = null;
                }
            }
            Text bufferTypeText = doc.createTextNode(tempString);
            bufferType.appendChild(bufferTypeText);
            Element numDimension = doc.createElement(Messages.ALFWizardCreationAction_tag_NUM_DIMENSION);
            int actualNumDim = buf.getNumDimensions() + 1;
            Text numDimensionText = doc.createTextNode(String.valueOf(actualNumDim));
            numDimension.appendChild(numDimensionText);
            Element dimensionSizeX = doc.createElement(Messages.ALFWizardCreationAction_tag_DIMENSION_SIZE_X);
            Text dimensionSizeXText = doc.createTextNode(String.valueOf(buf.getDimensionSizeX()));
            dimensionSizeX.appendChild(dimensionSizeXText);
            Element dimensionSizeY = doc.createElement(Messages.ALFWizardCreationAction_tag_DIMENSION_SIZE_Y);
            Text dimensionSizeYText = doc.createTextNode(String.valueOf(buf.getDimensionSizeY()));
            dimensionSizeY.appendChild(dimensionSizeYText);
            Element dimensionSizeZ = doc.createElement(Messages.ALFWizardCreationAction_tag_DIMENSION_SIZE_Z);
            Text dimensionSizeZText = doc.createTextNode(String.valueOf(buf.getDimensionSizeZ()));
            dimensionSizeZ.appendChild(dimensionSizeZText);
            Element distributionModelX = doc.createElement(Messages.ALFWizardCreationAction_tag_DISTRIBUTION_MODEL_X);
            tempString = null;
            switch (buf.getDistributionModelX()) {
                case 0: {
                    tempString = Messages.ALFWizardCreationAction_distributionModelStar;
                    break;
                }
                case 1: {
                    tempString = Messages.ALFWizardCreationAction_distributionModelBlock;
                    break;
                }
                case 2: {
                    tempString = Messages.ALFWizardCreationAction_distributionModelCyclic;
                    break;
                }
                default: {
                    tempString = null;
                }
            }
            Text distributionModelXText = doc.createTextNode(tempString);
            distributionModelX.appendChild(distributionModelXText);
            Element distributionModelY = doc.createElement(Messages.ALFWizardCreationAction_tag_DISTRIBUTION_MODEL_Y);
            tempString = null;
            switch (buf.getDistributionModelY()) {
                case 0: {
                    tempString = Messages.ALFWizardCreationAction_distributionModelStar;
                    break;
                }
                case 1: {
                    tempString = Messages.ALFWizardCreationAction_distributionModelBlock;
                    break;
                }
                case 2: {
                    tempString = Messages.ALFWizardCreationAction_distributionModelCyclic;
                    break;
                }
                default: {
                    tempString = null;
                }
            }
            Text distributionModelYText = doc.createTextNode(tempString);
            distributionModelY.appendChild(distributionModelYText);
            Element distributionModelZ = doc.createElement(Messages.ALFWizardCreationAction_tag_DISTRIBUTION_MODEL_Z);
            tempString = null;
            switch (buf.getDistributionModelZ()) {
                case 0: {
                    tempString = Messages.ALFWizardCreationAction_distributionModelStar;
                    break;
                }
                case 1: {
                    tempString = Messages.ALFWizardCreationAction_distributionModelBlock;
                    break;
                }
                case 2: {
                    tempString = Messages.ALFWizardCreationAction_distributionModelCyclic;
                    break;
                }
                default: {
                    tempString = null;
                }
            }
            Text distributionModelZText = doc.createTextNode(tempString);
            distributionModelZ.appendChild(distributionModelZText);
            Element distributionSizeX = doc.createElement(Messages.ALFWizardCreationAction_tag_DISTRIBUTION_SIZE_X);
            Text distributionSizeXText = doc.createTextNode(String.valueOf(buf.getDistributionSizeX()));
            distributionSizeX.appendChild(distributionSizeXText);
            Element distributionSizeY = doc.createElement(Messages.ALFWizardCreationAction_tag_DISTRIBUTION_SIZE_Y);
            Text distributionSizeYText = doc.createTextNode(String.valueOf(buf.getDistributionSizeY()));
            distributionSizeY.appendChild(distributionSizeYText);
            Element distributionSizeZ = doc.createElement(Messages.ALFWizardCreationAction_tag_DISTRIBUTION_SIZE_Z);
            Text distributionSizeZText = doc.createTextNode(String.valueOf(buf.getDistributionSizeZ()));
            distributionSizeZ.appendChild(distributionSizeZText);
            buffer.appendChild(variableName);
            buffer.appendChild(elementType);
            buffer.appendChild(elementUnit);
            buffer.appendChild(bufferType);
            buffer.appendChild(numDimension);
            int numDim = buf.getNumDimensions();
            switch (numDim) {
                case 0: {
                    buffer.appendChild(dimensionSizeX);
                    buffer.appendChild(distributionModelX);
                    buffer.appendChild(distributionSizeX);
                    break;
                }
                case 1: {
                    buffer.appendChild(dimensionSizeX);
                    buffer.appendChild(dimensionSizeY);
                    buffer.appendChild(distributionModelX);
                    buffer.appendChild(distributionSizeX);
                    buffer.appendChild(distributionModelY);
                    buffer.appendChild(distributionSizeY);
                    break;
                }
                case 2: {
                    buffer.appendChild(dimensionSizeX);
                    buffer.appendChild(dimensionSizeY);
                    buffer.appendChild(dimensionSizeZ);
                    buffer.appendChild(distributionModelX);
                    buffer.appendChild(distributionSizeX);
                    buffer.appendChild(distributionModelY);
                    buffer.appendChild(distributionSizeY);
                    buffer.appendChild(distributionModelZ);
                    buffer.appendChild(distributionSizeZ);
                    break;
                }
                default: {
                    throw new InvocationTargetException(new Exception(), Messages.ALFWizardCreationAction_errorCreatingParamFileMsg);
                }
            }
            ++i;
        }
        Debug.POLICY.exit(Debug.DEBUG_CREATE_ACTION_MORE, (Object)doc);
        return doc;
    }

    private static void copyFile(String src, String dst) throws InvocationTargetException {
        Debug.POLICY.enter(Debug.DEBUG_CREATE_ACTION_MORE, new Object[]{src, dst});
        try {
            FileChannel srcChannel = new FileInputStream(src).getChannel();
            FileChannel dstChannel = new FileOutputStream(dst).getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
        }
        catch (FileNotFoundException e) {
            Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, (Throwable)e);
            throw new InvocationTargetException(e, Messages.ALFWizardCreationAction_errorSourceFilesNotFound);
        }
        catch (IOException e) {
            Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, (Throwable)e);
            throw new InvocationTargetException(e, Messages.ALFWizardCreationAction_errorCopyingFiles);
        }
        Debug.POLICY.exit(Debug.DEBUG_CREATE_ACTION_MORE);
    }

    private File createXMLParameterFile(Document doc, File tmpDir) throws InvocationTargetException, TransformerException {
        Debug.POLICY.enter(Debug.DEBUG_CREATE_ACTION_MORE, new Object[]{doc, tmpDir});
        try {
            File xmlFile = new File(tmpDir, Messages.ALFWizardCreationAction_xmlParamFileName);
            if (!xmlFile.exists()) {
                xmlFile.createNewFile();
            }
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            Transformer aTransformer = tranFactory.newTransformer();
            DOMSource src = new DOMSource(doc);
            StreamResult dest = new StreamResult(xmlFile.getPath());
            aTransformer.transform(src, dest);
            Debug.POLICY.exit(Debug.DEBUG_CREATE_ACTION_MORE, (Object)xmlFile);
            return xmlFile;
        }
        catch (IOException e) {
            Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, (Throwable)e);
            throw new InvocationTargetException(e, Messages.ALFWizardCreationAction_errorCreatingParamFileMsg);
        }
    }

    private void deleteDir(File file) {
        Debug.POLICY.pass(Debug.DEBUG_CREATE_ACTION_MORE, new Object[]{file});
        if (file == null) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                this.deleteDir(files[i]);
                ++i;
            }
            file.delete();
        }
    }

    private String getDate() {
        String second;
        String minute;
        String hour;
        String day;
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        String month = String.valueOf(cal.get(2) + 1);
        if (month.length() == 1) {
            month = "0" + month;
        }
        if ((day = String.valueOf(cal.get(5))).length() == 1) {
            day = "0" + day;
        }
        if ((hour = String.valueOf(cal.get(11))).length() == 1) {
            hour = "0" + hour;
        }
        if ((minute = String.valueOf(cal.get(12))).length() == 1) {
            minute = "0" + minute;
        }
        if ((second = String.valueOf(cal.get(13))).length() == 1) {
            second = "0" + second;
        }
        return String.valueOf(cal.get(1)) + "-" + month + "-" + day + "_" + hour + ":" + minute + ":" + second;
    }

    private void importFiles(IProgressMonitor monitor, String tmpDirPath, IProject ppuProject, IProject spuProject) throws InvocationTargetException, InterruptedException {
        Debug.POLICY.enter(Debug.DEBUG_CREATE_ACTION_MORE, new Object[]{tmpDirPath, ppuProject, spuProject});
        try {
            String ppuFilePath = String.valueOf(tmpDirPath) + PATH_SEPERATOR + "host" + PATH_SEPERATOR + "ppu_" + this.projectName + ".c";
            File ppuFile = new File(ppuFilePath);
            String spuFilePath = String.valueOf(tmpDirPath) + PATH_SEPERATOR + "accel" + PATH_SEPERATOR + "spu_" + this.projectName + ".c";
            File spuFile = new File(spuFilePath);
            if (!ppuFile.exists() || !spuFile.exists()) {
                throw new InvocationTargetException(new Exception(), Messages.ALFWizardCreationAction_errorSourceFilesNotFound);
            }
            File newPPUFile = new File(String.valueOf(ppuProject.getLocation().toString()) + PATH_SEPERATOR + "ppu_" + this.projectName + ".c");
            newPPUFile.createNewFile();
            ALFWizardCreationAction.copyFile(ppuFile.getAbsolutePath(), newPPUFile.getAbsolutePath());
            if (monitor.isCanceled()) {
                throw new InterruptedException(Messages.ALFWizardCreationAction_canceled);
            }
            File newSPUFile = new File(String.valueOf(spuProject.getLocation().toString()) + PATH_SEPERATOR + "spu_" + this.projectName + ".c");
            newSPUFile.createNewFile();
            ALFWizardCreationAction.copyFile(spuFile.getAbsolutePath(), newSPUFile.getAbsolutePath());
            if (monitor.isCanceled()) {
                throw new InterruptedException(Messages.ALFWizardCreationAction_canceled);
            }
            File headerFile = new File(String.valueOf(tmpDirPath) + PATH_SEPERATOR + "common.h");
            if (!headerFile.exists()) {
                throw new InvocationTargetException(new Exception(), Messages.ALFWizardCreationAction_errorHeaderFileNotFound);
            }
            File newHeaderFile = new File(String.valueOf(ppuProject.getLocation().toString()) + PATH_SEPERATOR + "common.h");
            newHeaderFile.createNewFile();
            ALFWizardCreationAction.copyFile(headerFile.getAbsolutePath(), newHeaderFile.getAbsolutePath());
            if (monitor.isCanceled()) {
                throw new InterruptedException(Messages.ALFWizardCreationAction_canceled);
            }
            File hostHeaderFile = new File(String.valueOf(tmpDirPath) + PATH_SEPERATOR + "host" + PATH_SEPERATOR + "ppu_" + this.projectName + ".h");
            if (!hostHeaderFile.exists()) {
                throw new InvocationTargetException(new Exception(), Messages.ALFWizardCreationAction_errorHeaderFileNotFound);
            }
            File newHostHeaderFile = new File(String.valueOf(ppuProject.getLocation().toString()) + PATH_SEPERATOR + "ppu_" + this.projectName + ".h");
            newHostHeaderFile.createNewFile();
            ALFWizardCreationAction.copyFile(hostHeaderFile.getAbsolutePath(), newHostHeaderFile.getAbsolutePath());
            if (monitor.isCanceled()) {
                throw new InterruptedException(Messages.ALFWizardCreationAction_canceled);
            }
        }
        catch (IOException e) {
            Debug.POLICY.error(Debug.DEBUG_CREATE_ACTION_MORE, (Throwable)e);
            throw new InvocationTargetException(e, Messages.ALFWizardCreationAction_errorCopyingFiles);
        }
        Debug.POLICY.exit(Debug.DEBUG_CREATE_ACTION_MORE);
    }
}

